/*     */ package com.arjuna.ats.txoj.semaphore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.gandiva.inventory.Inventory;
/*     */ import com.arjuna.ats.internal.txoj.Implementations;
/*     */ import com.arjuna.ats.txoj.TxOJNames;
/*     */ import java.io.IOException;
/*     */ 
/*     */ public class Semaphore
/*     */ {
/*     */   public static final int SM_LOCKED = 0;
/*     */   public static final int SM_UNLOCKED = 1;
/*     */   public static final int SM_WOULD_BLOCK = 2;
/*     */   public static final int SM_ERROR = 3;
/*     */   private SemaphoreImple _imple;
/*     */ 
/*     */   public Semaphore(String key)
/*     */   {
/*  66 */     Object[] param = new Object[1];
/*     */ 
/*  68 */     param[0] = key;
/*     */ 
/*  70 */     Object ptr = Inventory.inventory().createResources(TxOJNames.Implementation_Semaphore_BasicSemaphore(), param);
/*     */ 
/*  72 */     if ((ptr instanceof SemaphoreImple))
/*  73 */       this._imple = ((SemaphoreImple)ptr);
/*     */     else
/*  75 */       this._imple = null;
/*     */   }
/*     */ 
/*     */   public Semaphore(ClassName type)
/*     */   {
/*  80 */     Object ptr = Inventory.inventory().createVoid(type);
/*     */ 
/*  82 */     if ((ptr instanceof SemaphoreImple))
/*  83 */       this._imple = ((SemaphoreImple)ptr);
/*     */     else
/*  85 */       this._imple = null;
/*     */   }
/*     */ 
/*     */   public Semaphore(ObjectName objName)
/*     */   {
/*  90 */     this._imple = null;
/*     */ 
/*  92 */     if (objName != null)
/*     */     {
/*     */       try
/*     */       {
/*  96 */         ClassName semaphoreType = objName.getClassNameAttribute("SemaphoreType");
/*  97 */         ObjectName semaphoreName = objName.getObjectNameAttribute("SemaphoreName");
/*     */ 
/*  99 */         Object ptr = Inventory.inventory().createObjectName(semaphoreType, semaphoreName);
/*     */ 
/* 101 */         if ((ptr instanceof SemaphoreImple))
/* 102 */           this._imple = ((SemaphoreImple)ptr);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 112 */     this._imple = null;
/*     */   }
/*     */ 
/*     */   public int lock()
/*     */   {
/* 117 */     return this._imple != null ? this._imple.lock() : 3;
/*     */   }
/*     */ 
/*     */   public int unlock()
/*     */   {
/* 122 */     return this._imple != null ? this._imple.unlock() : 3;
/*     */   }
/*     */ 
/*     */   public int tryLock()
/*     */   {
/* 127 */     return this._imple != null ? this._imple.tryLock() : 3;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 132 */     return this._imple != null ? this._imple.className() : ClassName.invalid();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 139 */     if (!Implementations.added())
/* 140 */       Implementations.initialise();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.txoj.semaphore.Semaphore
 * JD-Core Version:    0.6.0
 */