/*    */ package com.arjuna.common;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.util.Properties;
/*    */ 
/*    */ public class Info
/*    */ {
/*    */   private static final Properties PROPS;
/*    */ 
/*    */   public String toString()
/*    */   {
/* 50 */     StringBuffer moduleInfo = new StringBuffer();
/*    */ 
/* 52 */     moduleInfo.append("<module-info name=\"" + getBuildTimeProperty("MODULE") + "\">");
/* 53 */     moduleInfo.append("<source-identifier>" + getBuildTimeProperty("SOURCEID") + "</source-identifier>");
/* 54 */     moduleInfo.append("<build-information>" + getBuildTimeProperty("BUILDINFO") + "</build-information>");
/* 55 */     moduleInfo.append("<version>" + getBuildTimeProperty("VERSION") + "</version>");
/* 56 */     moduleInfo.append("<date>" + getBuildTimeProperty("DATE") + "</date>");
/* 57 */     moduleInfo.append("<notes>" + getBuildTimeProperty("NOTES") + "</notes>");
/* 58 */     moduleInfo.append("</module-info>");
/*    */ 
/* 60 */     return moduleInfo.toString();
/*    */   }
/*    */ 
/*    */   private static String getBuildTimeProperty(String name)
/*    */   {
/* 65 */     if (PROPS == null)
/*    */     {
/* 67 */       return "";
/*    */     }
/*    */ 
/* 71 */     return PROPS.getProperty(name, "");
/*    */   }
/*    */ 
/*    */   static
/*    */   {
/* 79 */     InputStream is = Info.class.getResourceAsStream("/common.properties");
/* 80 */     if (is != null)
/*    */     {
/* 82 */       Properties props = new Properties();
/*    */       try
/*    */       {
/* 85 */         props.load(is);
/*    */       }
/*    */       catch (IOException ioe)
/*    */       {
/* 89 */         props = null;
/*    */       }
/* 91 */       PROPS = props;
/*    */     }
/*    */     else
/*    */     {
/* 95 */       PROPS = null;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.Info
 * JD-Core Version:    0.6.0
 */