/*     */ package com.arjuna.common.internal.util.logging;
/*     */ 
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.text.DateFormat;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Date;
/*     */ import java.util.Properties;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogConfigurationException;
/*     */ 
/*     */ public class DefaultLog
/*     */   implements Log
/*     */ {
/*     */   static final String LOG_ENABLED_PROPERTY = "com.arjuna.common.util.logging.default";
/*     */   static final String LOG_LEVEL = "com.arjuna.common.util.logging.default.level";
/*     */   static final String SHOW_LOG_NAME = "com.arjuna.common.util.logging.default.showLogName";
/*     */   static final String SHOW_SHORT_LOG_NAME = "com.arjuna.common.util.logging.default.showShortLogName";
/*     */   static final String SHOW_DATE = "com.arjuna.common.util.logging.default.showDate";
/*     */   static final String LOG_FILE = "com.arjuna.common.util.logging.default.logFile";
/*     */   static final String LOG_FILE_APPEND = "com.arjuna.common.util.logging.default.logFileAppend";
/*     */   static final String LOG_FILE_DEFAULT = "error.log";
/* 139 */   protected static final Properties simpleLogProps = new Properties();
/*     */ 
/* 142 */   protected static boolean showLogName = false;
/*     */ 
/* 147 */   protected static boolean showShortName = true;
/*     */ 
/* 149 */   protected static boolean showDateTime = true;
/*     */ 
/* 151 */   protected static DateFormat dateFormatter = null;
/*     */ 
/* 153 */   static PrintStream defaultLogFile = null;
/*     */   public static final int LOG_LEVEL_TRACE = 1;
/*     */   public static final int LOG_LEVEL_DEBUG = 2;
/*     */   public static final int LOG_LEVEL_INFO = 3;
/*     */   public static final int LOG_LEVEL_WARN = 4;
/*     */   public static final int LOG_LEVEL_ERROR = 5;
/*     */   public static final int LOG_LEVEL_FATAL = 6;
/*     */   public static final int LOG_LEVEL_ALL = 0;
/*     */   public static final int LOG_LEVEL_OFF = 7;
/* 249 */   protected String logName = null;
/*     */   protected int currentLogLevel;
/* 253 */   private String prefix = null;
/*     */ 
/*     */   private static String getStringProperty(String name)
/*     */   {
/* 208 */     String prop = commonPropertyManager.propertyManager.getProperty(name);
/*     */ 
/* 211 */     if (prop == null) {
/* 212 */       prop = System.getProperty(name);
/*     */     }
/* 214 */     return prop == null ? simpleLogProps.getProperty(name) : prop;
/*     */   }
/*     */ 
/*     */   private static String getStringProperty(String name, String dephault) {
/* 218 */     String prop = getStringProperty(name);
/* 219 */     return prop == null ? dephault : prop;
/*     */   }
/*     */ 
/*     */   private static boolean getBooleanProperty(String name, boolean dephault) {
/* 223 */     String prop = getStringProperty(name);
/* 224 */     return prop == null ? dephault : "true".equalsIgnoreCase(prop);
/*     */   }
/*     */ 
/*     */   public DefaultLog(String name)
/*     */   {
/* 265 */     this.logName = name;
/*     */ 
/* 270 */     setLevel(2);
/*     */ 
/* 285 */     String lvl = commonPropertyManager.propertyManager.getProperty("com.arjuna.common.util.logging.default.level", null);
/*     */ 
/* 288 */     if (lvl == null) {
/* 289 */       lvl = System.getProperty("com.arjuna.common.util.logging.default.level", "info");
/*     */     }
/*     */ 
/* 292 */     if ("all".equalsIgnoreCase(lvl))
/* 293 */       setLevel(0);
/* 294 */     else if ("trace".equalsIgnoreCase(lvl))
/* 295 */       setLevel(1);
/* 296 */     else if ("debug".equalsIgnoreCase(lvl))
/* 297 */       setLevel(2);
/* 298 */     else if ("info".equalsIgnoreCase(lvl))
/* 299 */       setLevel(3);
/* 300 */     else if ("warn".equalsIgnoreCase(lvl))
/* 301 */       setLevel(4);
/* 302 */     else if ("error".equalsIgnoreCase(lvl))
/* 303 */       setLevel(5);
/* 304 */     else if ("fatal".equalsIgnoreCase(lvl))
/* 305 */       setLevel(6);
/* 306 */     else if ("off".equalsIgnoreCase(lvl))
/* 307 */       setLevel(7);
/*     */   }
/*     */ 
/*     */   public void setLevel(int currentLogLevel)
/*     */   {
/* 322 */     this.currentLogLevel = currentLogLevel;
/*     */   }
/*     */ 
/*     */   public int getLevel()
/*     */   {
/* 332 */     return this.currentLogLevel;
/*     */   }
/*     */ 
/*     */   protected void log(int type, Object message, Throwable t)
/*     */   {
/* 346 */     StringBuffer buf = new StringBuffer();
/*     */ 
/* 349 */     if (showDateTime) {
/* 350 */       buf.append(dateFormatter.format(new Date()));
/* 351 */       buf.append(" ");
/*     */     }
/*     */ 
/* 355 */     switch (type) { case 1:
/* 356 */       buf.append("[TRACE] "); break;
/*     */     case 2:
/* 357 */       buf.append("[DEBUG] "); break;
/*     */     case 3:
/* 358 */       buf.append("[INFO] "); break;
/*     */     case 4:
/* 359 */       buf.append("[WARN] "); break;
/*     */     case 5:
/* 360 */       buf.append("[ERROR] "); break;
/*     */     case 6:
/* 361 */       buf.append("[FATAL] ");
/*     */     }
/*     */ 
/* 365 */     if (showShortName) {
/* 366 */       if (this.prefix == null)
/*     */       {
/* 368 */         this.prefix = (this.logName.substring(this.logName.lastIndexOf(".") + 1) + " - ");
/* 369 */         this.prefix = (this.prefix.substring(this.prefix.lastIndexOf("/") + 1) + "-");
/*     */       }
/* 371 */       buf.append(this.prefix);
/* 372 */     } else if (showLogName) {
/* 373 */       buf.append(String.valueOf(this.logName)).append(" - ");
/*     */     }
/*     */ 
/* 377 */     buf.append(String.valueOf(message));
/*     */ 
/* 380 */     if (t != null) {
/* 381 */       buf.append(" <");
/* 382 */       buf.append(t.toString());
/* 383 */       buf.append(">");
/*     */ 
/* 385 */       StringWriter sw = new StringWriter(1024);
/* 386 */       PrintWriter pw = new PrintWriter(sw);
/* 387 */       t.printStackTrace(pw);
/* 388 */       pw.close();
/* 389 */       buf.append(sw.toString());
/*     */     }
/*     */ 
/* 393 */     defaultLogFile.println(buf.toString());
/*     */   }
/*     */ 
/*     */   protected boolean isLevelEnabled(int logLevel)
/*     */   {
/* 405 */     return logLevel >= this.currentLogLevel;
/*     */   }
/*     */ 
/*     */   public final void debug(Object message)
/*     */   {
/* 417 */     if (isLevelEnabled(2))
/* 418 */       log(2, message, null);
/*     */   }
/*     */ 
/*     */   public final void debug(Object message, Throwable t)
/*     */   {
/* 428 */     if (isLevelEnabled(2))
/* 429 */       log(2, message, t);
/*     */   }
/*     */ 
/*     */   public final void trace(Object message)
/*     */   {
/* 439 */     if (isLevelEnabled(1))
/* 440 */       log(1, message, null);
/*     */   }
/*     */ 
/*     */   public final void trace(Object message, Throwable t)
/*     */   {
/* 450 */     if (isLevelEnabled(1))
/* 451 */       log(1, message, t);
/*     */   }
/*     */ 
/*     */   public final void info(Object message)
/*     */   {
/* 461 */     if (isLevelEnabled(3))
/* 462 */       log(3, message, null);
/*     */   }
/*     */ 
/*     */   public final void info(Object message, Throwable t)
/*     */   {
/* 472 */     if (isLevelEnabled(3))
/* 473 */       log(3, message, t);
/*     */   }
/*     */ 
/*     */   public final void warn(Object message)
/*     */   {
/* 483 */     if (isLevelEnabled(4))
/* 484 */       log(4, message, null);
/*     */   }
/*     */ 
/*     */   public final void warn(Object message, Throwable t)
/*     */   {
/* 494 */     if (isLevelEnabled(4))
/* 495 */       log(4, message, t);
/*     */   }
/*     */ 
/*     */   public final void error(Object message)
/*     */   {
/* 505 */     if (isLevelEnabled(5))
/* 506 */       log(5, message, null);
/*     */   }
/*     */ 
/*     */   public final void error(Object message, Throwable t)
/*     */   {
/* 516 */     if (isLevelEnabled(5))
/* 517 */       log(5, message, t);
/*     */   }
/*     */ 
/*     */   public final void fatal(Object message)
/*     */   {
/* 527 */     if (isLevelEnabled(6))
/* 528 */       log(6, message, null);
/*     */   }
/*     */ 
/*     */   public final void fatal(Object message, Throwable t)
/*     */   {
/* 538 */     if (isLevelEnabled(6))
/* 539 */       log(6, message, t);
/*     */   }
/*     */ 
/*     */   public final boolean isDebugEnabled()
/*     */   {
/* 553 */     return isLevelEnabled(2);
/*     */   }
/*     */ 
/*     */   public final boolean isErrorEnabled()
/*     */   {
/* 566 */     return isLevelEnabled(5);
/*     */   }
/*     */ 
/*     */   public final boolean isFatalEnabled()
/*     */   {
/* 579 */     return isLevelEnabled(6);
/*     */   }
/*     */ 
/*     */   public final boolean isInfoEnabled()
/*     */   {
/* 592 */     return isLevelEnabled(3);
/*     */   }
/*     */ 
/*     */   public final boolean isTraceEnabled()
/*     */   {
/* 605 */     return isLevelEnabled(1);
/*     */   }
/*     */ 
/*     */   public final boolean isWarnEnabled()
/*     */   {
/* 618 */     return isLevelEnabled(4);
/*     */   }
/*     */ 
/*     */   private static ClassLoader getContextClassLoader()
/*     */   {
/* 634 */     ClassLoader classLoader = null;
/*     */ 
/* 636 */     if (classLoader == null) {
/*     */       try
/*     */       {
/* 639 */         Method method = Thread.class.getMethod("getContextClassLoader", (Class[])null);
/*     */         try
/*     */         {
/* 643 */           classLoader = (ClassLoader)method.invoke(Thread.currentThread(), (Object[])null);
/*     */         }
/*     */         catch (IllegalAccessException e)
/*     */         {
/*     */         }
/*     */         catch (InvocationTargetException e)
/*     */         {
/* 663 */           if (!(e.getTargetException() instanceof SecurityException))
/*     */           {
/* 668 */             throw new LogConfigurationException("Unexpected InvocationTargetException", e.getTargetException());
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 678 */     if (classLoader == null) {
/* 679 */       classLoader = DefaultLog.class.getClassLoader();
/*     */     }
/*     */ 
/* 683 */     return classLoader;
/*     */   }
/*     */ 
/*     */   private static InputStream getResourceAsStream(String name)
/*     */   {
/* 688 */     return (InputStream)AccessController.doPrivileged(new PrivilegedAction(name)
/*     */     {
/*     */       public Object run() {
/* 691 */         ClassLoader threadCL = DefaultLog.access$000();
/*     */ 
/* 693 */         if (threadCL != null) {
/* 694 */           return threadCL.getResourceAsStream(this.val$name);
/*     */         }
/* 696 */         return ClassLoader.getSystemResourceAsStream(this.val$name);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 156 */     showLogName = getBooleanProperty("com.arjuna.common.util.logging.default.showLogName", showLogName);
/* 157 */     showShortName = getBooleanProperty("com.arjuna.common.util.logging.default.showShortLogName", showShortName);
/* 158 */     showDateTime = getBooleanProperty("com.arjuna.common.util.logging.default.showDate", showDateTime);
/* 159 */     showLogName = getBooleanProperty("com.arjuna.common.util.logging.default.showLogName", showLogName);
/*     */ 
/* 162 */     dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");
/*     */ 
/* 164 */     String fileName = getStringProperty("com.arjuna.common.util.logging.default.logFile", "error.log");
/* 165 */     boolean fileAppend = getBooleanProperty("com.arjuna.common.util.logging.default.logFileAppend", true);
/*     */     try
/*     */     {
/* 168 */       FileOutputStream fOut = new FileOutputStream(fileName, fileAppend);
/* 169 */       defaultLogFile = new PrintStream(fOut, true);
/* 170 */       defaultLogFile.println();
/* 171 */       defaultLogFile.println();
/* 172 */       defaultLogFile.println("---------------------------------------------------------------");
/* 173 */       defaultLogFile.println("DEFAULT LOG, started " + dateFormatter.format(new Date()));
/* 174 */       defaultLogFile.println("---------------------------------------------------------------");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 178 */       System.err.println("cannot set up default log for error messages to file " + fileName + ": " + e.getMessage());
/* 179 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.internal.util.logging.DefaultLog
 * JD-Core Version:    0.6.0
 */