/*     */ package com.arjuna.common.internal.util.logging.jakarta;
/*     */ 
/*     */ import com.arjuna.common.internal.util.logging.LogImpl;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.log4j.Logger;
/*     */ import org.apache.log4j.Priority;
/*     */ 
/*     */ public final class Log4JLogger
/*     */   implements Log
/*     */ {
/* 125 */   private static final String FQCN = LogImpl.class.getName();
/*     */ 
/* 128 */   private Logger logger = null;
/*     */ 
/*     */   public Log4JLogger()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Log4JLogger(String name)
/*     */   {
/* 141 */     this.logger = Logger.getLogger(name);
/*     */   }
/*     */ 
/*     */   public Log4JLogger(Logger logger)
/*     */   {
/* 147 */     this.logger = logger;
/*     */   }
/*     */ 
/*     */   public void trace(Object message)
/*     */   {
/* 159 */     this.logger.log(FQCN, Priority.DEBUG, message, null);
/*     */   }
/*     */ 
/*     */   public void trace(Object message, Throwable t)
/*     */   {
/* 168 */     this.logger.log(FQCN, Priority.DEBUG, message, t);
/*     */   }
/*     */ 
/*     */   public void debug(Object message)
/*     */   {
/* 176 */     this.logger.log(FQCN, Priority.DEBUG, message, null);
/*     */   }
/*     */ 
/*     */   public void debug(Object message, Throwable t)
/*     */   {
/* 183 */     this.logger.log(FQCN, Priority.DEBUG, message, t);
/*     */   }
/*     */ 
/*     */   public void info(Object message)
/*     */   {
/* 191 */     this.logger.log(FQCN, Priority.INFO, message, null);
/*     */   }
/*     */ 
/*     */   public void info(Object message, Throwable t)
/*     */   {
/* 199 */     this.logger.log(FQCN, Priority.INFO, message, t);
/*     */   }
/*     */ 
/*     */   public void warn(Object message)
/*     */   {
/* 207 */     this.logger.log(FQCN, Priority.WARN, message, null);
/*     */   }
/*     */ 
/*     */   public void warn(Object message, Throwable t)
/*     */   {
/* 215 */     this.logger.log(FQCN, Priority.WARN, message, t);
/*     */   }
/*     */ 
/*     */   public void error(Object message)
/*     */   {
/* 223 */     this.logger.log(FQCN, Priority.ERROR, message, null);
/*     */   }
/*     */ 
/*     */   public void error(Object message, Throwable t)
/*     */   {
/* 231 */     this.logger.log(FQCN, Priority.ERROR, message, t);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message)
/*     */   {
/* 239 */     this.logger.log(FQCN, Priority.FATAL, message, null);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message, Throwable t)
/*     */   {
/* 247 */     this.logger.log(FQCN, Priority.FATAL, message, t);
/*     */   }
/*     */ 
/*     */   public Logger getLogger()
/*     */   {
/* 255 */     return this.logger;
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 263 */     return this.logger.isDebugEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isErrorEnabled()
/*     */   {
/* 271 */     return this.logger.isEnabledFor(Priority.ERROR);
/*     */   }
/*     */ 
/*     */   public boolean isFatalEnabled()
/*     */   {
/* 279 */     return this.logger.isEnabledFor(Priority.FATAL);
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 287 */     return this.logger.isInfoEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isTraceEnabled()
/*     */   {
/* 296 */     return this.logger.isDebugEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isWarnEnabled()
/*     */   {
/* 303 */     return this.logger.isEnabledFor(Priority.WARN);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.internal.util.logging.jakarta.Log4JLogger
 * JD-Core Version:    0.6.0
 */