/*     */ package com.arjuna.common.internal.util.propertyservice;
/*     */ 
/*     */ import com.arjuna.common.util.exceptions.LoadPropertiesException;
/*     */ import com.arjuna.common.util.exceptions.ManagementPluginException;
/*     */ import com.arjuna.common.util.exceptions.SavePropertiesException;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import com.arjuna.common.util.propertyservice.plugins.PropertyManagementPlugin;
/*     */ import com.arjuna.common.util.propertyservice.plugins.PropertyManagerIOPlugin;
/*     */ import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
/*     */ import java.io.IOException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public class PropertyManagerImpl
/*     */   implements PropertyManagerPluginInterface
/*     */ {
/*  54 */   private static boolean _verbose = false;
/*     */ 
/*  57 */   private PropertyManagerImpl _topLevelPropertyManager = this;
/*     */   private HashSet _parentPropertyManagers;
/*     */   private HashSet _childPropertyManagers;
/*     */   private Properties _properties;
/*     */   private String _name;
/*     */   private String _associatedUri;
/*     */   private String _associatedPluginClassname;
/*     */ 
/*     */   public PropertyManagerImpl(String name)
/*     */   {
/*  75 */     this._name = name;
/*  76 */     this._parentPropertyManagers = new HashSet();
/*  77 */     this._childPropertyManagers = new HashSet();
/*     */ 
/*  79 */     this._properties = new Properties();
/*  80 */     this._associatedUri = null;
/*     */   }
/*     */ 
/*     */   public PropertyManagerImpl(String name, PropertyManagerImpl parent)
/*     */   {
/*  85 */     this(name);
/*     */ 
/*  87 */     this._topLevelPropertyManager = parent;
/*     */   }
/*     */ 
/*     */   public PropertyManagerPluginInterface getTopLevelPropertyManager()
/*     */   {
/*  92 */     return this._topLevelPropertyManager;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 101 */     return this._name;
/*     */   }
/*     */ 
/*     */   public String getUri()
/*     */   {
/* 110 */     return this._associatedUri;
/*     */   }
/*     */ 
/*     */   public void setUri(String uri)
/*     */   {
/* 119 */     this._associatedUri = uri;
/*     */   }
/*     */ 
/*     */   public String getIOPluginClassname()
/*     */   {
/* 124 */     return this._associatedPluginClassname;
/*     */   }
/*     */ 
/*     */   public void setIOPluginClassname(String classname)
/*     */   {
/* 129 */     this._associatedPluginClassname = classname;
/*     */   }
/*     */ 
/*     */   public String getProperty(String name)
/*     */   {
/* 141 */     String value = System.getProperty(name);
/*     */ 
/* 144 */     value = value != null ? value : getPropertyFromSubTree(name);
/*     */ 
/* 146 */     return value;
/*     */   }
/*     */ 
/*     */   private String getPropertyFromSubTree(String name)
/*     */   {
/* 158 */     String value = this._properties.getProperty(name);
/*     */ 
/* 160 */     if (value == null)
/*     */     {
/* 163 */       Iterator itr = this._parentPropertyManagers.iterator();
/* 164 */       while ((itr.hasNext()) && (value == null))
/*     */       {
/* 166 */         PropertyManagerImpl pm = (PropertyManagerImpl)itr.next();
/* 167 */         value = pm.getPropertyFromSubTree(name);
/*     */       }
/*     */     }
/*     */ 
/* 171 */     return value;
/*     */   }
/*     */ 
/*     */   public String getProperty(String name, String defaultValue)
/*     */   {
/* 184 */     String value = getProperty(name);
/*     */ 
/* 186 */     return value == null ? defaultValue : value;
/*     */   }
/*     */ 
/*     */   public String setProperty(String name, String value)
/*     */   {
/* 198 */     return setProperty(name, value, true);
/*     */   }
/*     */ 
/*     */   public String setProperty(String name, String value, boolean setSystemProperty)
/*     */   {
/* 212 */     if ((setSystemProperty) && (System.getProperty(name) != null))
/*     */     {
/* 214 */       System.setProperty(name, value);
/*     */     }
/*     */ 
/* 217 */     String oldValue = setLocalProperty(name, value);
/*     */ 
/* 219 */     if (oldValue == null)
/*     */     {
/* 221 */       this._properties.setProperty(name, value);
/*     */     }
/*     */ 
/* 224 */     return oldValue;
/*     */   }
/*     */ 
/*     */   public String removeProperty(String name)
/*     */   {
/* 235 */     if (System.getProperty(name) != null)
/*     */     {
/* 237 */       System.getProperties().remove(name);
/*     */     }
/*     */ 
/* 240 */     String oldValue = removeLocalProperty(name);
/*     */ 
/* 242 */     return oldValue;
/*     */   }
/*     */ 
/*     */   private String removeLocalProperty(String name)
/*     */   {
/* 247 */     PropertyManagerImpl pm = this;
/* 248 */     String oldValue = this._properties.getProperty(name);
/*     */ 
/* 250 */     if (oldValue != null)
/*     */     {
/* 252 */       this._properties.remove(name);
/*     */     }
/*     */ 
/* 255 */     Iterator itr = this._parentPropertyManagers.iterator();
/* 256 */     while ((oldValue == null) && (itr.hasNext()))
/*     */     {
/* 258 */       pm = (PropertyManagerImpl)itr.next();
/* 259 */       oldValue = pm.removeLocalProperty(name);
/*     */     }
/*     */ 
/* 262 */     return oldValue;
/*     */   }
/*     */ 
/*     */   private String setLocalProperty(String name, String value)
/*     */   {
/* 267 */     PropertyManagerImpl pm = this;
/* 268 */     String oldValue = this._properties.getProperty(name);
/*     */ 
/* 270 */     if (oldValue != null)
/*     */     {
/* 272 */       this._properties.setProperty(name, value);
/*     */     }
/*     */ 
/* 275 */     Iterator itr = this._parentPropertyManagers.iterator();
/* 276 */     while ((oldValue == null) && (itr.hasNext()))
/*     */     {
/* 278 */       pm = (PropertyManagerImpl)itr.next();
/* 279 */       oldValue = pm.setLocalProperty(name, value);
/*     */     }
/*     */ 
/* 282 */     return oldValue;
/*     */   }
/*     */ 
/*     */   public Properties getLocalProperties()
/*     */   {
/* 291 */     return this._properties;
/*     */   }
/*     */ 
/*     */   public Properties getProperties()
/*     */   {
/* 302 */     Properties returnProps = getAllProperties();
/*     */ 
/* 304 */     returnProps.putAll(System.getProperties());
/*     */ 
/* 306 */     return returnProps;
/*     */   }
/*     */ 
/*     */   public Properties getAllProperties()
/*     */   {
/* 318 */     Properties returnProps = new Properties();
/* 319 */     Iterator itr = this._parentPropertyManagers.iterator();
/* 320 */     while (itr.hasNext())
/*     */     {
/* 322 */       PropertyManagerImpl pm = (PropertyManagerImpl)itr.next();
/*     */ 
/* 324 */       returnProps.putAll(pm.getAllProperties());
/*     */     }
/*     */ 
/* 327 */     returnProps.putAll(this._properties);
/*     */ 
/* 329 */     return returnProps;
/*     */   }
/*     */ 
/*     */   public Enumeration propertyNames()
/*     */   {
/* 338 */     return getProperties().keys();
/*     */   }
/*     */ 
/*     */   public synchronized void load(String pluginClassname, String uri)
/*     */     throws IOException, ClassNotFoundException, LoadPropertiesException
/*     */   {
/*     */     try
/*     */     {
/* 354 */       String classname = System.getProperty("com.arjuna.common.util.propertyservice.pluginclassname");
/* 355 */       classname = classname == null ? pluginClassname : classname;
/*     */ 
/* 357 */       PropertyManagerIOPlugin plugin = (PropertyManagerIOPlugin)Thread.currentThread().getContextClassLoader().loadClass(pluginClassname).newInstance();
/*     */ 
/* 359 */       plugin.load(uri, this._topLevelPropertyManager, _verbose);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 363 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 367 */       throw new LoadPropertiesException("Failed to instantiate plugin: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void save(String pluginClassname, String uri)
/*     */     throws IOException, ClassNotFoundException, SavePropertiesException
/*     */   {
/*     */     try
/*     */     {
/* 389 */       if (pluginClassname == null)
/*     */       {
/* 391 */         pluginClassname = this._associatedPluginClassname;
/*     */       }
/*     */ 
/* 395 */       String classname = System.getProperty("com.arjuna.common.util.propertyservice.pluginclassname");
/* 396 */       classname = classname == null ? pluginClassname : classname;
/*     */ 
/* 398 */       PropertyManagerIOPlugin plugin = (PropertyManagerIOPlugin)Thread.currentThread().getContextClassLoader().loadClass(pluginClassname).newInstance();
/*     */ 
/* 400 */       plugin.save(uri, this);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 404 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 408 */       e.printStackTrace(System.err);
/* 409 */       throw new SavePropertiesException("Failed to instantiate plugin: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean verbose()
/*     */   {
/* 415 */     return _verbose;
/*     */   }
/*     */ 
/*     */   public void addChild(PropertyManager pm)
/*     */   {
/* 425 */     if (!this._childPropertyManagers.contains(pm))
/*     */     {
/* 427 */       this._childPropertyManagers.add(pm);
/* 428 */       ((PropertyManagerImpl)pm).addParent(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addParent(PropertyManager pm)
/*     */   {
/* 438 */     if (!this._parentPropertyManagers.contains(pm))
/*     */     {
/* 440 */       this._parentPropertyManagers.add(pm);
/* 441 */       ((PropertyManagerImpl)pm).addChild(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public PropertyManagerPluginInterface createPropertyManager(String modulename)
/*     */   {
/* 452 */     return new PropertyManagerImpl(modulename, this._topLevelPropertyManager);
/*     */   }
/*     */ 
/*     */   public PropertyManagerPluginInterface[] getParents()
/*     */   {
/* 461 */     PropertyManagerPluginInterface[] pms = new PropertyManagerPluginInterface[this._parentPropertyManagers.size()];
/* 462 */     this._parentPropertyManagers.toArray(pms);
/* 463 */     return pms;
/*     */   }
/*     */ 
/*     */   public PropertyManagerPluginInterface[] getChildren()
/*     */   {
/* 472 */     PropertyManagerPluginInterface[] pms = new PropertyManagerPluginInterface[this._childPropertyManagers.size()];
/* 473 */     this._childPropertyManagers.toArray(pms);
/* 474 */     return pms;
/*     */   }
/*     */ 
/*     */   public void addManagementPlugin(PropertyManagementPlugin plugin)
/*     */     throws IOException, ManagementPluginException
/*     */   {
/*     */     try
/*     */     {
/* 488 */       plugin.initialise(this);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 492 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 496 */       throw new ManagementPluginException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public PropertyManagerPluginInterface getChild(String moduleName)
/*     */   {
/* 502 */     PropertyManagerPluginInterface returnPm = null;
/* 503 */     Iterator itr = this._childPropertyManagers.iterator();
/*     */ 
/* 505 */     while ((returnPm == null) && (itr.hasNext()))
/*     */     {
/* 507 */       PropertyManagerImpl pm = (PropertyManagerImpl)itr.next();
/*     */ 
/* 509 */       if (pm.getName().equals(moduleName))
/*     */       {
/* 511 */         returnPm = pm;
/*     */       }
/*     */     }
/*     */ 
/* 515 */     if (returnPm == null)
/*     */     {
/* 517 */       addChild(returnPm = createPropertyManager(moduleName));
/*     */     }
/*     */ 
/* 520 */     return returnPm;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 525 */     String verboseSetting = System.getProperty("com.arjuna.common.util.propertyservice.verbosePropertyManager");
/*     */ 
/* 527 */     if ((verboseSetting != null) && (verboseSetting.equalsIgnoreCase("ON")))
/*     */     {
/* 529 */       _verbose = true;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.internal.util.propertyservice.PropertyManagerImpl
 * JD-Core Version:    0.6.0
 */