/*     */ package com.arjuna.common.internal.util.propertyservice.plugins.io;
/*     */ 
/*     */ import com.arjuna.common.util.FileLocator;
/*     */ import com.arjuna.common.util.exceptions.LoadPropertiesException;
/*     */ import com.arjuna.common.util.exceptions.SavePropertiesException;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import com.arjuna.common.util.propertyservice.plugins.PropertyManagerIOPlugin;
/*     */ import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
/*     */ import java.io.File;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.apache.xml.serialize.OutputFormat;
/*     */ import org.apache.xml.serialize.XMLSerializer;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class XMLFilePlugin
/*     */   implements PropertyManagerIOPlugin
/*     */ {
/*     */   private static final String PROPERTIES_ELEMENT_NAME = "properties";
/*     */   private static final String DEPENDS_ATTRIBUTE_NAME = "depends";
/*     */   private static final String PROPERTY_ELEMENT_NAME = "property";
/*     */   private static final String NAME_ATTRIBUTE_NAME = "name";
/*     */   private static final String VALUE_ATTRIBUTE_NAME = "value";
/*     */   private static final String PROPERTY_TYPE_ATTRIBUTE_NAME = "type";
/*     */   private static final String SYSTEM_PROPERTY_TYPE_NAME = "system";
/*     */   private static DocumentBuilder _documentBuilder;
/*  81 */   private static Hashtable _loadedFiles = new Hashtable();
/*     */ 
/*     */   private static void setURILoaded(PropertyManagerPluginInterface pcm, String uri)
/*     */   {
/*  85 */     ArrayList uris = (ArrayList)_loadedFiles.get(pcm);
/*     */ 
/*  87 */     if (uris == null)
/*     */     {
/*  89 */       uris = new ArrayList(1);
/*  90 */       _loadedFiles.put(pcm, uris);
/*     */     }
/*     */ 
/*  93 */     if (!uris.contains(uri))
/*     */     {
/*  95 */       uris.add(uri);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static boolean isURILoaded(PropertyManagerPluginInterface pcm, String uri)
/*     */   {
/* 101 */     boolean loaded = false;
/*     */ 
/* 103 */     ArrayList uris = (ArrayList)_loadedFiles.get(pcm);
/*     */ 
/* 105 */     if (uris != null)
/*     */     {
/* 107 */       loaded = uris.contains(uri);
/*     */     }
/*     */ 
/* 110 */     return loaded;
/*     */   }
/*     */ 
/*     */   public void load(String uri, PropertyManagerPluginInterface pcm, boolean verbose)
/*     */     throws LoadPropertiesException, IOException
/*     */   {
/* 125 */     if (!isURILoaded(pcm, uri))
/*     */     {
/*     */       try
/*     */       {
/* 129 */         String filename = FileLocator.locateFile(uri);
/*     */         Hashtable pmDependents;
/*     */         Hashtable pms;
/*     */         Enumeration e;
/* 131 */         if ((filename != null) && (new File(filename).exists()))
/*     */         {
/* 133 */           Document doc = _documentBuilder.parse(filename);
/* 134 */           Element rootElement = doc.getDocumentElement();
/*     */ 
/* 136 */           setURILoaded(pcm, uri);
/*     */ 
/* 138 */           NodeList propertiesNodes = rootElement.getElementsByTagName("properties");
/*     */ 
/* 140 */           pmDependents = new Hashtable();
/* 141 */           pms = new Hashtable();
/* 142 */           for (int count = 0; count < propertiesNodes.getLength(); count++)
/*     */           {
/* 144 */             Element propertiesNode = (Element)propertiesNodes.item(count);
/* 145 */             Node nameNode = propertiesNode.getAttributeNode("name");
/* 146 */             String propertiesName = nameNode != null ? nameNode.getNodeValue() : null;
/* 147 */             Node dependsNode = propertiesNode.getAttributeNode("depends");
/* 148 */             String dependsName = dependsNode != null ? dependsNode.getNodeValue() : "";
/*     */ 
/* 150 */             NodeList propertyNodes = propertiesNode.getElementsByTagName("property");
/*     */ 
/* 153 */             PropertyManagerPluginInterface pm = propertiesName != null ? pcm.getTopLevelPropertyManager().getChild(propertiesName) : pcm;
/*     */ 
/* 156 */             if (pm == null)
/*     */             {
/* 158 */               pm = pcm.createPropertyManager(propertiesName);
/*     */             }
/*     */ 
/* 161 */             if (verbose)
/*     */             {
/* 163 */               System.out.println("Properties loaded (" + uri + "):");
/*     */             }
/*     */ 
/* 167 */             pm.setUri(uri);
/*     */ 
/* 169 */             pm.setIOPluginClassname(getClass().getName());
/*     */ 
/* 171 */             for (int nodeCount = 0; nodeCount < propertyNodes.getLength(); nodeCount++)
/*     */             {
/* 173 */               Element propertyNode = (Element)propertyNodes.item(nodeCount);
/* 174 */               String propertyName = propertyNode.getAttribute("name");
/* 175 */               String propertyValue = propertyNode.getAttribute("value");
/* 176 */               String propertyType = propertyNode.getAttribute("type");
/*     */ 
/* 178 */               if (verbose)
/*     */               {
/* 180 */                 System.out.println(propertyName + "=" + propertyValue);
/*     */               }
/*     */ 
/* 184 */               pm.setProperty(propertyName, propertyValue, false);
/*     */ 
/* 187 */               if ((propertyType == null) || (!propertyType.equalsIgnoreCase("system")) || (System.getProperty(propertyName) != null))
/*     */               {
/*     */                 continue;
/*     */               }
/*     */ 
/* 192 */               System.setProperty(propertyName, propertyValue);
/*     */             }
/*     */ 
/* 197 */             if ((dependsName.length() == 0) && (pm != pcm))
/*     */             {
/* 199 */               pcm.addChild(pm);
/*     */             }
/*     */ 
/* 202 */             pmDependents.put(pm, dependsName);
/*     */ 
/* 205 */             if (propertiesName == null)
/*     */               continue;
/* 207 */             pms.put(propertiesName, pm);
/*     */           }
/*     */ 
/* 212 */           for (e = pmDependents.keys(); e.hasMoreElements(); )
/*     */           {
/* 214 */             PropertyManagerPluginInterface pm = (PropertyManagerPluginInterface)e.nextElement();
/* 215 */             String depends = (String)pmDependents.get(pm);
/*     */ 
/* 217 */             StringTokenizer strtok = new StringTokenizer(depends, ",");
/*     */ 
/* 219 */             while (strtok.hasMoreElements())
/*     */             {
/* 221 */               String dependantName = strtok.nextToken().trim();
/* 222 */               PropertyManager dependant = (PropertyManager)pms.get(dependantName);
/*     */ 
/* 224 */               if (dependant == null)
/*     */               {
/* 226 */                 throw new LoadPropertiesException("Dependency not found - property file invalid");
/*     */               }
/* 228 */               pm.addParent(dependant);
/*     */             }
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 234 */           throw new FileNotFoundException();
/*     */         }
/*     */       }
/*     */       catch (FileNotFoundException e)
/*     */       {
/* 239 */         if (verbose)
/*     */         {
/* 241 */           System.err.println("Cannot load properties file: " + uri);
/*     */         }
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 246 */         throw e;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 250 */         throw new LoadPropertiesException("Failed to open properties file: " + e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void save(String uri, PropertyManagerPluginInterface pcm)
/*     */     throws SavePropertiesException, IOException
/*     */   {
/* 267 */     uri = uri != null ? null : pcm.getUri();
/*     */ 
/* 269 */     if (uri == null)
/*     */     {
/* 271 */       throw new SavePropertiesException("No uri is associated with this property manager");
/*     */     }
/*     */ 
/* 274 */     Properties props = pcm.getLocalProperties();
/*     */     try
/*     */     {
/* 278 */       String filename = FileLocator.locateFile(uri);
/* 279 */       Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(filename);
/* 280 */       Element root = doc.getDocumentElement();
/* 281 */       String depends = null;
/*     */ 
/* 284 */       NodeList propertiesNodes = root.getElementsByTagName("properties");
/*     */ 
/* 286 */       for (int count = 0; count < propertiesNodes.getLength(); count++)
/*     */       {
/* 288 */         Element propertiesElement = (Element)propertiesNodes.item(count);
/* 289 */         String propertiesName = propertiesElement.getAttributeNode("name").getNodeValue();
/*     */ 
/* 292 */         if (!propertiesName.equals(pcm.getName()))
/*     */           continue;
/* 294 */         root.removeChild(propertiesElement);
/* 295 */         depends = propertiesElement.getAttributeNode("depends").getNodeValue();
/* 296 */         break;
/*     */       }
/*     */ 
/* 301 */       Element newPropertiesElement = doc.createElement("properties");
/*     */ 
/* 303 */       newPropertiesElement.setAttribute("name", pcm.getName());
/*     */ 
/* 305 */       if (depends != null)
/*     */       {
/* 307 */         newPropertiesElement.setAttribute("depends", depends);
/*     */       }
/*     */ 
/* 310 */       for (Enumeration e = props.keys(); e.hasMoreElements(); )
/*     */       {
/* 312 */         String key = (String)e.nextElement();
/* 313 */         String value = props.getProperty(key);
/*     */ 
/* 315 */         Element newPropertyElement = doc.createElement("property");
/* 316 */         newPropertyElement.setAttribute("name", key);
/* 317 */         newPropertyElement.setAttribute("value", value);
/*     */ 
/* 319 */         newPropertiesElement.appendChild(newPropertyElement);
/*     */       }
/*     */ 
/* 322 */       root.appendChild(newPropertiesElement);
/*     */ 
/* 326 */       OutputFormat of = new OutputFormat(doc);
/* 327 */       of.setIndenting(true);
/*     */       FileOutputStream out;
/* 328 */       XMLSerializer srl = new XMLSerializer(out = new FileOutputStream(filename), of);
/*     */ 
/* 330 */       srl.serialize(doc);
/*     */ 
/* 332 */       out.close();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 336 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 340 */       throw new SavePropertiesException("Unexpected exception: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/* 348 */       _documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 352 */       throw new ExceptionInInitializerError("Failed to create document builder:" + e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.internal.util.propertyservice.plugins.io.XMLFilePlugin
 * JD-Core Version:    0.6.0
 */