/*     */ package com.arjuna.common.util;
/*     */ 
/*     */ public class ClassPathParser
/*     */ {
/*     */   private String _classPath;
/*     */   private int _start;
/*     */   private static final char winSeparator = ';';
/*     */   private static final char unixSeparator = ':';
/* 128 */   private static char pathSeparator = ':';
/*     */ 
/*     */   public ClassPathParser()
/*     */   {
/*  50 */     this._classPath = System.getProperty("java.class.path");
/*  51 */     this._start = 0;
/*     */   }
/*     */ 
/*     */   public final String getPath(String contains)
/*     */   {
/*  61 */     String toReturn = null;
/*     */ 
/*  63 */     if ((this._classPath != null) && (contains != null))
/*     */     {
/*  65 */       int indx = this._classPath.indexOf(contains, this._start);
/*     */ 
/*  67 */       if (indx != -1)
/*     */       {
/*  69 */         int lastIndex = this._classPath.indexOf(pathSeparator, this._start);
/*  70 */         int sepIndex = lastIndex + 1;
/*     */ 
/*  72 */         if (lastIndex > indx) {
/*  73 */           sepIndex = 0;
/*     */         }
/*     */         else {
/*  76 */           while ((lastIndex < indx) && (lastIndex != -1))
/*     */           {
/*  78 */             lastIndex = this._classPath.indexOf(pathSeparator, sepIndex);
/*     */ 
/*  80 */             if (lastIndex == -1) {
/*  81 */               lastIndex = this._classPath.length(); continue;
/*     */             }
/*     */ 
/*  84 */             if (lastIndex < indx) {
/*  85 */               sepIndex = lastIndex + 1;
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/*  92 */           toReturn = this._classPath.substring(sepIndex, lastIndex);
/*     */ 
/*  94 */           this._start = (indx + 1);
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 103 */     return toReturn;
/*     */   }
/*     */ 
/*     */   public final boolean reset()
/*     */   {
/* 115 */     this._classPath = System.getProperty("java.class.path");
/*     */ 
/* 117 */     this._start = 0;
/*     */ 
/* 119 */     return this._classPath != null;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 132 */     pathSeparator = System.getProperty("path.separator").charAt(0);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.util.ClassPathParser
 * JD-Core Version:    0.6.0
 */