/*     */ package com.arjuna.common.util;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ 
/*     */ public class FileLocator
/*     */ {
/*     */   private static final String absolutePath = "abs://";
/*     */   private static final String pct20 = "%20";
/*     */   private static final int pct20len = 3;
/*     */ 
/*     */   public static String locateFile(String findFile)
/*     */     throws FileNotFoundException
/*     */   {
/*  67 */     if (findFile == null) {
/*  68 */       throw new FileNotFoundException("locateFile: null file name");
/*     */     }
/*  70 */     if (findFile.startsWith("abs://"))
/*  71 */       return findFile.substring("abs://".length());
/*     */     String fullPathName;
/*  73 */     if ((fullPathName = locateByProperty(findFile)) != null)
/*  74 */       return fullPathName;
/*     */     URL url;
/*  76 */     if ((url = locateByResource(findFile)) != null)
/*     */     {
/*  85 */       fullPathName = url.getFile();
/*  86 */       int pos = 0;
/*  87 */       int len = fullPathName.length();
/*  88 */       int start = 0;
/*  89 */       StringBuffer decodedPathName = new StringBuffer();
/*     */ 
/*  91 */       while ((pos = fullPathName.indexOf("%20", start)) != -1) {
/*  92 */         decodedPathName.append(fullPathName.substring(start, pos));
/*  93 */         decodedPathName.append(' ');
/*  94 */         start = pos + 3;
/*     */       }
/*     */ 
/*  97 */       if (start < len) {
/*  98 */         decodedPathName.append(fullPathName.substring(start, len));
/*     */       }
/* 100 */       fullPathName = decodedPathName.toString();
/*     */ 
/* 102 */       if (platformIsWindows()) {
/* 103 */         fullPathName = fullPathName.substring(1, fullPathName.length());
/*     */       }
/* 105 */       return fullPathName;
/*     */     }
/*     */ 
/* 108 */     throw new FileNotFoundException("locateFile: file not found: " + findFile);
/*     */   }
/*     */ 
/*     */   public static URL locateURL(String findFile)
/*     */     throws FileNotFoundException
/*     */   {
/* 120 */     if (findFile == null)
/* 121 */       throw new FileNotFoundException("locateURL: null file name");
/*     */     try
/*     */     {
/* 124 */       if (findFile.startsWith("abs://"))
/*     */       {
/* 126 */         return new URL("file:/" + findFile.substring("abs://".length()));
/*     */       }
/*     */       String fullPathName;
/* 129 */       if ((fullPathName = locateByProperty(findFile)) != null)
/*     */       {
/*     */         URL url;
/*     */         URL url;
/* 131 */         if (platformIsWindows())
/* 132 */           url = new URL("file:/" + fullPathName);
/*     */         else
/* 134 */           url = new URL("file:" + fullPathName);
/* 135 */         return url;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 141 */       System.err.println("locateURL: URL creation problem");
/* 142 */       throw new FileNotFoundException("locateURL: URL creation problem");
/*     */     }
/*     */     URL url;
/* 144 */     if ((url = locateByResource(findFile)) != null) {
/* 145 */       return url;
/*     */     }
/* 147 */     throw new FileNotFoundException("locateURL: file not found: " + findFile);
/*     */   }
/*     */ 
/*     */   private static synchronized String locateByProperty(String findFile)
/*     */   {
/* 156 */     String fullPathName = null;
/* 157 */     String dir = null;
/* 158 */     File f = null;
/*     */ 
/* 160 */     if (findFile == null) {
/* 161 */       return null;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 167 */       dir = System.getProperty("user.dir");
/* 168 */       if (dir != null) {
/* 169 */         fullPathName = dir + File.separatorChar + findFile;
/* 170 */         f = new File(fullPathName);
/*     */       }
/* 172 */       if ((f != null) && (f.exists()))
/*     */       {
/* 175 */         return fullPathName;
/*     */       }
/*     */ 
/* 178 */       dir = System.getProperty("user.home");
/* 179 */       if (dir != null) {
/* 180 */         fullPathName = dir + File.separatorChar + findFile;
/* 181 */         f = new File(fullPathName);
/*     */       }
/* 183 */       if ((f != null) && (f.exists()))
/*     */       {
/* 186 */         return fullPathName;
/*     */       }
/*     */ 
/* 189 */       dir = System.getProperty("java.home");
/* 190 */       if (dir != null) {
/* 191 */         fullPathName = dir + File.separatorChar + findFile;
/* 192 */         f = new File(fullPathName);
/*     */       }
/* 194 */       if ((f != null) && (f.exists()))
/*     */       {
/* 197 */         return fullPathName;
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 202 */       return null;
/*     */     }
/* 204 */     return null;
/*     */   }
/*     */ 
/*     */   private static URL locateByResource(String findFile)
/*     */   {
/* 213 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 214 */     URL url = loader.getResource(findFile);
/* 215 */     if (url == null)
/*     */     {
/* 217 */       url = FileLocator.class.getResource("/" + findFile);
/*     */     }
/*     */ 
/* 220 */     return url;
/*     */   }
/*     */ 
/*     */   private static boolean platformIsWindows()
/*     */   {
/* 232 */     return File.separatorChar == '\\';
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.util.FileLocator
 * JD-Core Version:    0.6.0
 */