/*     */ package com.arjuna.common.util.logging;
/*     */ 
/*     */ import com.arjuna.common.internal.util.logging.AbstractLogInterface;
/*     */ import com.arjuna.common.internal.util.logging.LogFactoryInterface;
/*     */ import com.arjuna.common.internal.util.logging.LogImpl;
/*     */ import com.arjuna.common.internal.util.logging.LogInterface;
/*     */ import com.arjuna.common.internal.util.logging.LogNoi18nImpl;
/*     */ import com.arjuna.common.internal.util.logging.commonPropertyManager;
/*     */ import com.arjuna.common.internal.util.logging.jakarta.JakartaLogFactory;
/*     */ import com.arjuna.common.internal.util.logging.jakarta.JakartaRelevelingLogFactory;
/*     */ import com.arjuna.common.internal.util.logging.simpleLog.SimpleLogFactory;
/*     */ import com.arjuna.common.util.exceptions.LogConfigurationException;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ 
/*     */ public class LogFactory
/*     */ {
/*     */   public static final String LOGGER_PROPERTY = "com.arjuna.common.util.logger";
/*     */   public static final String DEBUG_LEVEL = "com.arjuna.common.util.logging.DebugLevel";
/*     */   public static final String FACILITY_LEVEL = "com.arjuna.common.util.logging.FacilityLevel";
/*     */   public static final String VISIBILITY_LEVEL = "com.arjuna.common.util.logging.VisibilityLevel";
/*     */   private static final String JCL_LOG_CONFIGURATION = "org.apache.commons.logging.Log";
/*     */   private static final String JAKARTA_LOGGER = "jakarta";
/*     */   private static final String DOTNET_LOGGER = "dotnet";
/*     */   private static final String LOG4J = "log4j";
/*     */   private static final String JDK14 = "jdk14";
/*     */   private static final String SIMPLE = "simple";
/*     */   private static final String NOOP = "noop";
/*     */   private static final String RELEVELER = "log4j_releveler";
/* 147 */   private static LogFactoryInterface m_logFactory = null;
/*     */ 
/* 156 */   private static boolean m_isInitialized = false;
/*     */ 
/* 163 */   private static long m_debugLevel = 0L;
/*     */ 
/* 170 */   private static long m_visLevel = -1L;
/*     */ 
/* 177 */   private static long m_facLevel = -1L;
/*     */ 
/*     */   public static LogNoi18n getLogNoi18n(String name)
/*     */   {
/* 189 */     LogNoi18n log = null;
/* 190 */     setupLogSystem();
/* 191 */     AbstractLogInterface logInterface = m_logFactory.getLog(name);
/* 192 */     if ((logInterface instanceof LogInterface))
/* 193 */       log = new LogNoi18nImpl((LogInterface)logInterface);
/*     */     else {
/* 195 */       throw new RuntimeException("non i18n loggers are not supported for CSF!");
/*     */     }
/* 197 */     log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
/* 198 */     return log;
/*     */   }
/*     */ 
/*     */   public static Logi18n getLogi18n(Class clazz)
/*     */   {
/* 208 */     Logi18n log = null;
/* 209 */     setupLogSystem();
/* 210 */     AbstractLogInterface logInterface = m_logFactory.getLog(clazz);
/* 211 */     log = new LogImpl((LogInterface)logInterface);
/* 212 */     log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
/* 213 */     return log;
/*     */   }
/*     */ 
/*     */   public static Logi18n getLogi18n(String name)
/*     */   {
/* 229 */     Logi18n log = null;
/* 230 */     setupLogSystem();
/* 231 */     AbstractLogInterface logInterface = m_logFactory.getLog(name);
/* 232 */     log = new LogImpl((LogInterface)logInterface, name);
/* 233 */     log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
/* 234 */     return log;
/*     */   }
/*     */ 
/*     */   public static Logi18n getLogi18n(Class clazz, String resBundle)
/*     */   {
/* 245 */     Logi18n log = null;
/* 246 */     setupLogSystem();
/* 247 */     AbstractLogInterface logInterface = m_logFactory.getLog(clazz);
/* 248 */     log = new LogImpl((LogInterface)logInterface, resBundle);
/* 249 */     log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
/* 250 */     return log;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static Logi18n getLogi18n(Class clazz, String[] resBundles)
/*     */   {
/* 264 */     Logi18n log = null;
/* 265 */     setupLogSystem();
/* 266 */     AbstractLogInterface logInterface = m_logFactory.getLog(clazz);
/* 267 */     log = new LogImpl((LogInterface)logInterface, resBundles);
/* 268 */     log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
/* 269 */     return log;
/*     */   }
/*     */ 
/*     */   public static Logi18n getLogi18n(String name, String resBundle)
/*     */   {
/* 282 */     Logi18n log = null;
/* 283 */     setupLogSystem();
/* 284 */     AbstractLogInterface logInterface = m_logFactory.getLog(name);
/* 285 */     log = new LogImpl((LogInterface)logInterface, resBundle);
/* 286 */     log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
/* 287 */     return log;
/*     */   }
/*     */ 
/*     */   public static Logi18n getLogi18n(String name, String[] resBundles)
/*     */   {
/* 300 */     Logi18n log = null;
/* 301 */     setupLogSystem();
/* 302 */     AbstractLogInterface logInterface = m_logFactory.getLog(name);
/* 303 */     log = new LogImpl((LogInterface)logInterface, resBundles);
/* 304 */     log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
/* 305 */     return log;
/*     */   }
/*     */ 
/*     */   private static synchronized void setupLogSystem()
/*     */   {
/* 312 */     if (m_isInitialized) {
/* 313 */       return;
/*     */     }
/*     */ 
/* 316 */     String debugLevel = "0xffffffff";
/* 317 */     String facLevel = "0xfffffff";
/* 318 */     String visLevel = "0xfffffff";
/* 319 */     String logSystem = "noop";
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 326 */         logSystem = commonPropertyManager.propertyManager.getProperty("com.arjuna.common.util.logger", null);
/*     */ 
/* 329 */         if (logSystem == null) {
/* 330 */           logSystem = System.getProperty("com.arjuna.common.util.logger", "noop");
/*     */         }
/*     */ 
/* 333 */         debugLevel = commonPropertyManager.propertyManager.getProperty("com.arjuna.common.util.logging.DebugLevel", "0xffffffff");
/* 334 */         facLevel = commonPropertyManager.propertyManager.getProperty("com.arjuna.common.util.logging.FacilityLevel", "0xfffffff");
/* 335 */         visLevel = commonPropertyManager.propertyManager.getProperty("com.arjuna.common.util.logging.VisibilityLevel", "0xfffffff");
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 345 */         m_debugLevel = Long.decode(debugLevel).longValue();
/*     */       } catch (NumberFormatException nfe) {
/* 347 */         m_debugLevel = 0L;
/*     */       }
/*     */       try
/*     */       {
/* 351 */         m_facLevel = Long.decode(facLevel).longValue();
/*     */       }
/*     */       catch (NumberFormatException nfe)
/*     */       {
/* 355 */         m_debugLevel = 268435455L;
/*     */       }
/*     */       try
/*     */       {
/* 359 */         m_visLevel = Long.decode(visLevel).longValue();
/*     */       }
/*     */       catch (NumberFormatException nfe)
/*     */       {
/* 363 */         m_debugLevel = 268435455L;
/*     */       }
/*     */ 
/* 369 */       if (logSystem.equals("dotnet")) logSystem = "simple";
/*     */ 
/* 373 */       if (logSystem.equals("log4j")) {
/* 374 */         System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger");
/* 375 */         m_logFactory = new JakartaLogFactory();
/* 376 */       } else if (logSystem.equals("jdk14")) {
/* 377 */         System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
/* 378 */         m_logFactory = new JakartaLogFactory();
/* 379 */       } else if (logSystem.equals("simple")) {
/* 380 */         System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
/* 381 */         m_logFactory = new JakartaLogFactory();
/* 382 */       } else if (logSystem.equals("noop")) {
/* 383 */         System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
/* 384 */         m_logFactory = new JakartaLogFactory();
/*     */       }
/* 390 */       else if (logSystem.equals("log4j_releveler")) {
/* 391 */         System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger");
/* 392 */         m_logFactory = new JakartaRelevelingLogFactory();
/*     */       }
/* 396 */       else if (logSystem.equals("jakarta")) {
/* 397 */         m_logFactory = new JakartaLogFactory();
/*     */       }
/* 401 */       else if (logSystem.equals("dotnet")) {
/* 402 */         m_logFactory = new SimpleLogFactory();
/*     */       }
/*     */       else
/*     */       {
/* 407 */         m_logFactory = new JakartaLogFactory();
/*     */       }
/*     */     }
/*     */     catch (LogConfigurationException e)
/*     */     {
/* 412 */       throw new RuntimeException("An unexpected exception occurred while creating the logger factory: " + e.getMessage());
/*     */     }
/* 414 */     m_isInitialized = true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.common.util.logging.LogFactory
 * JD-Core Version:    0.6.0
 */