/*     */ package javax.enterprise.deploy.shared;
/*     */ 
/*     */ public class CommandType
/*     */ {
/*     */   private static final int DISTRIBUTE_INT = 0;
/*     */   private static final int START_INT = 1;
/*     */   private static final int STOP_INT = 2;
/*     */   private static final int UNDEPLOY_INT = 3;
/*     */   private static final int REDEPLOY_INT = 4;
/*  46 */   public static final CommandType DISTRIBUTE = new CommandType(0);
/*     */ 
/*  48 */   public static final CommandType START = new CommandType(1);
/*     */ 
/*  50 */   public static final CommandType STOP = new CommandType(2);
/*     */ 
/*  52 */   public static final CommandType UNDEPLOY = new CommandType(3);
/*     */ 
/*  54 */   public static final CommandType REDEPLOY = new CommandType(4);
/*     */ 
/*  57 */   private static final CommandType[] commandTypes = { DISTRIBUTE, START, STOP, UNDEPLOY, REDEPLOY };
/*     */ 
/*  63 */   private static final String[] commandDescs = { "Distribute", "Start", "Stop", "Undeploy", "Redeploy" };
/*     */   private int value;
/*     */ 
/*     */   protected CommandType(int value)
/*     */   {
/*  84 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public int getValue()
/*     */   {
/*  96 */     return this.value;
/*     */   }
/*     */ 
/*     */   protected String[] getStringTable()
/*     */   {
/* 107 */     return commandDescs;
/*     */   }
/*     */ 
/*     */   protected CommandType[] getEnumValueTable()
/*     */   {
/* 117 */     return commandTypes;
/*     */   }
/*     */ 
/*     */   public static CommandType getCommandType(int type)
/*     */   {
/* 128 */     if (type >= commandTypes.length)
/* 129 */       return null;
/* 130 */     return commandTypes[type];
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 135 */     return commandDescs[this.value];
/*     */   }
/*     */ 
/*     */   protected int getOffset()
/*     */   {
/* 145 */     return 0;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.enterprise.deploy.shared.CommandType
 * JD-Core Version:    0.6.0
 */