/*     */ package javax.resource.spi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.util.EventObject;
/*     */ import org.jboss.util.id.SerialVersion;
/*     */ 
/*     */ public class ConnectionEvent extends EventObject
/*     */ {
/*     */   static final long serialVersionUID;
/*     */   private static final ObjectStreamField[] serialPersistentFields;
/*     */   private static final int ID_IDX = 0;
/*     */   private static final int EXCEPTION_IDX = 1;
/*     */   private static final int CONN_HANDLE_IDX = 2;
/*     */   public static final int CONNECTION_CLOSED = 1;
/*     */   public static final int LOCAL_TRANSACTION_STARTED = 2;
/*     */   public static final int LOCAL_TRANSACTION_COMMITTED = 3;
/*     */   public static final int LOCAL_TRANSACTION_ROLLEDBACK = 4;
/*     */   public static final int CONNECTION_ERROR_OCCURRED = 5;
/*     */   protected int id;
/* 127 */   private Exception e = null;
/*     */ 
/* 129 */   private Object connectionHandle = null;
/*     */ 
/*     */   public ConnectionEvent(ManagedConnection source, int eid)
/*     */   {
/* 139 */     super(source);
/* 140 */     this.id = eid;
/*     */   }
/*     */ 
/*     */   public ConnectionEvent(ManagedConnection source, int eid, Exception exception)
/*     */   {
/* 152 */     super(source);
/* 153 */     this.id = eid;
/* 154 */     this.e = exception;
/*     */   }
/*     */ 
/*     */   public int getId()
/*     */   {
/* 164 */     return this.id;
/*     */   }
/*     */ 
/*     */   public Exception getException()
/*     */   {
/* 174 */     return this.e;
/*     */   }
/*     */ 
/*     */   public void setConnectionHandle(Object connectionHandle)
/*     */   {
/* 184 */     this.connectionHandle = connectionHandle;
/*     */   }
/*     */ 
/*     */   public Object getConnectionHandle()
/*     */   {
/* 194 */     return this.connectionHandle;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 201 */     ObjectInputStream.GetField fields = ois.readFields();
/* 202 */     String name = serialPersistentFields[0].getName();
/* 203 */     this.id = fields.get(name, 5);
/* 204 */     name = serialPersistentFields[1].getName();
/* 205 */     this.e = ((Exception)fields.get(name, null));
/* 206 */     name = serialPersistentFields[2].getName();
/* 207 */     this.connectionHandle = fields.get(name, null);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 214 */     ObjectOutputStream.PutField fields = oos.putFields();
/* 215 */     String name = serialPersistentFields[0].getName();
/* 216 */     fields.put(name, this.id);
/* 217 */     name = serialPersistentFields[1].getName();
/* 218 */     fields.put(name, this.e);
/* 219 */     name = serialPersistentFields[2].getName();
/* 220 */     fields.put(name, this.connectionHandle);
/* 221 */     oos.writeFields();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  71 */     if (SerialVersion.version == 0)
/*     */     {
/*  73 */       serialVersionUID = 2776168349823367611L;
/*  74 */       serialPersistentFields = new ObjectStreamField[] { new ObjectStreamField("id", Integer.TYPE), new ObjectStreamField("e", Exception.class), new ObjectStreamField("connectionHandle", Object.class) };
/*     */     }
/*     */     else
/*     */     {
/*  86 */       serialVersionUID = 5611772461379563249L;
/*  87 */       serialPersistentFields = new ObjectStreamField[] { new ObjectStreamField("id", Integer.TYPE), new ObjectStreamField("exception", Exception.class), new ObjectStreamField("connectionHandle", Object.class) };
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.resource.spi.ConnectionEvent
 * JD-Core Version:    0.6.0
 */