/*     */ package javax.security.auth.message.config;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.security.SecurityPermission;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.message.AuthException;
/*     */ 
/*     */ public abstract class AuthConfigFactory
/*     */ {
/*  85 */   private static AuthConfigFactory _factory = null;
/*     */   private static final String FACTORY_PROP = "authconfigprovider.factory";
/*     */   static final String DEFAULT_FACTORY_SECURITY_PROPERTY = "org.jboss.security.auth.message.config.JBossAuthConfigFactory";
/*     */ 
/*     */   public abstract String[] detachListener(RegistrationListener paramRegistrationListener, String paramString1, String paramString2);
/*     */ 
/*     */   public abstract AuthConfigProvider getConfigProvider(String paramString1, String paramString2, RegistrationListener paramRegistrationListener);
/*     */ 
/*     */   public static AuthConfigFactory getFactory()
/*     */   {
/* 163 */     SecurityManager sm = System.getSecurityManager();
/* 164 */     if (sm != null) {
/* 165 */       sm.checkPermission(new SecurityPermission("getFactory"));
/*     */     }
/* 167 */     if (_factory == null)
/*     */     {
/* 169 */       String factoryName = null;
/* 170 */       Class clazz = null;
/*     */       try
/*     */       {
/* 173 */         LoadAction action = new LoadAction(null);
/*     */         try
/*     */         {
/* 176 */           clazz = (Class)AccessController.doPrivileged(action);
/* 177 */           factoryName = action.getName();
/*     */         }
/*     */         catch (PrivilegedActionException ex)
/*     */         {
/* 181 */           factoryName = action.getName();
/* 182 */           Exception e = ex.getException();
/* 183 */           if ((e instanceof ClassNotFoundException)) {
/* 184 */             throw ((ClassNotFoundException)e);
/*     */           }
/* 186 */           throw new IllegalStateException("Failure during load of class: " + action.getName() + e);
/*     */         }
/* 188 */         _factory = (AuthConfigFactory)clazz.newInstance();
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 192 */         String msg = "Failed to find AuthConfigFactory : " + factoryName;
/* 193 */         IllegalStateException ise = new IllegalStateException(msg);
/* 194 */         ise.initCause(e);
/* 195 */         throw ise;
/*     */       }
/*     */       catch (IllegalAccessException e)
/*     */       {
/* 199 */         String msg = "Unable to access class : " + factoryName;
/* 200 */         IllegalStateException ise = new IllegalStateException(msg);
/* 201 */         ise.initCause(e);
/* 202 */         throw ise;
/*     */       }
/*     */       catch (InstantiationException e)
/*     */       {
/* 206 */         String msg = "Failed to create instance of: " + factoryName;
/* 207 */         IllegalStateException ise = new IllegalStateException(msg);
/* 208 */         ise.initCause(e);
/* 209 */         throw ise;
/*     */       }
/*     */       catch (ClassCastException e)
/*     */       {
/* 213 */         StringBuffer msg = new StringBuffer(factoryName + " Is not a AuthConfigFactory, ");
/* 214 */         msg.append("ACF.class.CL: " + AuthConfigFactory.class.getClassLoader());
/* 215 */         msg.append("\nACF.class.CS: " + AuthConfigFactory.class.getProtectionDomain().getCodeSource());
/* 216 */         msg.append("\nACF.class.hash: " + System.identityHashCode(AuthConfigFactory.class));
/* 217 */         msg.append("\nclazz.CL: " + clazz.getClassLoader());
/* 218 */         msg.append("\nclazz.CS: " + clazz.getProtectionDomain().getCodeSource());
/* 219 */         msg.append("\nclazz.super.CL: " + clazz.getSuperclass().getClassLoader());
/* 220 */         msg.append("\nclazz.super.CS: " + clazz.getSuperclass().getProtectionDomain().getCodeSource());
/* 221 */         msg.append("\nclazz.super.hash: " + System.identityHashCode(clazz.getSuperclass()));
/* 222 */         ClassCastException cce = new ClassCastException(msg.toString());
/* 223 */         cce.initCause(e);
/* 224 */         throw cce;
/*     */       }
/*     */     }
/* 227 */     return _factory; } 
/*     */   public abstract RegistrationContext getRegistrationContext(String paramString);
/*     */ 
/*     */   public abstract String[] getRegistrationIDs(AuthConfigProvider paramAuthConfigProvider);
/*     */ 
/*     */   public abstract void refresh() throws AuthException, SecurityException;
/*     */ 
/*     */   public abstract String registerConfigProvider(String paramString1, Map paramMap, String paramString2, String paramString3, String paramString4) throws AuthException, SecurityException;
/*     */ 
/*     */   public abstract String registerConfigProvider(AuthConfigProvider paramAuthConfigProvider, String paramString1, String paramString2, String paramString3);
/*     */ 
/*     */   public abstract boolean removeRegistration(String paramString);
/*     */ 
/* 246 */   public static void setFactory(AuthConfigFactory factory) { _factory = factory;
/*     */   }
/*     */ 
/*     */   private static class LoadAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     private String name;
/*     */ 
/*     */     public String getName()
/*     */     {
/* 292 */       return this.name;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception
/*     */     {
/* 297 */       this.name = System.getProperty("authconfigprovider.factory");
/* 298 */       if (this.name == null)
/*     */       {
/* 301 */         this.name = "org.jboss.security.auth.message.config.JBossAuthConfigFactory";
/*     */       }
/* 303 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 304 */       Class factoryClass = loader.loadClass(this.name);
/* 305 */       return factoryClass;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface RegistrationContext
/*     */   {
/*     */     public abstract String getAppContext();
/*     */ 
/*     */     public abstract String getDescription();
/*     */ 
/*     */     public abstract String getMessageLayer();
/*     */ 
/*     */     public abstract boolean isPersistent();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.auth.message.config.AuthConfigFactory
 * JD-Core Version:    0.6.0
 */