/*     */ package javax.security.jacc;
/*     */ 
/*     */ class URLPattern
/*     */ {
/*     */   static final int DEFAULT = 0;
/*     */   static final int THE_PATH_PREFIX = 1;
/*     */   static final int PATH_PREFIX = 2;
/*     */   static final int EXTENSION = 3;
/*     */   static final int EXACT = 4;
/*     */   private String pattern;
/*     */   private String ext;
/*     */   private int length;
/*  46 */   private int type = -1;
/*     */ 
/*     */   URLPattern(String pattern)
/*     */   {
/*  50 */     this.pattern = pattern;
/*  51 */     this.length = pattern.length();
/*  52 */     if (pattern.equals("/")) {
/*  53 */       this.type = 0;
/*  54 */     } else if (pattern.startsWith("/*")) {
/*  55 */       this.type = 1;
/*  56 */     } else if ((this.length > 0) && (pattern.charAt(0) == '/') && (pattern.endsWith("/*"))) {
/*  57 */       this.type = 2;
/*  58 */     } else if (pattern.startsWith("*."))
/*     */     {
/*  60 */       this.type = 3;
/*  61 */       this.ext = pattern.substring(1);
/*     */     }
/*     */     else {
/*  64 */       this.type = 4;
/*     */     }
/*     */   }
/*     */ 
/*     */   boolean matches(URLPattern url)
/*     */   {
/*  82 */     return matches(url.pattern);
/*     */   }
/*     */ 
/*     */   boolean matches(String urlPattern)
/*     */   {
/*  88 */     if ((this.type == 0) || (this.type == 1)) {
/*  89 */       return true;
/*     */     }
/*     */ 
/*  92 */     if ((this.type == 3) && (urlPattern.endsWith(this.ext))) {
/*  93 */       return true;
/*     */     }
/*     */ 
/*  96 */     if (this.type == 2)
/*     */     {
/*  98 */       if (urlPattern.regionMatches(0, this.pattern, 0, this.length - 2))
/*     */       {
/* 100 */         int last = this.length - 2;
/*     */ 
/* 102 */         return (urlPattern.length() <= last) || (urlPattern.charAt(last) == '/');
/*     */       }
/*     */ 
/* 105 */       return false;
/*     */     }
/*     */ 
/* 110 */     return this.pattern.equals(urlPattern);
/*     */   }
/*     */ 
/*     */   String getPattern()
/*     */   {
/* 117 */     return this.pattern;
/*     */   }
/*     */ 
/*     */   boolean isDefault() {
/* 121 */     return this.type == 0;
/*     */   }
/*     */ 
/*     */   boolean isExact() {
/* 125 */     return this.type == 4;
/*     */   }
/*     */ 
/*     */   boolean isExtension() {
/* 129 */     return this.type == 3;
/*     */   }
/*     */ 
/*     */   boolean isPrefix() {
/* 133 */     return (this.type == 1) || (this.type == 2);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 138 */     return this.pattern.hashCode();
/*     */   }
/*     */ 
/*     */   boolean equals(URLPattern p)
/*     */   {
/* 143 */     boolean equals = this.type == p.type;
/* 144 */     if (equals)
/*     */     {
/* 146 */       equals = this.pattern.equals(p.pattern);
/*     */     }
/* 148 */     return equals;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.jacc.URLPattern
 * JD-Core Version:    0.6.0
 */