/*     */ package javax.security.jacc;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.io.Serializable;
/*     */ import java.security.Permission;
/*     */ import java.util.Iterator;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.TreeSet;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import org.jboss.util.id.SerialVersion;
/*     */ 
/*     */ public final class WebResourcePermission extends Permission
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID;
/*  58 */   private static TreeSet ALL_HTTP_METHODS = new TreeSet();
/*     */ 
/*  62 */   private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("actions", String.class) };
/*     */   private transient URLPatternSpec urlSpec;
/*     */   private transient String httpMethodsString;
/*     */   private transient TreeSet httpMethods;
/*     */   private transient TreeSet httpExceptionList;
/*     */   private transient String httpExceptionString;
/*     */ 
/*     */   public WebResourcePermission(HttpServletRequest request)
/*     */   {
/*  99 */     this(requestURI(request), request.getMethod());
/*     */   }
/*     */ 
/*     */   public WebResourcePermission(String name, String actions)
/*     */   {
/* 165 */     super(name == null ? "/" : name);
/* 166 */     if (name == null)
/* 167 */       name = "/";
/* 168 */     this.urlSpec = new URLPatternSpec(name);
/* 169 */     parseActions(actions);
/*     */   }
/*     */ 
/*     */   public WebResourcePermission(String urlPatternSpec, String[] httpMethods)
/*     */   {
/* 188 */     super(urlPatternSpec);
/* 189 */     this.urlSpec = new URLPatternSpec(urlPatternSpec);
/* 190 */     Object[] methodInfo = canonicalMethods(httpMethods);
/* 191 */     this.httpMethods = ((TreeSet)methodInfo[0]);
/* 192 */     this.httpMethodsString = ((String)methodInfo[1]);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object p)
/*     */   {
/* 211 */     if ((p == null) || (!(p instanceof WebResourcePermission)))
/* 212 */       return false;
/* 213 */     WebResourcePermission perm = (WebResourcePermission)p;
/*     */ 
/* 219 */     return (implies(perm)) && (perm.implies(this));
/*     */   }
/*     */ 
/*     */   public String getActions()
/*     */   {
/* 242 */     return this.httpMethodsString;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 260 */     int hashCode = this.urlSpec.hash();
/* 261 */     if (this.httpMethods != null)
/* 262 */       hashCode += this.httpMethods.hashCode();
/* 263 */     return hashCode;
/*     */   }
/*     */ 
/*     */   public boolean implies(Permission p)
/*     */   {
/* 303 */     if ((p == null) || (!(p instanceof WebResourcePermission)))
/* 304 */       return false;
/* 305 */     WebResourcePermission perm = (WebResourcePermission)p;
/*     */ 
/* 307 */     boolean implies = this.urlSpec.implies(perm.urlSpec);
/* 308 */     if (implies == true)
/*     */     {
/* 310 */       if (this.httpExceptionList != null) {
/* 311 */         implies = matchExceptionList(this.httpExceptionList, perm.httpExceptionList);
/*     */       }
/* 313 */       if ((this.httpMethods != null) && (perm.httpMethods != null)) {
/* 314 */         implies = this.httpMethods.containsAll(perm.httpMethods);
/*     */       }
/*     */     }
/* 317 */     return implies;
/*     */   }
/*     */ 
/*     */   static String requestURI(HttpServletRequest request)
/*     */   {
/* 330 */     String uri = request.getRequestURI();
/* 331 */     if (uri != null)
/*     */     {
/* 333 */       String contextPath = request.getContextPath();
/* 334 */       int length = contextPath == null ? 0 : contextPath.length();
/* 335 */       if (length > 0)
/*     */       {
/* 337 */         uri = uri.substring(length);
/*     */       }
/* 339 */       if (uri.equals("/"))
/*     */       {
/* 341 */         uri = "";
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 346 */       uri = "";
/*     */     }
/* 348 */     return uri;
/*     */   }
/*     */ 
/*     */   static Object[] canonicalMethods(String[] methods)
/*     */   {
/* 353 */     TreeSet actions = new TreeSet();
/* 354 */     int length = methods != null ? methods.length : 0;
/* 355 */     for (int n = 0; n < length; n++)
/*     */     {
/* 357 */       actions.add(methods[n]);
/*     */     }
/* 359 */     return canonicalMethods(actions);
/*     */   }
/*     */ 
/*     */   static Object[] canonicalMethods(String methods)
/*     */   {
/* 368 */     if ((methods == null) || (methods.length() == 0)) {
/* 369 */       return new Object[] { ALL_HTTP_METHODS, null };
/*     */     }
/* 371 */     StringTokenizer tokenizer = new StringTokenizer(methods, ",");
/* 372 */     TreeSet actions = new TreeSet();
/* 373 */     while (tokenizer.hasMoreTokens())
/*     */     {
/* 375 */       String action = tokenizer.nextToken();
/* 376 */       actions.add(action);
/*     */     }
/* 378 */     return canonicalMethods(actions);
/*     */   }
/*     */ 
/*     */   static Object[] canonicalMethods(TreeSet actions)
/*     */   {
/* 383 */     Object[] info = { null, null };
/* 384 */     if ((actions.equals(ALL_HTTP_METHODS)) || (actions.size() == 0)) {
/* 385 */       return info;
/*     */     }
/* 387 */     info[0] = actions;
/* 388 */     Iterator iter = actions.iterator();
/* 389 */     StringBuffer tmp = new StringBuffer();
/* 390 */     while (iter.hasNext())
/*     */     {
/* 392 */       tmp.append(iter.next());
/* 393 */       tmp.append(',');
/*     */     }
/* 395 */     if (tmp.length() > 0)
/* 396 */       tmp.setLength(tmp.length() - 1);
/* 397 */     info[1] = tmp.toString();
/* 398 */     return info;
/*     */   }
/*     */ 
/*     */   private void parseActions(String actions)
/*     */   {
/* 404 */     boolean exclusionListNeeded = (actions != null) && (actions.startsWith("!"));
/* 405 */     if (exclusionListNeeded) {
/* 406 */       actions = actions.substring(1);
/*     */     }
/* 408 */     Object[] methodInfo = canonicalMethods(actions);
/* 409 */     if (exclusionListNeeded)
/*     */     {
/* 411 */       this.httpExceptionList = ((TreeSet)methodInfo[0]);
/* 412 */       this.httpExceptionString = ((String)methodInfo[1]);
/*     */     }
/*     */     else
/*     */     {
/* 416 */       this.httpMethods = ((TreeSet)methodInfo[0]);
/* 417 */       this.httpMethodsString = ((String)methodInfo[1]);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 424 */     ObjectInputStream.GetField fields = ois.readFields();
/* 425 */     String actions = (String)fields.get("actions", null);
/* 426 */     parseActions(actions);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 432 */     ObjectOutputStream.PutField fields = oos.putFields();
/* 433 */     fields.put("actions", getActions());
/* 434 */     oos.writeFields();
/*     */   }
/*     */ 
/*     */   static boolean matchExceptionList(TreeSet<String> myExceptionList, TreeSet<String> matchingExceptionList)
/*     */   {
/* 440 */     boolean bothnull = (myExceptionList == null) && (matchingExceptionList == null);
/* 441 */     boolean onenull = ((myExceptionList == null) && (matchingExceptionList != null)) || ((myExceptionList != null) && (matchingExceptionList == null));
/*     */ 
/* 444 */     if (bothnull)
/* 445 */       return true;
/* 446 */     if (onenull) {
/* 447 */       return false;
/*     */     }
/* 449 */     for (String httpMethod : matchingExceptionList)
/*     */     {
/* 451 */       if (myExceptionList.contains(httpMethod))
/* 452 */         return false;
/*     */     }
/* 454 */     return true;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  68 */     ALL_HTTP_METHODS.add("GET");
/*  69 */     ALL_HTTP_METHODS.add("POST");
/*  70 */     ALL_HTTP_METHODS.add("PUT");
/*  71 */     ALL_HTTP_METHODS.add("DELETE");
/*  72 */     ALL_HTTP_METHODS.add("HEAD");
/*  73 */     ALL_HTTP_METHODS.add("OPTIONS");
/*  74 */     ALL_HTTP_METHODS.add("TRACE");
/*  75 */     if (SerialVersion.version == 0)
/*  76 */       serialVersionUID = 141000L;
/*     */     else
/*  78 */       serialVersionUID = 1L;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.security.jacc.WebResourcePermission
 * JD-Core Version:    0.6.0
 */