/*     */ package javax.servlet.http;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.text.MessageFormat;
/*     */ import java.util.Enumeration;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.servlet.GenericServlet;
/*     */ import javax.servlet.ServletException;
/*     */ import javax.servlet.ServletOutputStream;
/*     */ import javax.servlet.ServletRequest;
/*     */ import javax.servlet.ServletResponse;
/*     */ 
/*     */ public abstract class HttpServlet extends GenericServlet
/*     */   implements Serializable
/*     */ {
/*     */   private static final String METHOD_DELETE = "DELETE";
/*     */   private static final String METHOD_HEAD = "HEAD";
/*     */   private static final String METHOD_GET = "GET";
/*     */   private static final String METHOD_OPTIONS = "OPTIONS";
/*     */   private static final String METHOD_POST = "POST";
/*     */   private static final String METHOD_PUT = "PUT";
/*     */   private static final String METHOD_TRACE = "TRACE";
/*     */   private static final String HEADER_IFMODSINCE = "If-Modified-Since";
/*     */   private static final String HEADER_LASTMOD = "Last-Modified";
/*     */   private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
/*  98 */   private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
/*     */ 
/*     */   protected void doGet(HttpServletRequest req, HttpServletResponse resp)
/*     */     throws ServletException, IOException
/*     */   {
/* 185 */     String protocol = req.getProtocol();
/* 186 */     String msg = lStrings.getString("http.method_get_not_supported");
/* 187 */     if (protocol.endsWith("1.1"))
/* 188 */       resp.sendError(405, msg);
/*     */     else
/* 190 */       resp.sendError(400, msg);
/*     */   }
/*     */ 
/*     */   protected long getLastModified(HttpServletRequest req)
/*     */   {
/* 224 */     return -1L;
/*     */   }
/*     */ 
/*     */   protected void doHead(HttpServletRequest req, HttpServletResponse resp)
/*     */     throws ServletException, IOException
/*     */   {
/* 269 */     NoBodyResponse response = new NoBodyResponse(resp);
/*     */ 
/* 271 */     doGet(req, response);
/* 272 */     response.setContentLength();
/*     */   }
/*     */ 
/*     */   protected void doPost(HttpServletRequest req, HttpServletResponse resp)
/*     */     throws ServletException, IOException
/*     */   {
/* 344 */     String protocol = req.getProtocol();
/* 345 */     String msg = lStrings.getString("http.method_post_not_supported");
/* 346 */     if (protocol.endsWith("1.1"))
/* 347 */       resp.sendError(405, msg);
/*     */     else
/* 349 */       resp.sendError(400, msg);
/*     */   }
/*     */ 
/*     */   protected void doPut(HttpServletRequest req, HttpServletResponse resp)
/*     */     throws ServletException, IOException
/*     */   {
/* 404 */     String protocol = req.getProtocol();
/* 405 */     String msg = lStrings.getString("http.method_put_not_supported");
/* 406 */     if (protocol.endsWith("1.1"))
/* 407 */       resp.sendError(405, msg);
/*     */     else
/* 409 */       resp.sendError(400, msg);
/*     */   }
/*     */ 
/*     */   protected void doDelete(HttpServletRequest req, HttpServletResponse resp)
/*     */     throws ServletException, IOException
/*     */   {
/* 459 */     String protocol = req.getProtocol();
/* 460 */     String msg = lStrings.getString("http.method_delete_not_supported");
/* 461 */     if (protocol.endsWith("1.1"))
/* 462 */       resp.sendError(405, msg);
/*     */     else
/* 464 */       resp.sendError(400, msg);
/*     */   }
/*     */ 
/*     */   private static Method[] getAllDeclaredMethods(Class c)
/*     */   {
/* 471 */     if (c.equals(HttpServlet.class)) {
/* 472 */       return null;
/*     */     }
/*     */ 
/* 475 */     Method[] parentMethods = getAllDeclaredMethods(c.getSuperclass());
/* 476 */     Method[] thisMethods = c.getDeclaredMethods();
/*     */ 
/* 478 */     if ((parentMethods != null) && (parentMethods.length > 0)) {
/* 479 */       Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
/*     */ 
/* 481 */       System.arraycopy(parentMethods, 0, allMethods, 0, parentMethods.length);
/*     */ 
/* 483 */       System.arraycopy(thisMethods, 0, allMethods, parentMethods.length, thisMethods.length);
/*     */ 
/* 486 */       thisMethods = allMethods;
/*     */     }
/*     */ 
/* 489 */     return thisMethods;
/*     */   }
/*     */ 
/*     */   protected void doOptions(HttpServletRequest req, HttpServletResponse resp)
/*     */     throws ServletException, IOException
/*     */   {
/* 531 */     Method[] methods = getAllDeclaredMethods(getClass());
/*     */ 
/* 533 */     boolean ALLOW_GET = false;
/* 534 */     boolean ALLOW_HEAD = false;
/* 535 */     boolean ALLOW_POST = false;
/* 536 */     boolean ALLOW_PUT = false;
/* 537 */     boolean ALLOW_DELETE = false;
/* 538 */     boolean ALLOW_TRACE = true;
/* 539 */     boolean ALLOW_OPTIONS = true;
/*     */ 
/* 541 */     for (int i = 0; i < methods.length; i++) {
/* 542 */       Method m = methods[i];
/*     */ 
/* 544 */       if (m.getName().equals("doGet")) {
/* 545 */         ALLOW_GET = true;
/* 546 */         ALLOW_HEAD = true;
/*     */       }
/* 548 */       if (m.getName().equals("doPost"))
/* 549 */         ALLOW_POST = true;
/* 550 */       if (m.getName().equals("doPut"))
/* 551 */         ALLOW_PUT = true;
/* 552 */       if (m.getName().equals("doDelete")) {
/* 553 */         ALLOW_DELETE = true;
/*     */       }
/*     */     }
/*     */ 
/* 557 */     String allow = null;
/* 558 */     if ((ALLOW_GET) && 
/* 559 */       (allow == null)) allow = "GET";
/* 560 */     if (ALLOW_HEAD)
/* 561 */       if (allow == null) allow = "HEAD"; else
/* 562 */         allow = allow + ", HEAD";
/* 563 */     if (ALLOW_POST)
/* 564 */       if (allow == null) allow = "POST"; else
/* 565 */         allow = allow + ", POST";
/* 566 */     if (ALLOW_PUT)
/* 567 */       if (allow == null) allow = "PUT"; else
/* 568 */         allow = allow + ", PUT";
/* 569 */     if (ALLOW_DELETE)
/* 570 */       if (allow == null) allow = "DELETE"; else
/* 571 */         allow = allow + ", DELETE";
/* 572 */     if (ALLOW_TRACE)
/* 573 */       if (allow == null) allow = "TRACE"; else
/* 574 */         allow = allow + ", TRACE";
/* 575 */     if (ALLOW_OPTIONS) {
/* 576 */       if (allow == null) allow = "OPTIONS"; else
/* 577 */         allow = allow + ", OPTIONS";
/*     */     }
/* 579 */     resp.setHeader("Allow", allow);
/*     */   }
/*     */ 
/*     */   protected void doTrace(HttpServletRequest req, HttpServletResponse resp)
/*     */     throws ServletException, IOException
/*     */   {
/* 620 */     String CRLF = "\r\n";
/* 621 */     String responseString = "TRACE " + req.getRequestURI() + " " + req.getProtocol();
/*     */ 
/* 624 */     Enumeration reqHeaderEnum = req.getHeaderNames();
/*     */ 
/* 626 */     while (reqHeaderEnum.hasMoreElements()) {
/* 627 */       String headerName = (String)reqHeaderEnum.nextElement();
/* 628 */       responseString = responseString + CRLF + headerName + ": " + req.getHeader(headerName);
/*     */     }
/*     */ 
/* 632 */     responseString = responseString + CRLF;
/*     */ 
/* 634 */     int responseLength = responseString.length();
/*     */ 
/* 636 */     resp.setContentType("message/http");
/* 637 */     resp.setContentLength(responseLength);
/* 638 */     ServletOutputStream out = resp.getOutputStream();
/* 639 */     out.print(responseString);
/* 640 */     out.close();
/*     */   }
/*     */ 
/*     */   protected void service(HttpServletRequest req, HttpServletResponse resp)
/*     */     throws ServletException, IOException
/*     */   {
/* 683 */     String method = req.getMethod();
/*     */ 
/* 685 */     if (method.equals("GET")) {
/* 686 */       long lastModified = getLastModified(req);
/* 687 */       if (lastModified == -1L)
/*     */       {
/* 690 */         doGet(req, resp);
/*     */       } else {
/* 692 */         long ifModifiedSince = req.getDateHeader("If-Modified-Since");
/* 693 */         if (ifModifiedSince < lastModified / 1000L * 1000L)
/*     */         {
/* 697 */           maybeSetLastModified(resp, lastModified);
/* 698 */           doGet(req, resp);
/*     */         } else {
/* 700 */           resp.setStatus(304);
/*     */         }
/*     */       }
/*     */     }
/* 704 */     else if (method.equals("HEAD")) {
/* 705 */       long lastModified = getLastModified(req);
/* 706 */       maybeSetLastModified(resp, lastModified);
/* 707 */       doHead(req, resp);
/*     */     }
/* 709 */     else if (method.equals("POST")) {
/* 710 */       doPost(req, resp);
/*     */     }
/* 712 */     else if (method.equals("PUT")) {
/* 713 */       doPut(req, resp);
/*     */     }
/* 715 */     else if (method.equals("DELETE")) {
/* 716 */       doDelete(req, resp);
/*     */     }
/* 718 */     else if (method.equals("OPTIONS")) {
/* 719 */       doOptions(req, resp);
/*     */     }
/* 721 */     else if (method.equals("TRACE")) {
/* 722 */       doTrace(req, resp);
/*     */     }
/*     */     else
/*     */     {
/* 730 */       String errMsg = lStrings.getString("http.method_not_implemented");
/* 731 */       Object[] errArgs = new Object[1];
/* 732 */       errArgs[0] = method;
/* 733 */       errMsg = MessageFormat.format(errMsg, errArgs);
/*     */ 
/* 735 */       resp.sendError(501, errMsg);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void maybeSetLastModified(HttpServletResponse resp, long lastModified)
/*     */   {
/* 753 */     if (resp.containsHeader("Last-Modified"))
/* 754 */       return;
/* 755 */     if (lastModified >= 0L)
/* 756 */       resp.setDateHeader("Last-Modified", lastModified);
/*     */   }
/*     */ 
/*     */   public void service(ServletRequest req, ServletResponse res)
/*     */     throws ServletException, IOException
/*     */   {
/*     */     HttpServletRequest request;
/*     */     HttpServletResponse response;
/*     */     try
/*     */     {
/* 798 */       request = (HttpServletRequest)req;
/* 799 */       response = (HttpServletResponse)res;
/*     */     } catch (ClassCastException e) {
/* 801 */       throw new ServletException("non-HTTP request or response");
/*     */     }
/* 803 */     service(request, response);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.http.HttpServlet
 * JD-Core Version:    0.6.0
 */