/*     */ package javax.servlet.http;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.Locale;
/*     */ import javax.servlet.ServletOutputStream;
/*     */ 
/*     */ class NoBodyResponse
/*     */   implements HttpServletResponse
/*     */ {
/*     */   private HttpServletResponse resp;
/*     */   private NoBodyOutputStream noBody;
/*     */   private PrintWriter writer;
/*     */   private boolean didSetContentLength;
/*     */ 
/*     */   NoBodyResponse(HttpServletResponse r)
/*     */   {
/* 825 */     this.resp = r;
/* 826 */     this.noBody = new NoBodyOutputStream();
/*     */   }
/*     */ 
/*     */   void setContentLength()
/*     */   {
/* 831 */     if (!this.didSetContentLength)
/* 832 */       this.resp.setContentLength(this.noBody.getContentLength());
/*     */   }
/*     */ 
/*     */   public void setContentLength(int len)
/*     */   {
/* 839 */     this.resp.setContentLength(len);
/* 840 */     this.didSetContentLength = true;
/*     */   }
/*     */ 
/*     */   public void setCharacterEncoding(String charset) {
/* 844 */     this.resp.setCharacterEncoding(charset);
/*     */   }
/*     */   public void setContentType(String type) {
/* 847 */     this.resp.setContentType(type);
/*     */   }
/*     */   public String getContentType() {
/* 850 */     return this.resp.getContentType();
/*     */   }
/*     */   public ServletOutputStream getOutputStream() throws IOException {
/* 853 */     return this.noBody;
/*     */   }
/*     */   public String getCharacterEncoding() {
/* 856 */     return this.resp.getCharacterEncoding();
/*     */   }
/*     */ 
/*     */   public PrintWriter getWriter() throws UnsupportedEncodingException {
/* 860 */     if (this.writer == null)
/*     */     {
/* 863 */       OutputStreamWriter w = new OutputStreamWriter(this.noBody, getCharacterEncoding());
/* 864 */       this.writer = new PrintWriter(w);
/*     */     }
/* 866 */     return this.writer;
/*     */   }
/*     */ 
/*     */   public void setBufferSize(int size) throws IllegalStateException {
/* 870 */     this.resp.setBufferSize(size);
/*     */   }
/*     */   public int getBufferSize() {
/* 873 */     return this.resp.getBufferSize();
/*     */   }
/*     */   public void reset() throws IllegalStateException {
/* 876 */     this.resp.reset();
/*     */   }
/*     */   public void resetBuffer() throws IllegalStateException {
/* 879 */     this.resp.resetBuffer();
/*     */   }
/*     */   public boolean isCommitted() {
/* 882 */     return this.resp.isCommitted();
/*     */   }
/*     */   public void flushBuffer() throws IOException {
/* 885 */     this.resp.flushBuffer();
/*     */   }
/*     */   public void setLocale(Locale loc) {
/* 888 */     this.resp.setLocale(loc);
/*     */   }
/*     */   public Locale getLocale() {
/* 891 */     return this.resp.getLocale();
/*     */   }
/*     */ 
/*     */   public void addCookie(Cookie cookie)
/*     */   {
/* 897 */     this.resp.addCookie(cookie);
/*     */   }
/*     */   public boolean containsHeader(String name) {
/* 900 */     return this.resp.containsHeader(name);
/*     */   }
/* 904 */   /** @deprecated */
/*     */   public void setStatus(int sc, String sm) { this.resp.setStatus(sc, sm); }
/*     */ 
/*     */   public void setStatus(int sc) {
/* 907 */     this.resp.setStatus(sc);
/*     */   }
/*     */   public void setHeader(String name, String value) {
/* 910 */     this.resp.setHeader(name, value);
/*     */   }
/*     */   public void setIntHeader(String name, int value) {
/* 913 */     this.resp.setIntHeader(name, value);
/*     */   }
/*     */   public void setDateHeader(String name, long date) {
/* 916 */     this.resp.setDateHeader(name, date);
/*     */   }
/*     */   public void sendError(int sc, String msg) throws IOException {
/* 919 */     this.resp.sendError(sc, msg);
/*     */   }
/*     */   public void sendError(int sc) throws IOException {
/* 922 */     this.resp.sendError(sc);
/*     */   }
/*     */   public void sendRedirect(String location) throws IOException {
/* 925 */     this.resp.sendRedirect(location);
/*     */   }
/*     */   public String encodeURL(String url) {
/* 928 */     return this.resp.encodeURL(url);
/*     */   }
/*     */   public String encodeRedirectURL(String url) {
/* 931 */     return this.resp.encodeRedirectURL(url);
/*     */   }
/*     */   public void addHeader(String name, String value) {
/* 934 */     this.resp.addHeader(name, value);
/*     */   }
/*     */   public void addDateHeader(String name, long value) {
/* 937 */     this.resp.addDateHeader(name, value);
/*     */   }
/*     */   public void addIntHeader(String name, int value) {
/* 940 */     this.resp.addIntHeader(name, value);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public String encodeUrl(String url)
/*     */   {
/* 953 */     return encodeURL(url);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public String encodeRedirectUrl(String url)
/*     */   {
/* 970 */     return encodeRedirectURL(url);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.servlet.http.NoBodyResponse
 * JD-Core Version:    0.6.0
 */