package javax.xml.registry;

import java.util.Collection;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public abstract interface LifeCycleManager
{
  public static final String ASSOCIATION = "Association";
  public static final String AUDITABLE_EVENT = "AuditableEvent";
  public static final String CLASSIFICATION = "Classification";
  public static final String CLASSIFICATION_SCHEME = "ClassificationScheme";
  public static final String CONCEPT = "Concept";
  public static final String EMAIL_ADDRESS = "EmailAddress";
  public static final String EXTERNAL_IDENTIFIER = "ExternalIdentifier";
  public static final String EXTERNAL_LINK = "ExternalLink";
  public static final String EXTRINSIC_OBJECT = "ExtrinsicObject";
  public static final String INTERNATIONAL_STRING = "InternationalString";
  public static final String KEY = "Key";
  public static final String LOCALIZED_STRING = "LocalizedString";
  public static final String ORGANIZATION = "Organization";
  public static final String PERSON_NAME = "PersonName";
  public static final String POSTAL_ADDRESS = "PostalAddress";
  public static final String REGISTRY_ENTRY = "RegistryEntry";
  public static final String REGISTRY_PACKAGE = "RegistryPackage";
  public static final String SERVICE = "Service";
  public static final String SERVICE_BINDING = "ServiceBinding";
  public static final String SLOT = "Slot";
  public static final String SPECIFICATION_LINK = "SpecificationLink";
  public static final String TELEPHONE_NUMBER = "TelephoneNumber";
  public static final String USER = "User";
  public static final String VERSIONABLE = "Versionable";

  public abstract Association createAssociation(RegistryObject paramRegistryObject, Concept paramConcept)
    throws JAXRException;

  public abstract Classification createClassification(ClassificationScheme paramClassificationScheme, InternationalString paramInternationalString, String paramString)
    throws JAXRException;

  public abstract Classification createClassification(ClassificationScheme paramClassificationScheme, String paramString1, String paramString2)
    throws JAXRException;

  public abstract Classification createClassification(Concept paramConcept)
    throws JAXRException, InvalidRequestException;

  public abstract ClassificationScheme createClassificationScheme(InternationalString paramInternationalString1, InternationalString paramInternationalString2)
    throws JAXRException, InvalidRequestException;

  public abstract ClassificationScheme createClassificationScheme(Concept paramConcept)
    throws JAXRException, InvalidRequestException;

  public abstract ClassificationScheme createClassificationScheme(String paramString1, String paramString2)
    throws JAXRException, InvalidRequestException;

  public abstract Concept createConcept(RegistryObject paramRegistryObject, String paramString1, String paramString2)
    throws JAXRException;

  public abstract Concept createConcept(RegistryObject paramRegistryObject, InternationalString paramInternationalString, String paramString)
    throws JAXRException;

  public abstract EmailAddress createEmailAddress(String paramString)
    throws JAXRException;

  public abstract EmailAddress createEmailAddress(String paramString1, String paramString2)
    throws JAXRException;

  public abstract ExternalIdentifier createExternalIdentifier(ClassificationScheme paramClassificationScheme, String paramString1, String paramString2)
    throws JAXRException;

  public abstract ExternalIdentifier createExternalIdentifier(ClassificationScheme paramClassificationScheme, InternationalString paramInternationalString, String paramString)
    throws JAXRException;

  public abstract ExternalLink createExternalLink(String paramString1, String paramString2)
    throws JAXRException;

  public abstract ExternalLink createExternalLink(String paramString, InternationalString paramInternationalString)
    throws JAXRException;

  public abstract ExtrinsicObject createExtrinsicObject(DataHandler paramDataHandler)
    throws JAXRException;

  public abstract InternationalString createInternationalString()
    throws JAXRException;

  public abstract InternationalString createInternationalString(String paramString)
    throws JAXRException;

  public abstract InternationalString createInternationalString(Locale paramLocale, String paramString)
    throws JAXRException;

  public abstract Key createKey(String paramString)
    throws JAXRException;

  public abstract LocalizedString createLocalizedString(Locale paramLocale, String paramString)
    throws JAXRException;

  public abstract LocalizedString createLocalizedString(Locale paramLocale, String paramString1, String paramString2)
    throws JAXRException;

  public abstract Object createObject(String paramString)
    throws JAXRException, InvalidRequestException, UnsupportedCapabilityException;

  public abstract Organization createOrganization(String paramString)
    throws JAXRException;

  public abstract Organization createOrganization(InternationalString paramInternationalString)
    throws JAXRException;

  public abstract PersonName createPersonName(String paramString)
    throws JAXRException;

  public abstract PersonName createPersonName(String paramString1, String paramString2, String paramString3)
    throws JAXRException;

  public abstract PostalAddress createPostalAddress(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6, String paramString7)
    throws JAXRException;

  public abstract RegistryPackage createRegistryPackage(String paramString)
    throws JAXRException;

  public abstract RegistryPackage createRegistryPackage(InternationalString paramInternationalString)
    throws JAXRException;

  public abstract Service createService(String paramString)
    throws JAXRException;

  public abstract Service createService(InternationalString paramInternationalString)
    throws JAXRException;

  public abstract ServiceBinding createServiceBinding()
    throws JAXRException;

  public abstract Slot createSlot(String paramString1, String paramString2, String paramString3)
    throws JAXRException;

  public abstract Slot createSlot(String paramString1, Collection paramCollection, String paramString2)
    throws JAXRException;

  public abstract SpecificationLink createSpecificationLink()
    throws JAXRException;

  public abstract TelephoneNumber createTelephoneNumber()
    throws JAXRException;

  public abstract User createUser()
    throws JAXRException;

  public abstract BulkResponse deleteObjects(Collection paramCollection)
    throws JAXRException;

  public abstract BulkResponse deleteObjects(Collection paramCollection, String paramString)
    throws JAXRException;

  public abstract BulkResponse deprecateObjects(Collection paramCollection)
    throws JAXRException;

  public abstract RegistryService getRegistryService()
    throws JAXRException;

  public abstract BulkResponse saveObjects(Collection paramCollection)
    throws JAXRException;

  public abstract BulkResponse unDeprecateObjects(Collection paramCollection)
    throws JAXRException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.registry.LifeCycleManager
 * JD-Core Version:    0.6.0
 */