/*    */ package javax.xml.rpc.soap;
/*    */ 
/*    */ import java.util.logging.Logger;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.soap.Detail;
/*    */ import javax.xml.soap.Name;
/*    */ 
/*    */ public class SOAPFaultException extends RuntimeException
/*    */ {
/*    */   private static final long serialVersionUID = -7224636940495025621L;
/* 54 */   private static Logger log = Logger.getLogger(SOAPFaultException.class.getName());
/*    */   private QName faultCode;
/*    */   private String faultString;
/*    */   private String faultActor;
/*    */   private Detail faultDetail;
/*    */ 
/*    */   public SOAPFaultException(QName faultCode, String faultString, String faultActor, Detail faultDetail)
/*    */   {
/* 63 */     super(faultString);
/*    */ 
/* 65 */     Name detailName = faultDetail != null ? faultDetail.getElementName() : null;
/* 66 */     log.fine("new SOAPFaultException [code=" + faultCode + ",string=" + faultString + ",actor=" + faultActor + ",detail=" + detailName + "]");
/*    */ 
/* 68 */     this.faultCode = faultCode;
/* 69 */     this.faultString = faultString;
/* 70 */     this.faultActor = faultActor;
/* 71 */     this.faultDetail = faultDetail;
/*    */   }
/*    */ 
/*    */   public QName getFaultCode()
/*    */   {
/* 76 */     return this.faultCode;
/*    */   }
/*    */ 
/*    */   public String getFaultString()
/*    */   {
/* 81 */     return this.faultString;
/*    */   }
/*    */ 
/*    */   public String getFaultActor()
/*    */   {
/* 86 */     return this.faultActor;
/*    */   }
/*    */ 
/*    */   public Detail getDetail()
/*    */   {
/* 91 */     return this.faultDetail;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.rpc.soap.SOAPFaultException
 * JD-Core Version:    0.6.0
 */