/*     */ package javax.xml.stream;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import javax.xml.stream.util.XMLEventAllocator;
/*     */ import javax.xml.transform.Source;
/*     */ 
/*     */ public abstract class XMLInputFactory
/*     */ {
/*     */   private static final String XML_INPUT_FACTORY_KEY = "javax.xml.stream.XMLInputFactory";
/*     */   private static final String XML_INPUT_FACTORY_DEFAULT = "com.ctc.wstx.stax.WstxInputFactory";
/*     */   public static final String IS_NAMESPACE_AWARE = "javax.xml.stream.isNamespaceAware";
/*     */   public static final String IS_VALIDATING = "javax.xml.stream.isValidating";
/*     */   public static final String IS_COALESCING = "javax.xml.stream.isCoalescing";
/*     */   public static final String IS_REPLACING_ENTITY_REFERENCES = "javax.xml.stream.isReplacingEntityReferences";
/*     */   public static final String IS_SUPPORTING_EXTERNAL_ENTITIES = "javax.xml.stream.isSupportingExternalEntities";
/*     */   public static final String SUPPORT_DTD = "javax.xml.stream.supportDTD";
/*     */   public static final String REPORTER = "javax.xml.stream.reporter";
/*     */   public static final String RESOLVER = "javax.xml.stream.resolver";
/*     */   public static final String ALLOCATOR = "javax.xml.stream.allocator";
/*     */ 
/*     */   public static XMLInputFactory newInstance()
/*     */     throws FactoryConfigurationError
/*     */   {
/* 206 */     return (XMLInputFactory)FactoryLocator.find("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
/*     */   }
/*     */ 
/*     */   public static XMLInputFactory newInstance(String factoryId, ClassLoader classLoader)
/*     */     throws FactoryConfigurationError
/*     */   {
/* 220 */     return (XMLInputFactory)FactoryLocator.find(factoryId, "com.ctc.wstx.stax.WstxInputFactory", classLoader);
/*     */   }
/*     */ 
/*     */   public abstract XMLStreamReader createXMLStreamReader(Reader paramReader)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLStreamReader createXMLStreamReader(Source paramSource)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLStreamReader createXMLStreamReader(InputStream paramInputStream)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLStreamReader createXMLStreamReader(InputStream paramInputStream, String paramString)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLStreamReader createXMLStreamReader(String paramString, InputStream paramInputStream)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLStreamReader createXMLStreamReader(String paramString, Reader paramReader)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventReader createXMLEventReader(Reader paramReader)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventReader createXMLEventReader(String paramString, Reader paramReader)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventReader createXMLEventReader(XMLStreamReader paramXMLStreamReader)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventReader createXMLEventReader(Source paramSource)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventReader createXMLEventReader(InputStream paramInputStream)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventReader createXMLEventReader(InputStream paramInputStream, String paramString)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventReader createXMLEventReader(String paramString, InputStream paramInputStream)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLStreamReader createFilteredReader(XMLStreamReader paramXMLStreamReader, StreamFilter paramStreamFilter)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLEventReader createFilteredReader(XMLEventReader paramXMLEventReader, EventFilter paramEventFilter)
/*     */     throws XMLStreamException;
/*     */ 
/*     */   public abstract XMLResolver getXMLResolver();
/*     */ 
/*     */   public abstract void setXMLResolver(XMLResolver paramXMLResolver);
/*     */ 
/*     */   public abstract XMLReporter getXMLReporter();
/*     */ 
/*     */   public abstract void setXMLReporter(XMLReporter paramXMLReporter);
/*     */ 
/*     */   public abstract void setProperty(String paramString, Object paramObject)
/*     */     throws IllegalArgumentException;
/*     */ 
/*     */   public abstract Object getProperty(String paramString)
/*     */     throws IllegalArgumentException;
/*     */ 
/*     */   public abstract boolean isPropertySupported(String paramString);
/*     */ 
/*     */   public abstract void setEventAllocator(XMLEventAllocator paramXMLEventAllocator);
/*     */ 
/*     */   public abstract XMLEventAllocator getEventAllocator();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     javax.xml.stream.XMLInputFactory
 * JD-Core Version:    0.6.0
 */