/*     */ package org.jboss;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public final class Version
/*     */ {
/*     */   public static final String VERSION_MAJOR = "version.major";
/*     */   public static final String VERSION_MINOR = "version.minor";
/*     */   public static final String VERSION_REVISION = "version.revision";
/*     */   public static final String VERSION_TAG = "version.tag";
/*     */   public static final String VERSION_NAME = "version.name";
/*     */   public static final String VERSION_CVSTAG = "version.cvstag";
/*     */   public static final String BUILD_NUMBER = "build.number";
/*     */   public static final String BUILD_ID = "build.id";
/*     */   public static final String BUILD_DATE = "build.day";
/*     */   public static final String BUILD_JVM_VERSION = "java.vm.version";
/*     */   public static final String BUILD_JVM_VENDOR = "java.vendor";
/*     */   public static final String BUILD_OS = "os.name";
/*     */   public static final String BUILD_OS_ARCH = "os.arch";
/*     */   public static final String BUILD_OS_VERSION = "os.version";
/*  60 */   private static Version instance = null;
/*     */   private Properties props;
/*     */ 
/*     */   private Version()
/*     */   {
/*  72 */     this.props = loadProperties();
/*     */   }
/*     */ 
/*     */   public static Version getInstance()
/*     */   {
/*  82 */     if (instance == null)
/*     */     {
/*  84 */       instance = new Version();
/*     */     }
/*  86 */     return instance;
/*     */   }
/*     */ 
/*     */   public Map<Object, Object> getProperties()
/*     */   {
/*  96 */     return Collections.unmodifiableMap(this.props);
/*     */   }
/*     */ 
/*     */   public String getProperty(String name)
/*     */   {
/* 107 */     return this.props.getProperty(name);
/*     */   }
/*     */ 
/*     */   public int getMajor()
/*     */   {
/* 117 */     return getIntProperty("version.major");
/*     */   }
/*     */ 
/*     */   public int getMinor()
/*     */   {
/* 127 */     return getIntProperty("version.minor");
/*     */   }
/*     */ 
/*     */   public int getRevision()
/*     */   {
/* 137 */     return getIntProperty("version.revision");
/*     */   }
/*     */ 
/*     */   public String getTag()
/*     */   {
/* 147 */     return this.props.getProperty("version.tag");
/*     */   }
/*     */ 
/*     */   public String getCvsTag()
/*     */   {
/* 156 */     return this.props.getProperty("version.cvstag");
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 166 */     return this.props.getProperty("version.name");
/*     */   }
/*     */ 
/*     */   public String getBuildID()
/*     */   {
/* 176 */     return this.props.getProperty("build.id");
/*     */   }
/*     */ 
/*     */   public String getBuildNumber()
/*     */   {
/* 186 */     return this.props.getProperty("build.number");
/*     */   }
/*     */ 
/*     */   public String getBuildDate()
/*     */   {
/* 196 */     return this.props.getProperty("build.day");
/*     */   }
/*     */ 
/*     */   public String getBuildJVM()
/*     */   {
/* 205 */     String vm = this.props.getProperty("java.vm.version");
/* 206 */     String vendor = this.props.getProperty("java.vendor");
/* 207 */     return vm + '(' + vendor + ')';
/*     */   }
/*     */ 
/*     */   public String getBuildOS()
/*     */   {
/* 218 */     String os = this.props.getProperty("os.name");
/* 219 */     String arch = this.props.getProperty("os.arch");
/* 220 */     String version = this.props.getProperty("os.version");
/* 221 */     return os + '(' + arch + ',' + version + ')';
/*     */   }
/*     */ 
/*     */   public String getVersionNumber()
/*     */   {
/* 231 */     StringBuffer buff = new StringBuffer();
/*     */ 
/* 233 */     buff.append(getMajor()).append(".");
/* 234 */     buff.append(getMinor()).append(".");
/* 235 */     buff.append(getRevision()).append(".");
/* 236 */     buff.append(getTag());
/*     */ 
/* 238 */     return buff.toString();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 248 */     StringBuffer buff = new StringBuffer();
/*     */ 
/* 250 */     buff.append(getVersionNumber());
/* 251 */     buff.append(" (build: SVNTag=");
/* 252 */     buff.append(getCvsTag());
/* 253 */     buff.append(" date=");
/* 254 */     buff.append(getBuildID());
/* 255 */     buff.append(")");
/*     */ 
/* 257 */     return buff.toString();
/*     */   }
/*     */ 
/*     */   private int getIntProperty(String name)
/*     */   {
/*     */     try
/*     */     {
/* 271 */       return Integer.valueOf(this.props.getProperty(name)).intValue();
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 275 */     return -1;
/*     */   }
/*     */ 
/*     */   private Properties loadProperties()
/*     */   {
/* 284 */     this.props = new Properties();
/*     */     try
/*     */     {
/* 288 */       InputStream in = Version.class.getResourceAsStream("/org/jboss/version.properties");
/*     */ 
/* 290 */       if (in != null)
/*     */       {
/* 292 */         this.props.load(in);
/* 293 */         in.close();
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 298 */       throw new Error("Missing version.properties");
/*     */     }
/*     */ 
/* 301 */     return this.props;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.Version
 * JD-Core Version:    0.6.0
 */