/*     */ package org.jboss.annotation.factory.javassist;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javassist.bytecode.annotation.Annotation;
/*     */ import javassist.bytecode.annotation.AnnotationMemberValue;
/*     */ import javassist.bytecode.annotation.ArrayMemberValue;
/*     */ import javassist.bytecode.annotation.BooleanMemberValue;
/*     */ import javassist.bytecode.annotation.ByteMemberValue;
/*     */ import javassist.bytecode.annotation.CharMemberValue;
/*     */ import javassist.bytecode.annotation.ClassMemberValue;
/*     */ import javassist.bytecode.annotation.DoubleMemberValue;
/*     */ import javassist.bytecode.annotation.EnumMemberValue;
/*     */ import javassist.bytecode.annotation.FloatMemberValue;
/*     */ import javassist.bytecode.annotation.IntegerMemberValue;
/*     */ import javassist.bytecode.annotation.LongMemberValue;
/*     */ import javassist.bytecode.annotation.MemberValue;
/*     */ import javassist.bytecode.annotation.MemberValueVisitor;
/*     */ import javassist.bytecode.annotation.ShortMemberValue;
/*     */ import javassist.bytecode.annotation.StringMemberValue;
/*     */ 
/*     */ public class ProxyMapCreator
/*     */   implements MemberValueVisitor
/*     */ {
/*     */   public Object value;
/*     */   private Class type;
/*     */ 
/*     */   public ProxyMapCreator(Class type)
/*     */   {
/*  62 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public void visitAnnotationMemberValue(AnnotationMemberValue annotationMemberValue)
/*     */   {
/*     */     try
/*     */     {
/*  69 */       this.value = AnnotationProxy.createProxy(annotationMemberValue.getValue());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  73 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void visitArrayMemberValue(ArrayMemberValue arrayMemberValue)
/*     */   {
/*  79 */     Class baseType = this.type.getComponentType();
/*  80 */     int size = 0;
/*  81 */     if (arrayMemberValue.getValue() != null)
/*     */     {
/*  83 */       size = arrayMemberValue.getValue().length;
/*     */     }
/*  85 */     this.value = Array.newInstance(baseType, size);
/*  86 */     MemberValue[] elements = arrayMemberValue.getValue();
/*  87 */     for (int i = 0; i < size; i++)
/*     */     {
/*  89 */       ProxyMapCreator creator = new ProxyMapCreator(baseType);
/*  90 */       elements[i].accept(creator);
/*  91 */       Array.set(this.value, i, creator.value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void visitBooleanMemberValue(BooleanMemberValue booleanMemberValue)
/*     */   {
/*  97 */     this.value = new Boolean(booleanMemberValue.getValue());
/*     */   }
/*     */ 
/*     */   public void visitByteMemberValue(ByteMemberValue byteMemberValue)
/*     */   {
/* 102 */     this.value = new Byte(byteMemberValue.getValue());
/*     */   }
/*     */ 
/*     */   public void visitCharMemberValue(CharMemberValue charMemberValue)
/*     */   {
/* 107 */     this.value = new Character(charMemberValue.getValue());
/*     */   }
/*     */ 
/*     */   public void visitDoubleMemberValue(DoubleMemberValue doubleMemberValue)
/*     */   {
/* 112 */     this.value = new Double(doubleMemberValue.getValue());
/*     */   }
/*     */ 
/*     */   public void visitEnumMemberValue(EnumMemberValue enumMemberValue)
/*     */   {
/*     */     try
/*     */     {
/* 119 */       Field enumVal = this.type.getField(enumMemberValue.getValue());
/* 120 */       this.value = enumVal.get(null);
/*     */     }
/*     */     catch (NoSuchFieldException e)
/*     */     {
/* 124 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (SecurityException e)
/*     */     {
/* 128 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalArgumentException e)
/*     */     {
/* 132 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 136 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void visitFloatMemberValue(FloatMemberValue floatMemberValue)
/*     */   {
/* 142 */     this.value = new Float(floatMemberValue.getValue());
/*     */   }
/*     */ 
/*     */   public void visitIntegerMemberValue(IntegerMemberValue integerMemberValue)
/*     */   {
/* 147 */     this.value = new Integer(integerMemberValue.getValue());
/*     */   }
/*     */ 
/*     */   public void visitLongMemberValue(LongMemberValue longMemberValue)
/*     */   {
/* 152 */     this.value = new Long(longMemberValue.getValue());
/*     */   }
/*     */ 
/*     */   public void visitShortMemberValue(ShortMemberValue shortMemberValue)
/*     */   {
/* 157 */     this.value = new Short(shortMemberValue.getValue());
/*     */   }
/*     */ 
/*     */   public void visitStringMemberValue(StringMemberValue stringMemberValue)
/*     */   {
/* 162 */     this.value = stringMemberValue.getValue();
/*     */   }
/*     */ 
/*     */   public void visitClassMemberValue(ClassMemberValue classMemberValue)
/*     */   {
/*     */     try
/*     */     {
/* 169 */       String classname = classMemberValue.getValue();
/* 170 */       if (classname.equals("void"))
/*     */       {
/* 172 */         this.value = Void.TYPE;
/*     */       }
/* 174 */       else if (classname.equals("int"))
/*     */       {
/* 176 */         this.value = Integer.TYPE;
/*     */       }
/* 178 */       else if (classname.equals("byte"))
/*     */       {
/* 180 */         this.value = Byte.TYPE;
/*     */       }
/* 182 */       else if (classname.equals("long"))
/*     */       {
/* 184 */         this.value = Long.TYPE;
/*     */       }
/* 186 */       else if (classname.equals("double"))
/*     */       {
/* 188 */         this.value = Double.TYPE;
/*     */       }
/* 190 */       else if (classname.equals("float"))
/*     */       {
/* 192 */         this.value = Float.TYPE;
/*     */       }
/* 194 */       else if (classname.equals("char"))
/*     */       {
/* 196 */         this.value = Character.TYPE;
/*     */       }
/* 198 */       else if (classname.equals("short"))
/*     */       {
/* 200 */         this.value = Short.TYPE;
/*     */       }
/* 202 */       else if (classname.equals("boolean"))
/*     */       {
/* 204 */         this.value = Boolean.TYPE;
/*     */       }
/*     */       else
/*     */       {
/* 208 */         this.value = Thread.currentThread().getContextClassLoader().loadClass(classMemberValue.getValue());
/*     */       }
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 213 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Class getMemberType(Class annotation, String member)
/*     */   {
/* 220 */     Method[] methods = annotation.getMethods();
/* 221 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 223 */       if (methods[i].getName().equals(member))
/*     */       {
/* 225 */         return methods[i].getReturnType();
/*     */       }
/*     */     }
/* 228 */     throw new RuntimeException("unable to determine member type for annotation: " + annotation.getName() + "." + member);
/*     */   }
/*     */ 
/*     */   public static Map<String, Object> createProxyMap(Class annotation, Annotation info)
/*     */   {
/* 233 */     Map map = new HashMap();
/*     */ 
/* 235 */     if (info.getMemberNames() == null) return map;
/* 236 */     Set members = info.getMemberNames();
/* 237 */     Iterator it = members.iterator();
/* 238 */     while (it.hasNext())
/*     */     {
/* 240 */       String name = (String)it.next();
/* 241 */       MemberValue mv = info.getMemberValue(name);
/* 242 */       ProxyMapCreator creator = new ProxyMapCreator(getMemberType(annotation, name));
/* 243 */       mv.accept(creator);
/* 244 */       map.put(name, creator.value);
/*     */     }
/* 246 */     return map;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.annotation.factory.javassist.ProxyMapCreator
 * JD-Core Version:    0.6.0
 */