/*    */ package org.jboss.aop;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.MethodCall;
/*    */ 
/*    */ public abstract class CallerMethodInfo extends JoinPointInfo
/*    */   implements MethodCall
/*    */ {
/*    */   private final Class callingClass;
/*    */   private final Class calledClass;
/*    */   private final Method method;
/*    */   private final long calledMethodHash;
/*    */ 
/*    */   public CallerMethodInfo(Advisor advisor, Class calledClass, Method m, long calledMethodHash, Interceptor[] in, Class clazz)
/*    */   {
/* 45 */     super(advisor, clazz);
/* 46 */     this.calledClass = calledClass;
/* 47 */     super.setInterceptors(in);
/* 48 */     this.method = m;
/* 49 */     this.calledMethodHash = calledMethodHash;
/* 50 */     this.callingClass = advisor.getClazz();
/*    */   }
/*    */ 
/*    */   protected CallerMethodInfo(CallerMethodInfo other)
/*    */   {
/* 58 */     super(other);
/* 59 */     this.callingClass = other.callingClass;
/* 60 */     this.calledClass = other.calledClass;
/* 61 */     this.method = other.method;
/* 62 */     this.calledMethodHash = other.calledMethodHash;
/*    */   }
/*    */ 
/*    */   public Class getCallingClass()
/*    */   {
/* 67 */     return this.callingClass;
/*    */   }
/*    */ 
/*    */   public Class getCalledClass()
/*    */   {
/* 72 */     return this.calledClass;
/*    */   }
/*    */ 
/*    */   public Method getMethod()
/*    */   {
/* 77 */     return this.method;
/*    */   }
/*    */ 
/*    */   public long getCalledMethodHash()
/*    */   {
/* 82 */     return this.calledMethodHash;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.CallerMethodInfo
 * JD-Core Version:    0.6.0
 */