/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import javassist.ByteArrayClassPath;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.instrument.Instrumentor;
/*     */ import org.jboss.aop.instrument.InstrumentorFactory;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassicWeavingStrategy extends WeavingStrategySupport
/*     */ {
/*  43 */   private static final Logger logger = AOPLogger.getLogger(ClassicWeavingStrategy.class);
/*     */ 
/*  45 */   private boolean verbose = AspectManager.verbose;
/*     */ 
/*     */   public byte[] translate(AspectManager manager, String className, ClassLoader loader, byte[] classfileBuffer)
/*     */     throws Exception
/*     */   {
/*  51 */     if (isReEntry())
/*     */     {
/*  53 */       return null;
/*     */     }
/*  55 */     setReEntry();
/*  56 */     manager.transformationStarted = true;
/*     */     try
/*     */     {
/*  59 */       if (manager.isNonAdvisableClassName(className))
/*     */       {
/*  61 */         Object localObject1 = null;
/*     */         return localObject1;
/*     */       }
/*  63 */       AOPClassPool pool = (AOPClassPool)manager.registerClassLoader(loader);
/*  64 */       CtClass clazz = null;
/*     */       try
/*     */       {
/*  67 */         clazz = pool.getLocally(className);
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/*  73 */         ByteArrayClassPath cp = new ByteArrayClassPath(className, classfileBuffer);
/*  74 */         pool.insertClassPath(cp);
/*  75 */         clazz = pool.getLocally(className);
/*     */       }
/*  77 */       if (clazz.isArray())
/*     */       {
/*  79 */         if ((this.verbose) && (logger.isDebugEnabled())) logger.debug("cannot compile, isArray: " + className);
/*  80 */         pool.flushClass(className);
/*  81 */         e = null;
/*     */         return e;
/*     */       }
/*  83 */       if (clazz.isInterface())
/*     */       {
/*  85 */         if ((this.verbose) && (logger.isDebugEnabled())) logger.debug("cannot compile, isInterface: " + className);
/*  86 */         pool.flushClass(className);
/*  87 */         e = null;
/*     */         return e;
/*     */       }
/*  89 */       if (clazz.isFrozen())
/*     */       {
/*  91 */         if ((this.verbose) && (logger.isDebugEnabled())) logger.debug("warning, isFrozen: " + className);
/*  92 */         clazz.defrost();
/*     */       }
/*     */ 
/*  95 */       ClassAdvisor advisor = new ClassAdvisor(className, manager);
/*  96 */       Instrumentor instrumentor = InstrumentorFactory.getInstrumentor(pool, manager, manager.dynamicStrategy.getJoinpointClassifier(), manager.dynamicStrategy.getDynamicTransformationObserver(clazz));
/*     */ 
/* 102 */       if (!Instrumentor.isTransformable(clazz))
/*     */       {
/* 104 */         if ((this.verbose) && (logger.isDebugEnabled())) logger.debug("[cannot compile] implements Untransformable: " + className);
/* 105 */         pool.flushClass(className);
/* 106 */         Object localObject2 = null;
/*     */         return localObject2;
/*     */       }
/* 109 */       manager.attachMetaData(advisor, clazz, true);
/* 110 */       manager.applyInterfaceIntroductions(advisor, clazz);
/* 111 */       boolean transformed = instrumentor.transform(clazz, advisor);
/* 112 */       if (transformed)
/*     */       {
/* 114 */         pool.lockInCache(clazz);
/* 115 */         if (AspectManager.debugClasses)
/*     */         {
/* 117 */           SecurityActions.debugWriteFile(clazz);
/*     */         }
/*     */ 
/* 120 */         rtn = clazz.toBytecode();
/* 121 */         if (AspectManager.getPrune()) clazz.prune();
/* 122 */         byte[] arrayOfByte1 = rtn;
/*     */         return arrayOfByte1;
/*     */       }
/* 126 */       pool.soften(clazz);
/*     */ 
/* 128 */       byte[] rtn = null;
/*     */       return rtn;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 132 */       if (!(ex instanceof NotFoundException))
/*     */       {
/* 134 */         if (this.verbose)
/* 135 */           ex.printStackTrace();
/*     */         else {
/* 137 */           System.err.println("[error] " + ex.getMessage() + ".. Do verbose mode if you want full stack trace.");
/*     */         }
/*     */       }
/* 140 */       throw ex;
/*     */     }
/*     */     finally
/*     */     {
/* 144 */       clearReEntry(); } throw localObject3;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ClassicWeavingStrategy
 * JD-Core Version:    0.6.0
 */