/*      */ package org.jboss.aop;
/*      */ 
/*      */ import gnu.trove.TLongObjectHashMap;
/*      */ import java.io.PrintStream;
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.concurrent.ConcurrentHashMap;
/*      */ import org.jboss.aop.advice.AdviceBinding;
/*      */ import org.jboss.aop.advice.AspectDefinition;
/*      */ import org.jboss.aop.advice.AspectFactory;
/*      */ import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
/*      */ import org.jboss.aop.advice.InterceptorFactory;
/*      */ import org.jboss.aop.advice.PrecedenceSorter;
/*      */ import org.jboss.aop.instrument.ConByConJoinPointGenerator;
/*      */ import org.jboss.aop.instrument.ConByMethodJoinPointGenerator;
/*      */ import org.jboss.aop.instrument.ConstructionJoinPointGenerator;
/*      */ import org.jboss.aop.instrument.ConstructorJoinPointGenerator;
/*      */ import org.jboss.aop.instrument.FieldJoinPointGenerator;
/*      */ import org.jboss.aop.instrument.JoinPointGenerator;
/*      */ import org.jboss.aop.instrument.MethodByConJoinPointGenerator;
/*      */ import org.jboss.aop.instrument.MethodByMethodJoinPointGenerator;
/*      */ import org.jboss.aop.instrument.MethodJoinPointGenerator;
/*      */ import org.jboss.aop.joinpoint.FieldJoinpoint;
/*      */ import org.jboss.aop.joinpoint.Joinpoint;
/*      */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*      */ import org.jboss.aop.pointcut.Pointcut;
/*      */ import org.jboss.aop.pointcut.PointcutMethodMatch;
/*      */ import org.jboss.aop.util.UnmodifiableEmptyCollections;
/*      */ 
/*      */ public class GeneratedClassAdvisor extends ClassAdvisor
/*      */ {
/*      */   public static final String ADD_METHOD_INFO = "addMethodInfo";
/*      */   public static final String ADD_CONSTRUCTOR_INFO = "addConstructorInfo";
/*      */   public static final String ADD_CONSTRUCTION_INFO = "addConstructionInfo";
/*      */   public static final String ADD_FIELD_READ_INFO = "addFieldReadInfo";
/*      */   public static final String ADD_FIELD_WRITE_INFO = "addFieldWriteInfo";
/*      */   public static final String GET_PARENT_ADVISOR = "getParentAdvisor";
/*   71 */   MethodInterceptors methodInfos = new MethodInterceptors(this);
/*   72 */   ArrayList constructorInfos = new ArrayList();
/*   73 */   ArrayList constructionInfos = new ArrayList();
/*   74 */   ArrayList fieldReadInfos = new ArrayList();
/*   75 */   ArrayList fieldWriteInfos = new ArrayList();
/*      */ 
/*   77 */   ArrayList overriddenMethods = new ArrayList();
/*      */ 
/*   81 */   private volatile ConcurrentHashMap joinPointGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*      */ 
/*   83 */   private volatile ConcurrentHashMap fieldReadJoinPoinGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*      */ 
/*   85 */   private volatile ConcurrentHashMap constructionJoinPointGenerators = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*      */ 
/*   87 */   ConcurrentHashMap oldInfos = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*   88 */   ConcurrentHashMap oldFieldReadInfos = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*   89 */   ConcurrentHashMap oldConstructionInfos = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*      */   boolean initialisedSuperClasses;
/*      */   private int version;
/*      */   AdvisorStrategy advisorStrategy;
/*  881 */   ConcurrentHashMap perClassJoinpointAspectDefinitions = new ConcurrentHashMap();
/*      */ 
/*      */   protected GeneratedClassAdvisor(String classname)
/*      */   {
/*  104 */     super(classname, null);
/*  105 */     this.advisorStrategy = new ClassAdvisorStrategy(null);
/*      */   }
/*      */ 
/*      */   protected GeneratedClassAdvisor(String classname, GeneratedClassAdvisor parent)
/*      */   {
/*  110 */     super(classname, null);
/*  111 */     this.advisorStrategy = new InstanceAdvisorStrategy(parent);
/*      */   }
/*      */ 
/*      */   public void cleanup()
/*      */   {
/*  117 */     super.cleanup();
/*  118 */     this.methodInfos = null;
/*  119 */     this.advisorStrategy = null;
/*      */ 
/*  121 */     Map subscribedSubDomains = getManager().getSubscribedSubDomains();
/*      */     Iterator it;
/*  122 */     synchronized (subscribedSubDomains)
/*      */     {
/*  124 */       for (it = subscribedSubDomains.keySet().iterator(); it.hasNext(); )
/*      */       {
/*  126 */         GeneratedAdvisorDomain manager = (GeneratedAdvisorDomain)it.next();
/*  127 */         Map advisors = manager.getAdvisors();
/*  128 */         it.remove();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initialise(Class clazz, AspectManager manager)
/*      */   {
/*  135 */     this.advisorStrategy.initialise(clazz, manager);
/*      */   }
/*      */ 
/*      */   protected void initialiseCallers()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void initialiseInfosForInstance()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected MethodInfo copyInfoFromClassAdvisor(MethodInfo info)
/*      */   {
/*  159 */     MethodInfo copy = (MethodInfo)info.copy();
/*  160 */     copy.setAdvisor(this);
/*  161 */     addMethodInfo(copy);
/*  162 */     return copy;
/*      */   }
/*      */ 
/*      */   protected FieldInfo copyInfoFromClassAdvisor(FieldInfo info)
/*      */   {
/*  170 */     FieldInfo copy = (FieldInfo)info.copy();
/*  171 */     copy.setAdvisor(this);
/*  172 */     if (copy.isRead())
/*      */     {
/*  174 */       addFieldReadInfo(copy);
/*      */     }
/*      */     else
/*      */     {
/*  178 */       addFieldWriteInfo(copy);
/*      */     }
/*  180 */     return copy;
/*      */   }
/*      */ 
/*      */   protected ConByConInfo copyInfoFromClassAdvisor(ConByConInfo info)
/*      */   {
/*  188 */     ConByConInfo copy = (ConByConInfo)info.copy();
/*  189 */     copy.setAdvisor(this);
/*  190 */     return copy;
/*      */   }
/*      */ 
/*      */   protected MethodByConInfo copyInfoFromClassAdvisor(MethodByConInfo info)
/*      */   {
/*  198 */     MethodByConInfo copy = (MethodByConInfo)info.copy();
/*  199 */     copy.setAdvisor(this);
/*  200 */     return copy;
/*      */   }
/*      */ 
/*      */   protected ConByMethodInfo copyInfoFromClassAdvisor(ConByMethodInfo info)
/*      */   {
/*  208 */     ConByMethodInfo copy = (ConByMethodInfo)info.copy();
/*  209 */     copy.setAdvisor(this);
/*  210 */     return copy;
/*      */   }
/*      */ 
/*      */   protected MethodByMethodInfo copyInfoFromClassAdvisor(MethodByMethodInfo info)
/*      */   {
/*  218 */     MethodByMethodInfo copy = (MethodByMethodInfo)info.copy();
/*  219 */     copy.setAdvisor(this);
/*  220 */     return copy;
/*      */   }
/*      */ 
/*      */   protected void rebuildInterceptors()
/*      */   {
/*  227 */     this.version += 1;
/*  228 */     this.advisorStrategy.rebuildInterceptors();
/*      */   }
/*      */ 
/*      */   protected synchronized void internalRebuildInterceptors()
/*      */   {
/*  237 */     super.rebuildInterceptors();
/*      */   }
/*      */ 
/*      */   protected void checkVersion()
/*      */   {
/*  245 */     this.advisorStrategy.checkVersion();
/*      */   }
/*      */ 
/*      */   protected void doRebuildForInstance()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void handleOverriddenMethods(AdviceBinding binding)
/*      */   {
/*      */     Iterator it;
/*  258 */     if ((this.overriddenMethods != null) && (this.overriddenMethods.size() > 0))
/*      */     {
/*  260 */       for (it = this.overriddenMethods.iterator(); it.hasNext(); )
/*      */       {
/*  262 */         MethodInfo info = (MethodInfo)it.next();
/*  263 */         Method method = info.getMethod();
/*  264 */         PointcutMethodMatch match = binding.getPointcut().matchesExecution(this, method);
/*      */ 
/*  266 */         if ((match != null) && (match.isMatch()))
/*      */         {
/*  268 */           this.adviceBindings.add(binding);
/*  269 */           if (AspectManager.verbose)
/*      */           {
/*  271 */             System.err.println("method matched binding " + binding.getPointcut().getExpr() + " " + method.toString());
/*      */           }
/*  273 */           binding.addAdvisor(this);
/*  274 */           pointcutResolved(info, binding, new MethodJoinpoint(method));
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void resolveMethodPointcut(MethodInterceptors newMethodInterceptors, AdviceBinding binding)
/*      */   {
/*  283 */     GeneratedClassAdvisor classAdvisor = getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
/*  284 */     if (classAdvisor == null)
/*      */     {
/*  287 */       super.resolveMethodPointcut(newMethodInterceptors, binding);
/*  288 */       handleOverriddenMethods(binding);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void resolveFieldPointcut(ArrayList newFieldInfos, AdviceBinding binding, boolean write)
/*      */   {
/*  296 */     GeneratedClassAdvisor classAdvisor = getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
/*  297 */     if (classAdvisor == null)
/*      */     {
/*  300 */       super.resolveFieldPointcut(newFieldInfos, binding, write);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void resolveConstructorPointcut(ArrayList newConstructorInfos, AdviceBinding binding)
/*      */   {
/*  307 */     this.advisorStrategy.resolveConstructorPointcut(newConstructorInfos, binding);
/*      */   }
/*      */ 
/*      */   protected void resolveConstructionPointcut(ArrayList newConstructionInfos, AdviceBinding binding)
/*      */   {
/*  313 */     this.advisorStrategy.resolveConstructionPointcut(newConstructionInfos, binding);
/*      */   }
/*      */ 
/*      */   protected void initialiseMethods()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void addMethodInfo(MethodInfo mi)
/*      */   {
/*  328 */     MethodInfo old = this.methodInfos.getMethodInfo(mi.getHash());
/*  329 */     if (old != null)
/*      */     {
/*  331 */       this.overriddenMethods.add(old);
/*      */     }
/*  333 */     this.methodInfos.put(mi.getHash(), mi);
/*      */ 
/*  335 */     this.advisorStrategy.makeAccessibleMethod(mi);
/*      */   }
/*      */ 
/*      */   protected MethodInterceptors initializeMethodChain()
/*      */   {
/*  343 */     long[] keys = this.advisedMethods.keys();
/*  344 */     for (int i = 0; i < keys.length; i++)
/*      */     {
/*  346 */       MethodMatchInfo matchInfo = this.methodInfos.getMatchInfo(keys[i]);
/*      */ 
/*  348 */       if ((this.initialized) && (matchInfo != null))
/*      */       {
/*  350 */         matchInfo.clear();
/*      */       }
/*      */ 
/*  353 */       if (matchInfo != null)
/*      */         continue;
/*  355 */       MethodInfo info = new MethodInfo();
/*  356 */       Method amethod = (Method)this.advisedMethods.get(keys[i]);
/*  357 */       info.setAdvisedMethod(amethod);
/*  358 */       info.setUnadvisedMethod(amethod);
/*  359 */       info.setHash(keys[i]);
/*  360 */       info.setAdvisor(this);
/*  361 */       this.methodInfos.put(keys[i], info);
/*      */     }
/*      */ 
/*  365 */     return this.methodInfos;
/*      */   }
/*      */ 
/*      */   protected void initialiseConstructors()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void addConstructorInfo(ConstructorInfo ci)
/*      */   {
/*  381 */     this.constructorInfos.add(ci);
/*      */ 
/*  383 */     SecurityActions.setAccessible(ci.getConstructor());
/*      */   }
/*      */ 
/*      */   protected void createInterceptorChains()
/*      */     throws Exception
/*      */   {
/*  389 */     this.advisorStrategy.createInterceptorChains();
/*      */   }
/*      */ 
/*      */   protected ArrayList initializeConstructorChain()
/*      */   {
/*      */     Iterator it;
/*  395 */     if (this.initialized)
/*      */     {
/*  397 */       for (it = this.constructorInfos.iterator(); it.hasNext(); )
/*      */       {
/*  399 */         ((ConstructorInfo)it.next()).clear();
/*      */       }
/*      */     }
/*  402 */     return this.constructorInfos;
/*      */   }
/*      */ 
/*      */   protected void initialiseConstructions()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void addConstructionInfo(ConstructionInfo ci)
/*      */   {
/*  417 */     this.constructionInfos.add(ci);
/*      */   }
/*      */ 
/*      */   protected ArrayList initializeConstructionChain()
/*      */   {
/*      */     Iterator it;
/*  423 */     if (this.initialized)
/*      */     {
/*  425 */       for (it = this.constructionInfos.iterator(); it.hasNext(); )
/*      */       {
/*  427 */         ((ConstructionInfo)it.next()).clear();
/*      */       }
/*      */     }
/*  430 */     return this.constructionInfos;
/*      */   }
/*      */ 
/*      */   protected void initialiseFieldReads()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void addFieldReadInfo(FieldInfo fi)
/*      */   {
/*  445 */     this.fieldReadInfos.add(fi);
/*      */ 
/*  447 */     this.advisorStrategy.makeAccessibleField(fi);
/*      */   }
/*      */ 
/*      */   protected ArrayList initializeFieldReadChain()
/*      */   {
/*  453 */     return mergeFieldInfos(this.fieldReadInfos, true);
/*      */   }
/*      */ 
/*      */   protected void initialiseFieldWrites()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void addFieldWriteInfo(FieldInfo fi)
/*      */   {
/*  468 */     this.fieldWriteInfos.add(fi);
/*      */ 
/*  470 */     this.advisorStrategy.makeAccessibleField(fi);
/*      */   }
/*      */ 
/*      */   protected ArrayList initializeFieldWriteChain()
/*      */   {
/*  476 */     return mergeFieldInfos(this.fieldWriteInfos, false);
/*      */   }
/*      */ 
/*      */   private ArrayList mergeFieldInfos(ArrayList advisedInfos, boolean read)
/*      */   {
/*  484 */     ArrayList newInfos = new ArrayList(this.advisedFields.length);
/*      */ 
/*  486 */     FieldInfo nextFieldInfo = null;
/*  487 */     Iterator it = advisedInfos.iterator();
/*  488 */     if (it.hasNext())
/*      */     {
/*  490 */       nextFieldInfo = (FieldInfo)it.next();
/*      */     }
/*      */ 
/*  493 */     for (int i = 0; i < this.advisedFields.length; i++)
/*      */     {
/*  495 */       if ((nextFieldInfo != null) && (nextFieldInfo.getIndex() == i))
/*      */       {
/*  497 */         if (this.initialized)
/*      */         {
/*  499 */           nextFieldInfo.clear();
/*      */         }
/*      */ 
/*  502 */         newInfos.add(nextFieldInfo);
/*  503 */         if (it.hasNext())
/*      */         {
/*  505 */           nextFieldInfo = (FieldInfo)it.next();
/*      */         }
/*      */         else
/*      */         {
/*  509 */           nextFieldInfo = null;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  514 */         FieldInfo info = new FieldInfo(this, read);
/*  515 */         info.setAdvisedField(this.advisedFields[i]);
/*  516 */         info.setIndex(i);
/*  517 */         newInfos.add(info);
/*      */       }
/*      */     }
/*      */ 
/*  521 */     return newInfos;
/*      */   }
/*      */ 
/*      */   protected void finalizeChains(MethodInterceptors newMethodInfos, ArrayList newFieldReadInfos, ArrayList newFieldWriteInfos, ArrayList newConstructorInfos, ArrayList newConstructionInfos)
/*      */   {
/*  527 */     ClassAdvisor classAdvisor = getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
/*  528 */     if (classAdvisor != null)
/*      */     {
/*      */       Iterator it;
/*  533 */       synchronized (this.adviceBindings)
/*      */       {
/*  535 */         this.adviceBindings.addAll(classAdvisor.adviceBindings);
/*  536 */         for (it = this.adviceBindings.iterator(); it.hasNext(); )
/*      */         {
/*  538 */           AdviceBinding binding = (AdviceBinding)it.next();
/*  539 */           binding.addAdvisor(this);
/*      */         }
/*      */       }
/*      */     }
/*  543 */     super.finalizeChains(newMethodInfos, newFieldReadInfos, newFieldWriteInfos, newConstructorInfos, newConstructionInfos);
/*      */   }
/*      */ 
/*      */   protected void finalizeMethodChain(MethodInterceptors newMethodInterceptors)
/*      */   {
/*  549 */     ClassAdvisor classAdvisor = getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
/*  550 */     if (classAdvisor != null)
/*      */     {
/*  553 */       easyFinalizeMethodChainForInstance(classAdvisor, newMethodInterceptors);
/*      */     }
/*      */     else
/*      */     {
/*  558 */       fullWorkFinalizeMethodChain(newMethodInterceptors);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void easyFinalizeMethodChainForInstance(ClassAdvisor classAdvisor, MethodInterceptors newMethodInterceptors)
/*      */   {
/*  564 */     long[] keys = newMethodInterceptors.keys();
/*  565 */     for (int i = 0; i < keys.length; i++)
/*      */     {
/*  567 */       MethodInfo classMethodInfo = classAdvisor.getMethodInfo(keys[i]);
/*  568 */       MethodMatchInfo matchInfo = newMethodInterceptors.getMatchInfo(keys[i]);
/*  569 */       MethodInfo myMethodInfo = matchInfo.getInfo();
/*  570 */       myMethodInfo.cloneChains(classMethodInfo);
/*      */ 
/*  572 */       if (!updateOldInfo(this.oldInfos, myMethodInfo, OldInfoMaps.INFOS))
/*      */         continue;
/*  574 */       MethodJoinPointGenerator generator = getJoinPointGenerator(myMethodInfo);
/*  575 */       generator.rebindJoinpoint(myMethodInfo);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void fullWorkFinalizeMethodChain(MethodInterceptors newMethodInterceptors)
/*      */   {
/*  583 */     TLongObjectHashMap newMethodInfos = new TLongObjectHashMap();
/*      */ 
/*  585 */     long[] keys = newMethodInterceptors.keys();
/*  586 */     for (int i = 0; i < keys.length; i++)
/*      */     {
/*  588 */       MethodMatchInfo matchInfo = newMethodInterceptors.getMatchInfo(keys[i]);
/*  589 */       matchInfo.populateBindings();
/*      */ 
/*  591 */       MethodInfo info = matchInfo.getInfo();
/*  592 */       newMethodInfos.put(keys[i], info);
/*      */ 
/*  594 */       MethodJoinPointGenerator generator = getJoinPointGenerator(info);
/*  595 */       finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
/*      */     }
/*  597 */     this.methodInterceptors = newMethodInfos;
/*      */     Iterator it;
/*  600 */     if ((this.overriddenMethods != null) && (this.overriddenMethods.size() > 0))
/*      */     {
/*  602 */       for (it = this.overriddenMethods.iterator(); it.hasNext(); )
/*      */       {
/*  604 */         MethodInfo info = (MethodInfo)it.next();
/*      */ 
/*  606 */         MethodJoinPointGenerator generator = getJoinPointGenerator(info);
/*  607 */         finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void finalizeFieldReadChain(ArrayList newFieldInfos)
/*      */   {
/*  615 */     ClassAdvisor classAdvisor = getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
/*  616 */     if (classAdvisor != null)
/*      */     {
/*  619 */       easyFinalizeFieldChainForInstance(this.oldFieldReadInfos, classAdvisor.getFieldReadInfos(), newFieldInfos, OldInfoMaps.FIELD_READ_INFOS);
/*      */     }
/*      */     else
/*      */     {
/*  624 */       fullWorkFinalizeFieldChain(this.oldFieldReadInfos, newFieldInfos, OldInfoMaps.FIELD_READ_INFOS);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void finalizeFieldWriteChain(ArrayList newFieldInfos)
/*      */   {
/*  631 */     ClassAdvisor classAdvisor = getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
/*  632 */     if (classAdvisor != null)
/*      */     {
/*  635 */       easyFinalizeFieldChainForInstance(this.oldInfos, classAdvisor.getFieldWriteInfos(), newFieldInfos, OldInfoMaps.INFOS);
/*      */     }
/*      */     else
/*      */     {
/*  640 */       fullWorkFinalizeFieldChain(this.oldInfos, newFieldInfos, OldInfoMaps.INFOS);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void easyFinalizeFieldChainForInstance(Map oldFieldInfos, FieldInfo[] classFieldInfos, ArrayList newFieldInfos, OldInfoMaps oldInfoMapInstance)
/*      */   {
/*  647 */     if (newFieldInfos.size() > 0)
/*      */     {
/*  649 */       for (int i = 0; i < newFieldInfos.size(); i++)
/*      */       {
/*  651 */         FieldInfo myInfo = (FieldInfo)newFieldInfos.get(i);
/*  652 */         myInfo.cloneChains(classFieldInfos[i]);
/*      */ 
/*  654 */         if (!updateOldInfo(oldFieldInfos, myInfo, oldInfoMapInstance))
/*      */           continue;
/*  656 */         FieldJoinPointGenerator generator = getJoinPointGenerator(myInfo);
/*  657 */         generator.rebindJoinpoint(myInfo);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void fullWorkFinalizeFieldChain(Map oldFieldInfos, ArrayList newFieldInfos, OldInfoMaps oldInfoMapInstance)
/*      */   {
/*  666 */     for (int i = 0; i < newFieldInfos.size(); i++)
/*      */     {
/*  668 */       FieldInfo info = (FieldInfo)newFieldInfos.get(i);
/*  669 */       FieldJoinPointGenerator generator = getJoinPointGenerator(info);
/*  670 */       finalizeChainAndRebindJoinPoint(oldFieldInfos, info, generator, oldInfoMapInstance);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void finalizeConstructorChain(ArrayList newConstructorInfos)
/*      */   {
/*  677 */     this.advisorStrategy.finalizeConstructorChain(newConstructorInfos);
/*      */   }
/*      */ 
/*      */   protected void finalizeConstructionChain(ArrayList newConstructionInfos)
/*      */   {
/*  683 */     this.advisorStrategy.finalizeConstructionChain(newConstructionInfos);
/*      */   }
/*      */ 
/*      */   protected void finalizeMethodCalledByMethodInterceptorChain(MethodByMethodInfo info)
/*      */   {
/*  689 */     MethodByMethodJoinPointGenerator generator = getJoinPointGenerator(info);
/*  690 */     finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
/*      */   }
/*      */ 
/*      */   protected void finalizeConCalledByMethodInterceptorChain(ConByMethodInfo info)
/*      */   {
/*  696 */     ConByMethodJoinPointGenerator generator = getJoinPointGenerator(info);
/*  697 */     finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
/*      */   }
/*      */ 
/*      */   protected void finalizeConCalledByConInterceptorChain(ConByConInfo info)
/*      */   {
/*  703 */     ConByConJoinPointGenerator generator = getJoinPointGenerator(info);
/*  704 */     finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
/*      */   }
/*      */ 
/*      */   protected void finalizeMethodCalledByConInterceptorChain(MethodByConInfo info)
/*      */   {
/*  712 */     ConcurrentHashMap map = (ConcurrentHashMap)this.joinPointGenerators.get(info.getJoinpoint());
/*  713 */     if (map == null)
/*      */     {
/*  715 */       map = new ConcurrentHashMap();
/*  716 */       initJoinPointGeneratorsMap();
/*  717 */       this.joinPointGenerators.put(info.getJoinpoint(), map);
/*  718 */       map = (ConcurrentHashMap)this.joinPointGenerators.get(info.getJoinpoint());
/*      */     }
/*      */ 
/*  721 */     MethodByConJoinPointGenerator generator = getJoinPointGenerator(info);
/*  722 */     finalizeChainAndRebindJoinPoint(this.oldInfos, info, generator, OldInfoMaps.INFOS);
/*      */   }
/*      */ 
/*      */   private JoinPointGenerator getJoinPointGenerator(JoinPointInfo info)
/*      */   {
/*  727 */     if ((info instanceof MethodInfo))
/*      */     {
/*  729 */       return getJoinPointGenerator((MethodInfo)info);
/*      */     }
/*  731 */     if ((info instanceof FieldInfo))
/*      */     {
/*  733 */       return getJoinPointGenerator((FieldInfo)info);
/*      */     }
/*  735 */     if ((info instanceof ConstructionInfo))
/*      */     {
/*  737 */       return getJoinPointGenerator((ConstructionInfo)info);
/*      */     }
/*  739 */     if ((info instanceof ConstructorInfo))
/*      */     {
/*  741 */       return getJoinPointGenerator((ConstructorInfo)info);
/*      */     }
/*  743 */     if ((info instanceof ConByConInfo))
/*      */     {
/*  745 */       return getJoinPointGenerator((ConByConInfo)info);
/*      */     }
/*  747 */     if ((info instanceof ConByMethodInfo))
/*      */     {
/*  749 */       return getJoinPointGenerator((ConByMethodInfo)info);
/*      */     }
/*  751 */     if ((info instanceof MethodByMethodInfo))
/*      */     {
/*  753 */       return getJoinPointGenerator((MethodByMethodInfo)info);
/*      */     }
/*  755 */     if ((info instanceof MethodByConInfo))
/*      */     {
/*  757 */       return getJoinPointGenerator((MethodByConInfo)info);
/*      */     }
/*      */ 
/*  761 */     throw new RuntimeException("Invalid JoinPointInfo passed in: " + info.getClass().getName());
/*      */   }
/*      */ 
/*      */   protected MethodJoinPointGenerator getJoinPointGenerator(MethodInfo info)
/*      */   {
/*  767 */     return this.advisorStrategy.getJoinPointGenerator(info);
/*      */   }
/*      */ 
/*      */   protected FieldJoinPointGenerator getJoinPointGenerator(FieldInfo info)
/*      */   {
/*  772 */     return this.advisorStrategy.getJoinPointGenerator(info);
/*      */   }
/*      */ 
/*      */   protected ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo info)
/*      */   {
/*  777 */     return this.advisorStrategy.getJoinPointGenerator(info);
/*      */   }
/*      */ 
/*      */   protected ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo info)
/*      */   {
/*  782 */     return this.advisorStrategy.getJoinPointGenerator(info);
/*      */   }
/*      */ 
/*      */   protected MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo info)
/*      */   {
/*  787 */     return this.advisorStrategy.getJoinPointGenerator(info);
/*      */   }
/*      */ 
/*      */   protected ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo info)
/*      */   {
/*  792 */     return this.advisorStrategy.getJoinPointGenerator(info);
/*      */   }
/*      */ 
/*      */   protected ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo info)
/*      */   {
/*  797 */     return this.advisorStrategy.getJoinPointGenerator(info);
/*      */   }
/*      */ 
/*      */   protected MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo info)
/*      */   {
/*  802 */     return this.advisorStrategy.getJoinPointGenerator(info);
/*      */   }
/*      */ 
/*      */   protected void pointcutResolved(JoinPointInfo info, AdviceBinding binding, Joinpoint joinpoint)
/*      */   {
/*  812 */     ArrayList curr = info.getInterceptorChain();
/*  813 */     if (binding.getCFlow() != null)
/*      */     {
/*  816 */       InterceptorFactory[] factories = binding.getInterceptorFactories();
/*  817 */       for (int i = 0; i < factories.length; i++)
/*      */       {
/*  819 */         curr.add(new GeneratedAdvisorInterceptor(factories[i], this, joinpoint, binding.getCFlowString(), binding.getCFlow()));
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  824 */       InterceptorFactory[] factories = binding.getInterceptorFactories();
/*  825 */       for (int i = 0; i < factories.length; i++)
/*      */       {
/*  827 */         curr.add(new GeneratedAdvisorInterceptor(factories[i], this, joinpoint));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void finalizeChainAndRebindJoinPoint(Map oldInfos, JoinPointInfo info, JoinPointGenerator generator, OldInfoMaps oldInfoMapInstance)
/*      */   {
/*  834 */     ArrayList list = info.getInterceptorChain();
/*  835 */     GeneratedAdvisorInterceptor[] factories = null;
/*  836 */     if (list.size() > 0)
/*      */     {
/*  838 */       factories = applyPrecedence((GeneratedAdvisorInterceptor[])(GeneratedAdvisorInterceptor[])list.toArray(new GeneratedAdvisorInterceptor[list.size()]));
/*      */     }
/*  840 */     info.setInterceptors(factories);
/*      */ 
/*  842 */     if (updateOldInfo(oldInfos, info, oldInfoMapInstance))
/*      */     {
/*  844 */       generator.rebindJoinpoint(info);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  851 */     Class clazz = getClass();
/*  852 */     StringBuffer sb = new StringBuffer("CLASS: " + clazz.getName());
/*      */ 
/*  854 */     Field[] fields = clazz.getFields();
/*  855 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  857 */       sb.append("\n\t" + fields[i]);
/*      */     }
/*  859 */     return sb.toString();
/*      */   }
/*      */ 
/*      */   GeneratedAdvisorInterceptor[] applyPrecedence(GeneratedAdvisorInterceptor[] interceptors)
/*      */   {
/*  864 */     return PrecedenceSorter.applyPrecedence(interceptors, this.manager);
/*      */   }
/*      */ 
/*      */   public Object getPerClassAspect(AspectDefinition def)
/*      */   {
/*  874 */     return this.advisorStrategy.getPerClassAspect(def);
/*      */   }
/*      */ 
/*      */   public Object getPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint)
/*      */   {
/*  886 */     return this.advisorStrategy.getPerClassJoinpointAspect(def, joinpoint);
/*      */   }
/*      */ 
/*      */   public synchronized void addPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint)
/*      */   {
/*  891 */     Map joinpoints = (Map)this.perClassJoinpointAspectDefinitions.get(def);
/*  892 */     if (joinpoints == null)
/*      */     {
/*  894 */       joinpoints = new ConcurrentHashMap();
/*  895 */       this.perClassJoinpointAspectDefinitions.put(def, joinpoints);
/*      */     }
/*      */ 
/*  898 */     if (joinpoints.get(joinpoint) == null)
/*      */     {
/*  900 */       joinpoints.put(joinpoint, def.getFactory().createPerJoinpoint(this, joinpoint));
/*      */     }
/*  902 */     def.registerAdvisor(this);
/*      */   }
/*      */ 
/*      */   public synchronized void removePerClassJoinpointAspect(AspectDefinition def)
/*      */   {
/*  907 */     this.perClassJoinpointAspectDefinitions.remove(def);
/*      */   }
/*      */ 
/*      */   public boolean chainOverridingForInheritedMethods()
/*      */   {
/*  916 */     return true;
/*      */   }
/*      */ 
/*      */   public Object getFieldAspect(FieldJoinpoint joinpoint, AspectDefinition def)
/*      */   {
/*  922 */     Object instance = getPerClassJoinpointAspect(def, joinpoint);
/*  923 */     if (instance == null)
/*      */     {
/*  925 */       addPerClassJoinpointAspect(def, joinpoint);
/*  926 */       instance = getPerClassJoinpointAspect(def, joinpoint);
/*      */     }
/*  928 */     return instance;
/*      */   }
/*      */ 
/*      */   private GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices()
/*      */   {
/*  933 */     return this.advisorStrategy.getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
/*      */   }
/*      */ 
/*      */   protected void createMethodTables()
/*      */     throws Exception
/*      */   {
/*  943 */     this.advisorStrategy.createMethodTables();
/*      */   }
/*      */ 
/*      */   protected void createFieldTable()
/*      */     throws Exception
/*      */   {
/*  953 */     this.advisorStrategy.createFieldTable();
/*      */   }
/*      */ 
/*      */   protected void createConstructorTables()
/*      */     throws Exception
/*      */   {
/*  963 */     this.advisorStrategy.createConstructorTables();
/*      */   }
/*      */ 
/*      */   public Set getPerInstanceAspectDefinitions()
/*      */   {
/*  969 */     return this.advisorStrategy.getPerInstanceAspectDefinitions();
/*      */   }
/*      */ 
/*      */   public Map getPerInstanceJoinpointAspectDefinitions()
/*      */   {
/*  975 */     return this.advisorStrategy.getPerInstanceJoinpointAspectDefinitions();
/*      */   }
/*      */ 
/*      */   private boolean updateOldInfo(Map oldInfos, JoinPointInfo newInfo, OldInfoMaps oldInfoMapInstance)
/*      */   {
/*  983 */     JoinPointInfo oldInfo = (JoinPointInfo)oldInfos.get(newInfo.getJoinpoint());
/*  984 */     if (oldInfo != null)
/*      */     {
/*  987 */       if (oldInfo.equalChains(newInfo))
/*      */       {
/*  989 */         return false;
/*      */       }
/*      */     }
/*  992 */     oldInfo = newInfo.copy();
/*      */ 
/*  994 */     if (oldInfoMapInstance == OldInfoMaps.INFOS)
/*      */     {
/*  996 */       oldInfos = initOldInfosMap();
/*      */     }
/*  998 */     else if (oldInfoMapInstance == OldInfoMaps.FIELD_READ_INFOS)
/*      */     {
/* 1000 */       oldInfos = initOldFieldReadInfosMap();
/*      */     }
/* 1002 */     else if (oldInfoMapInstance == OldInfoMaps.CONSTRUCTION_INFOS)
/*      */     {
/* 1004 */       oldInfos = initOldConstructionInfosMap();
/*      */     }
/*      */     else
/*      */     {
/* 1008 */       throw new RuntimeException("Unrecognised map");
/*      */     }
/*      */ 
/* 1011 */     oldInfos.put(newInfo.getJoinpoint(), oldInfo);
/* 1012 */     return true;
/*      */   }
/*      */ 
/*      */   protected void generateJoinPointClass(MethodInfo info)
/*      */   {
/* 1017 */     MethodJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1018 */     generator.generateJoinPointClass(getClass().getClassLoader(), info);
/*      */   }
/*      */ 
/*      */   protected void generateJoinPointClass(FieldInfo info)
/*      */   {
/* 1023 */     FieldJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1024 */     generator.generateJoinPointClass(getClass().getClassLoader(), info);
/*      */   }
/*      */ 
/*      */   protected void generateJoinPointClass(ConstructorInfo info)
/*      */   {
/* 1029 */     ConstructorJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1030 */     generator.generateJoinPointClass(getClass().getClassLoader(), info);
/*      */   }
/*      */ 
/*      */   protected void generateJoinPointClass(ConstructionInfo info)
/*      */   {
/* 1035 */     ConstructionJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1036 */     generator.generateJoinPointClass(getClass().getClassLoader(), info);
/*      */   }
/*      */ 
/*      */   protected void generateJoinPointClass(MethodByMethodInfo info)
/*      */   {
/* 1041 */     MethodByMethodJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1042 */     generator.generateJoinPointClass(getClass().getClassLoader(), info);
/*      */   }
/*      */ 
/*      */   protected void generateJoinPointClass(ConByMethodInfo info)
/*      */   {
/* 1047 */     ConByMethodJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1048 */     generator.generateJoinPointClass(getClass().getClassLoader(), info);
/*      */   }
/*      */ 
/*      */   protected void generateJoinPointClass(ConByConInfo info)
/*      */   {
/* 1053 */     ConByConJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1054 */     generator.generateJoinPointClass(getClass().getClassLoader(), info);
/*      */   }
/*      */ 
/*      */   protected void generateJoinPointClass(MethodByConInfo info)
/*      */   {
/* 1059 */     MethodByConJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1060 */     generator.generateJoinPointClass(getClass().getClassLoader(), info);
/*      */   }
/*      */ 
/*      */   protected Object rebindJoinPointWithInstanceInformation(JoinPointInfo info)
/*      */   {
/* 1065 */     JoinPointGenerator generator = getJoinPointGenerator(info);
/* 1066 */     generator.rebindJoinpoint(info);
/* 1067 */     return generator.generateJoinPointClass(getClass().getClassLoader(), info);
/*      */   }
/*      */ 
/*      */   public Object createAndRebindJoinPointForInstance(JoinPointInfo info)
/*      */   {
/* 1075 */     JoinPointInfo newinfo = info.copy();
/* 1076 */     newinfo.setAdvisor(this);
/* 1077 */     return rebindJoinPointWithInstanceInformation(newinfo);
/*      */   }
/*      */ 
/*      */   protected void initJoinPointGeneratorsMap()
/*      */   {
/* 1083 */     if (this.joinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 1085 */       lockWrite();
/*      */       try
/*      */       {
/* 1088 */         if (this.joinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 1090 */           this.joinPointGenerators = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1095 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initFieldReadJoinPointGeneratorsMap()
/*      */   {
/* 1102 */     if (this.fieldReadJoinPoinGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 1104 */       lockWrite();
/*      */       try
/*      */       {
/* 1107 */         if (this.fieldReadJoinPoinGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 1109 */           this.fieldReadJoinPoinGenerators = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1114 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initConstructionJoinPointGeneratorsMap()
/*      */   {
/* 1121 */     if (this.constructionJoinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 1123 */       lockWrite();
/*      */       try
/*      */       {
/* 1126 */         if (this.constructionJoinPointGenerators == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 1128 */           this.constructionJoinPointGenerators = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1133 */         unlockWrite();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected ConcurrentHashMap initOldInfosMap()
/*      */   {
/* 1140 */     if (this.oldInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 1142 */       lockWrite();
/*      */       try
/*      */       {
/* 1145 */         if (this.oldInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 1147 */           this.oldInfos = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1152 */         unlockWrite();
/*      */       }
/*      */     }
/* 1155 */     return this.oldInfos;
/*      */   }
/*      */ 
/*      */   protected ConcurrentHashMap initOldFieldReadInfosMap()
/*      */   {
/* 1160 */     if (this.oldFieldReadInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 1162 */       lockWrite();
/*      */       try
/*      */       {
/* 1165 */         if (this.oldFieldReadInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 1167 */           this.oldFieldReadInfos = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1172 */         unlockWrite();
/*      */       }
/*      */     }
/* 1175 */     return this.oldFieldReadInfos;
/*      */   }
/*      */ 
/*      */   protected ConcurrentHashMap initOldConstructionInfosMap()
/*      */   {
/* 1180 */     if (this.oldConstructionInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */     {
/* 1182 */       lockWrite();
/*      */       try
/*      */       {
/* 1185 */         if (this.oldConstructionInfos == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*      */         {
/* 1187 */           this.oldConstructionInfos = new ConcurrentHashMap();
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/* 1192 */         unlockWrite();
/*      */       }
/*      */     }
/* 1195 */     return this.oldConstructionInfos;
/*      */   }
/*      */ 
/*      */   static enum OldInfoMaps
/*      */   {
/* 1740 */     INFOS, FIELD_READ_INFOS, CONSTRUCTION_INFOS;
/*      */   }
/*      */ 
/*      */   private class InstanceAdvisorStrategy
/*      */     implements GeneratedClassAdvisor.AdvisorStrategy
/*      */   {
/*      */     GeneratedClassAdvisor parent;
/* 1544 */     boolean needsRebuild = true;
/*      */ 
/*      */     public InstanceAdvisorStrategy(GeneratedClassAdvisor parent)
/*      */     {
/* 1548 */       this.parent = parent;
/* 1549 */       GeneratedClassAdvisor.access$1202(GeneratedClassAdvisor.this, parent.version);
/*      */     }
/*      */ 
/*      */     public void initialise(Class clazz, AspectManager manager)
/*      */     {
/* 1554 */       GeneratedClassAdvisor.this.initialiseInfosForInstance();
/*      */ 
/* 1556 */       GeneratedClassAdvisor.this.setManager(manager);
/*      */ 
/* 1558 */       manager.initialiseClassAdvisor(clazz, GeneratedClassAdvisor.this);
/*      */     }
/*      */ 
/*      */     public void checkVersion()
/*      */     {
/* 1563 */       if ((this.needsRebuild) || (this.parent.version != GeneratedClassAdvisor.this.version))
/*      */       {
/* 1565 */         GeneratedClassAdvisor.this.doRebuildForInstance();
/* 1566 */         this.needsRebuild = false;
/*      */       }
/*      */     }
/*      */ 
/*      */     public void createInterceptorChains() throws Exception
/*      */     {
/* 1572 */       if (GeneratedClassAdvisor.access$1801(GeneratedClassAdvisor.this))
/*      */       {
/* 1574 */         GeneratedClassAdvisor.this.createInterceptorChains();
/*      */       }
/*      */       else
/*      */       {
/* 1579 */         GeneratedClassAdvisor.access$2003(GeneratedClassAdvisor.this, true);
/*      */       }
/*      */     }
/*      */ 
/*      */     public MethodJoinPointGenerator getJoinPointGenerator(MethodInfo info)
/*      */     {
/* 1586 */       return this.parent.getJoinPointGenerator(info);
/*      */     }
/*      */ 
/*      */     public FieldJoinPointGenerator getJoinPointGenerator(FieldInfo info)
/*      */     {
/* 1592 */       return this.parent.getJoinPointGenerator(info);
/*      */     }
/*      */ 
/*      */     public ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo info)
/*      */     {
/* 1598 */       return this.parent.getJoinPointGenerator(info);
/*      */     }
/*      */ 
/*      */     public ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo info)
/*      */     {
/* 1604 */       return this.parent.getJoinPointGenerator(info);
/*      */     }
/*      */ 
/*      */     public MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo info)
/*      */     {
/* 1610 */       return this.parent.getJoinPointGenerator(info);
/*      */     }
/*      */ 
/*      */     public ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo info)
/*      */     {
/* 1616 */       return this.parent.getJoinPointGenerator(info);
/*      */     }
/*      */ 
/*      */     public ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo info)
/*      */     {
/* 1622 */       return this.parent.getJoinPointGenerator(info);
/*      */     }
/*      */ 
/*      */     public MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo info)
/*      */     {
/* 1628 */       return this.parent.getJoinPointGenerator(info);
/*      */     }
/*      */ 
/*      */     public Object getPerClassAspect(AspectDefinition def)
/*      */     {
/* 1637 */       Object aspect = this.parent.getPerClassAspect(def);
/* 1638 */       if (aspect != null) return aspect;
/* 1639 */       return GeneratedClassAdvisor.this.getPerClassAspect(def);
/*      */     }
/*      */ 
/*      */     public Object getPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint)
/*      */     {
/* 1648 */       Object aspect = this.parent.getPerClassJoinpointAspect(def, joinpoint);
/* 1649 */       if (aspect != null) return aspect;
/* 1650 */       return this.parent.getPerClassJoinpointAspect(def, joinpoint);
/*      */     }
/*      */ 
/*      */     public GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices()
/*      */     {
/* 1655 */       if (((Domain)GeneratedClassAdvisor.this.getManager()).hasOwnDataWithEffectOnAdvices())
/*      */       {
/* 1657 */         return null;
/*      */       }
/* 1659 */       return this.parent;
/*      */     }
/*      */ 
/*      */     public void createMethodTables() throws Exception
/*      */     {
/* 1664 */       GeneratedClassAdvisor.this.unadvisedMethods = this.parent.unadvisedMethods;
/* 1665 */       GeneratedClassAdvisor.this.advisedMethods = this.parent.advisedMethods;
/*      */     }
/*      */ 
/*      */     public void createFieldTable() throws Exception
/*      */     {
/* 1670 */       GeneratedClassAdvisor.this.advisedFields = this.parent.advisedFields;
/*      */     }
/*      */ 
/*      */     public void createConstructorTables() throws Exception
/*      */     {
/* 1675 */       GeneratedClassAdvisor.this.constructors = this.parent.constructors;
/*      */ 
/* 1677 */       GeneratedClassAdvisor.this.methodCalledByConBindings = new HashMap[GeneratedClassAdvisor.this.constructors.length];
/* 1678 */       GeneratedClassAdvisor.this.methodCalledByConInterceptors = new HashMap[GeneratedClassAdvisor.this.constructors.length];
/*      */ 
/* 1680 */       GeneratedClassAdvisor.this.conCalledByConBindings = new HashMap[GeneratedClassAdvisor.this.constructors.length];
/* 1681 */       GeneratedClassAdvisor.this.conCalledByConInterceptors = new HashMap[GeneratedClassAdvisor.this.constructors.length];
/*      */     }
/*      */ 
/*      */     public Set getPerInstanceAspectDefinitions()
/*      */     {
/* 1686 */       return this.parent.getPerInstanceAspectDefinitions();
/*      */     }
/*      */ 
/*      */     public Map getPerInstanceJoinpointAspectDefinitions()
/*      */     {
/* 1691 */       return this.parent.getPerInstanceJoinpointAspectDefinitions();
/*      */     }
/*      */ 
/*      */     public synchronized void rebuildInterceptors()
/*      */     {
/* 1697 */       if ((getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices() != null) && (GeneratedClassAdvisor.this.version != this.parent.version))
/*      */       {
/* 1699 */         GeneratedClassAdvisor.this.adviceBindings.clear();
/* 1700 */         this.needsRebuild = true;
/*      */       }
/*      */       else
/*      */       {
/* 1704 */         GeneratedClassAdvisor.this.rebuildInterceptors();
/*      */       }
/*      */     }
/*      */ 
/*      */     public void resolveConstructorPointcut(ArrayList newConstructorInfos, AdviceBinding binding)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void resolveConstructionPointcut(ArrayList newConstructionInfos, AdviceBinding binding)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void finalizeConstructorChain(ArrayList newConstructorInfos)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void finalizeConstructionChain(ArrayList newConstructionInfos)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void makeAccessibleField(FieldInfo fi)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void makeAccessibleMethod(MethodInfo mi)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   private class ClassAdvisorStrategy
/*      */     implements GeneratedClassAdvisor.AdvisorStrategy
/*      */   {
/*      */     GeneratedClassAdvisor parent;
/*      */ 
/*      */     private ClassAdvisorStrategy()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void initialise(Class clazz, AspectManager manager)
/*      */     {
/* 1237 */       GeneratedClassAdvisor.this.initialiseMethods();
/* 1238 */       GeneratedClassAdvisor.this.initialiseConstructors();
/* 1239 */       GeneratedClassAdvisor.this.initialiseConstructions();
/* 1240 */       GeneratedClassAdvisor.this.initialiseFieldReads();
/* 1241 */       GeneratedClassAdvisor.this.initialiseFieldWrites();
/*      */ 
/* 1243 */       GeneratedClassAdvisor.this.setManager(manager);
/*      */ 
/* 1248 */       Advisor existing = AspectManager.instance().getAnyAdvisorIfAdvised(clazz);
/* 1249 */       if (existing != null)
/*      */       {
/* 1251 */         GeneratedClassAdvisor.this.aspects = existing.aspects;
/* 1252 */         if ((existing instanceof GeneratedClassAdvisor))
/*      */         {
/* 1254 */           GeneratedClassAdvisor.this.perClassJoinpointAspectDefinitions = ((GeneratedClassAdvisor)existing).perClassJoinpointAspectDefinitions;
/*      */         }
/*      */       }
/*      */ 
/* 1258 */       manager.initialiseClassAdvisor(clazz, GeneratedClassAdvisor.this);
/*      */ 
/* 1260 */       GeneratedClassAdvisor.this.initialiseCallers();
/*      */     }
/*      */ 
/*      */     public void checkVersion()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void createInterceptorChains()
/*      */       throws Exception
/*      */     {
/* 1270 */       GeneratedClassAdvisor.this.createInterceptorChains();
/*      */     }
/*      */ 
/*      */     public MethodJoinPointGenerator getJoinPointGenerator(MethodInfo info)
/*      */     {
/* 1275 */       MethodJoinPointGenerator generator = (MethodJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
/* 1276 */       if (generator == null)
/*      */       {
/* 1278 */         generator = new MethodJoinPointGenerator(GeneratedClassAdvisor.this, info);
/* 1279 */         GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
/* 1280 */         MethodJoinPointGenerator existing = (MethodJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
/* 1281 */         if (existing != null)
/*      */         {
/* 1283 */           generator = existing;
/*      */         }
/*      */       }
/* 1286 */       return generator;
/*      */     }
/*      */ 
/*      */     public FieldJoinPointGenerator getJoinPointGenerator(FieldInfo info)
/*      */     {
/* 1291 */       if (info.isRead())
/*      */       {
/* 1293 */         FieldJoinPointGenerator generator = (FieldJoinPointGenerator)GeneratedClassAdvisor.this.fieldReadJoinPoinGenerators.get(info.getJoinpoint());
/* 1294 */         if (generator == null)
/*      */         {
/* 1296 */           generator = new FieldJoinPointGenerator(GeneratedClassAdvisor.this, info);
/* 1297 */           GeneratedClassAdvisor.this.initFieldReadJoinPointGeneratorsMap();
/* 1298 */           FieldJoinPointGenerator existing = (FieldJoinPointGenerator)GeneratedClassAdvisor.this.fieldReadJoinPoinGenerators.putIfAbsent(info.getJoinpoint(), generator);
/* 1299 */           if (existing != null)
/*      */           {
/* 1301 */             generator = existing;
/*      */           }
/*      */         }
/* 1304 */         return generator;
/*      */       }
/*      */ 
/* 1308 */       FieldJoinPointGenerator generator = (FieldJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
/* 1309 */       if (generator == null)
/*      */       {
/* 1311 */         generator = new FieldJoinPointGenerator(GeneratedClassAdvisor.this, info);
/* 1312 */         GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
/* 1313 */         FieldJoinPointGenerator existing = (FieldJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
/* 1314 */         if (existing != null)
/*      */         {
/* 1316 */           generator = existing;
/*      */         }
/*      */       }
/* 1319 */       return generator;
/*      */     }
/*      */ 
/*      */     public ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo info)
/*      */     {
/* 1326 */       ConstructorJoinPointGenerator generator = (ConstructorJoinPointGenerator)GeneratedClassAdvisor.this.constructionJoinPointGenerators.get(info.getJoinpoint());
/* 1327 */       if (generator == null)
/*      */       {
/* 1329 */         generator = new ConstructorJoinPointGenerator(GeneratedClassAdvisor.this, info);
/* 1330 */         GeneratedClassAdvisor.this.initConstructionJoinPointGeneratorsMap();
/* 1331 */         ConstructorJoinPointGenerator existing = (ConstructorJoinPointGenerator)GeneratedClassAdvisor.this.constructionJoinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
/* 1332 */         if (existing != null)
/*      */         {
/* 1334 */           generator = existing;
/*      */         }
/*      */       }
/* 1337 */       return generator;
/*      */     }
/*      */ 
/*      */     public ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo info)
/*      */     {
/* 1342 */       ConstructionJoinPointGenerator generator = (ConstructionJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
/* 1343 */       if (generator == null)
/*      */       {
/* 1345 */         generator = new ConstructionJoinPointGenerator(GeneratedClassAdvisor.this, info);
/* 1346 */         GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
/* 1347 */         ConstructionJoinPointGenerator existing = (ConstructionJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
/* 1348 */         if (existing != null)
/*      */         {
/* 1350 */           generator = existing;
/*      */         }
/*      */       }
/* 1353 */       return generator;
/*      */     }
/*      */ 
/*      */     public MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo info)
/*      */     {
/* 1360 */       ConcurrentHashMap map = (ConcurrentHashMap)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
/* 1361 */       if (map == null)
/*      */       {
/* 1363 */         map = new ConcurrentHashMap();
/* 1364 */         GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
/* 1365 */         ConcurrentHashMap existing = (ConcurrentHashMap)GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), map);
/* 1366 */         if (existing != null)
/*      */         {
/* 1368 */           map = existing;
/*      */         }
/*      */       }
/*      */ 
/* 1372 */       MethodByMethodJoinPointGenerator generator = (MethodByMethodJoinPointGenerator)map.get(info.getCalledClass());
/* 1373 */       if (generator == null)
/*      */       {
/* 1375 */         generator = new MethodByMethodJoinPointGenerator(GeneratedClassAdvisor.this, info);
/* 1376 */         MethodByMethodJoinPointGenerator existing = (MethodByMethodJoinPointGenerator)map.putIfAbsent(info.getCalledClass(), generator);
/* 1377 */         if (existing != null)
/*      */         {
/* 1379 */           generator = existing;
/*      */         }
/*      */       }
/* 1382 */       return generator;
/*      */     }
/*      */ 
/*      */     public ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo info)
/*      */     {
/* 1387 */       ConByMethodJoinPointGenerator generator = (ConByMethodJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
/* 1388 */       if (generator == null)
/*      */       {
/* 1390 */         generator = new ConByMethodJoinPointGenerator(GeneratedClassAdvisor.this, info);
/* 1391 */         GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
/* 1392 */         ConByMethodJoinPointGenerator existing = (ConByMethodJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
/* 1393 */         if (existing != null)
/*      */         {
/* 1395 */           generator = existing;
/*      */         }
/*      */       }
/* 1398 */       return generator;
/*      */     }
/*      */ 
/*      */     public ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo info)
/*      */     {
/* 1404 */       ConByConJoinPointGenerator generator = (ConByConJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
/* 1405 */       if (generator == null)
/*      */       {
/* 1407 */         generator = new ConByConJoinPointGenerator(GeneratedClassAdvisor.this, info);
/* 1408 */         GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
/* 1409 */         ConByConJoinPointGenerator existing = (ConByConJoinPointGenerator)GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), generator);
/* 1410 */         if (existing != null)
/*      */         {
/* 1412 */           generator = existing;
/*      */         }
/*      */       }
/* 1415 */       return generator;
/*      */     }
/*      */ 
/*      */     public MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo info)
/*      */     {
/* 1422 */       ConcurrentHashMap map = (ConcurrentHashMap)GeneratedClassAdvisor.this.joinPointGenerators.get(info.getJoinpoint());
/* 1423 */       if (map == null)
/*      */       {
/* 1425 */         map = new ConcurrentHashMap();
/* 1426 */         GeneratedClassAdvisor.this.initJoinPointGeneratorsMap();
/* 1427 */         ConcurrentHashMap exisiting = (ConcurrentHashMap)GeneratedClassAdvisor.this.joinPointGenerators.putIfAbsent(info.getJoinpoint(), map);
/* 1428 */         if (exisiting != null)
/*      */         {
/* 1430 */           map = exisiting;
/*      */         }
/*      */       }
/*      */ 
/* 1434 */       MethodByConJoinPointGenerator generator = (MethodByConJoinPointGenerator)map.get(info.getCalledClass());
/* 1435 */       if (generator == null)
/*      */       {
/* 1437 */         generator = new MethodByConJoinPointGenerator(GeneratedClassAdvisor.this, info);
/* 1438 */         MethodByConJoinPointGenerator existing = (MethodByConJoinPointGenerator)map.putIfAbsent(info.getCalledClass(), generator);
/* 1439 */         if (existing != null)
/*      */         {
/* 1441 */           generator = existing;
/*      */         }
/*      */       }
/* 1444 */       return generator;
/*      */     }
/*      */ 
/*      */     public Object getPerClassAspect(AspectDefinition def)
/*      */     {
/* 1449 */       return GeneratedClassAdvisor.this.getPerClassAspect(def);
/*      */     }
/*      */ 
/*      */     public Object getPerClassJoinpointAspect(AspectDefinition def, Joinpoint joinpoint)
/*      */     {
/* 1454 */       Map joinpoints = (Map)GeneratedClassAdvisor.this.perClassJoinpointAspectDefinitions.get(def);
/* 1455 */       if (joinpoints != null)
/*      */       {
/* 1457 */         return joinpoints.get(joinpoint);
/*      */       }
/* 1459 */       return null;
/*      */     }
/*      */ 
/*      */     public GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices()
/*      */     {
/* 1464 */       return null;
/*      */     }
/*      */ 
/*      */     public void createMethodTables() throws Exception
/*      */     {
/* 1469 */       GeneratedClassAdvisor.this.createMethodTables();
/*      */     }
/*      */ 
/*      */     public void createFieldTable() throws Exception
/*      */     {
/* 1474 */       GeneratedClassAdvisor.this.createFieldTable();
/*      */     }
/*      */ 
/*      */     public void createConstructorTables() throws Exception
/*      */     {
/* 1479 */       GeneratedClassAdvisor.this.createConstructorTables();
/*      */     }
/*      */ 
/*      */     public Set getPerInstanceAspectDefinitions()
/*      */     {
/* 1484 */       return GeneratedClassAdvisor.this.getPerInstanceAspectDefinitions();
/*      */     }
/*      */ 
/*      */     public Map getPerInstanceJoinpointAspectDefinitions()
/*      */     {
/* 1489 */       return GeneratedClassAdvisor.this.getPerInstanceJoinpointAspectDefinitions();
/*      */     }
/*      */ 
/*      */     public void rebuildInterceptors()
/*      */     {
/* 1494 */       GeneratedClassAdvisor.access$1208(GeneratedClassAdvisor.this);
/* 1495 */       GeneratedClassAdvisor.this.rebuildInterceptors();
/*      */     }
/*      */ 
/*      */     public void resolveConstructorPointcut(ArrayList newConstructorInfos, AdviceBinding binding)
/*      */     {
/* 1500 */       GeneratedClassAdvisor.this.resolveConstructorPointcut(newConstructorInfos, binding);
/*      */     }
/*      */ 
/*      */     public void resolveConstructionPointcut(ArrayList newConstructionInfos, AdviceBinding binding)
/*      */     {
/* 1505 */       GeneratedClassAdvisor.this.resolveConstructionPointcut(newConstructionInfos, binding);
/*      */     }
/*      */ 
/*      */     public void finalizeConstructorChain(ArrayList newConstructorInfos)
/*      */     {
/* 1510 */       for (int i = 0; i < newConstructorInfos.size(); i++)
/*      */       {
/* 1512 */         ConstructorInfo info = (ConstructorInfo)newConstructorInfos.get(i);
/* 1513 */         ConstructorJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1514 */         GeneratedClassAdvisor.this.finalizeChainAndRebindJoinPoint(GeneratedClassAdvisor.this.oldInfos, info, generator, GeneratedClassAdvisor.OldInfoMaps.INFOS);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void finalizeConstructionChain(ArrayList newConstructionInfos)
/*      */     {
/* 1520 */       for (int i = 0; i < newConstructionInfos.size(); i++)
/*      */       {
/* 1522 */         ConstructionInfo info = (ConstructionInfo)newConstructionInfos.get(i);
/* 1523 */         ConstructionJoinPointGenerator generator = getJoinPointGenerator(info);
/* 1524 */         GeneratedClassAdvisor.this.finalizeChainAndRebindJoinPoint(GeneratedClassAdvisor.this.oldConstructionInfos, info, generator, GeneratedClassAdvisor.OldInfoMaps.CONSTRUCTION_INFOS);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void makeAccessibleField(FieldInfo fi)
/*      */     {
/* 1531 */       SecurityActions.setAccessible(fi.getField());
/*      */     }
/*      */ 
/*      */     public void makeAccessibleMethod(MethodInfo mi)
/*      */     {
/* 1537 */       SecurityActions.setAccessible(mi.getMethod());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static abstract interface AdvisorStrategy
/*      */   {
/*      */     public abstract void initialise(Class paramClass, AspectManager paramAspectManager);
/*      */ 
/*      */     public abstract void checkVersion();
/*      */ 
/*      */     public abstract void createInterceptorChains()
/*      */       throws Exception;
/*      */ 
/*      */     public abstract MethodJoinPointGenerator getJoinPointGenerator(MethodInfo paramMethodInfo);
/*      */ 
/*      */     public abstract FieldJoinPointGenerator getJoinPointGenerator(FieldInfo paramFieldInfo);
/*      */ 
/*      */     public abstract ConstructorJoinPointGenerator getJoinPointGenerator(ConstructorInfo paramConstructorInfo);
/*      */ 
/*      */     public abstract ConstructionJoinPointGenerator getJoinPointGenerator(ConstructionInfo paramConstructionInfo);
/*      */ 
/*      */     public abstract MethodByMethodJoinPointGenerator getJoinPointGenerator(MethodByMethodInfo paramMethodByMethodInfo);
/*      */ 
/*      */     public abstract ConByMethodJoinPointGenerator getJoinPointGenerator(ConByMethodInfo paramConByMethodInfo);
/*      */ 
/*      */     public abstract ConByConJoinPointGenerator getJoinPointGenerator(ConByConInfo paramConByConInfo);
/*      */ 
/*      */     public abstract MethodByConJoinPointGenerator getJoinPointGenerator(MethodByConInfo paramMethodByConInfo);
/*      */ 
/*      */     public abstract Object getPerClassAspect(AspectDefinition paramAspectDefinition);
/*      */ 
/*      */     public abstract Object getPerClassJoinpointAspect(AspectDefinition paramAspectDefinition, Joinpoint paramJoinpoint);
/*      */ 
/*      */     public abstract GeneratedClassAdvisor getClassAdvisorIfInstanceAdvisorWithNoOwnDataWithEffectOnAdvices();
/*      */ 
/*      */     public abstract void createMethodTables()
/*      */       throws Exception;
/*      */ 
/*      */     public abstract void createFieldTable()
/*      */       throws Exception;
/*      */ 
/*      */     public abstract void createConstructorTables()
/*      */       throws Exception;
/*      */ 
/*      */     public abstract Set getPerInstanceAspectDefinitions();
/*      */ 
/*      */     public abstract Map getPerInstanceJoinpointAspectDefinitions();
/*      */ 
/*      */     public abstract void rebuildInterceptors();
/*      */ 
/*      */     public abstract void resolveConstructorPointcut(ArrayList paramArrayList, AdviceBinding paramAdviceBinding);
/*      */ 
/*      */     public abstract void resolveConstructionPointcut(ArrayList paramArrayList, AdviceBinding paramAdviceBinding);
/*      */ 
/*      */     public abstract void finalizeConstructorChain(ArrayList paramArrayList);
/*      */ 
/*      */     public abstract void finalizeConstructionChain(ArrayList paramArrayList);
/*      */ 
/*      */     public abstract void makeAccessibleField(FieldInfo paramFieldInfo);
/*      */ 
/*      */     public abstract void makeAccessibleMethod(MethodInfo paramMethodInfo);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.GeneratedClassAdvisor
 * JD-Core Version:    0.6.0
 */