/*    */ package org.jboss.aop;
/*    */ 
/*    */ import java.util.concurrent.ConcurrentHashMap;
/*    */ 
/*    */ public class InterceptionMarkers
/*    */ {
/* 33 */   protected final ConcurrentHashMap convertableReference = new ConcurrentHashMap();
/* 34 */   protected final ConcurrentHashMap hasFieldInterception = new ConcurrentHashMap();
/* 35 */   protected final ConcurrentHashMap hasConstructorInterception = new ConcurrentHashMap();
/*    */ 
/* 37 */   protected final ConcurrentHashMap skipConvertableReference = new ConcurrentHashMap();
/* 38 */   protected final ConcurrentHashMap skipFieldInterception = new ConcurrentHashMap();
/* 39 */   protected final ConcurrentHashMap skipConstructorInterception = new ConcurrentHashMap();
/*    */ 
/*    */   public void addConstructionInterceptionMarker(String classname)
/*    */   {
/* 43 */     this.skipConstructorInterception.remove(classname);
/* 44 */     this.skipConvertableReference.remove(classname);
/* 45 */     this.hasConstructorInterception.put(classname, classname);
/* 46 */     this.convertableReference.put(classname, classname);
/*    */   }
/*    */ 
/*    */   public void addFieldInterceptionMarker(String classname)
/*    */   {
/* 51 */     this.skipFieldInterception.remove(classname);
/* 52 */     this.skipConvertableReference.remove(classname);
/* 53 */     this.hasFieldInterception.put(classname, classname);
/* 54 */     this.convertableReference.put(classname, classname);
/*    */   }
/*    */ 
/*    */   public void skipReference(String classname)
/*    */   {
/* 59 */     this.skipConvertableReference.put(classname, classname);
/*    */   }
/*    */ 
/*    */   public boolean shouldSkipConstruction(String classname)
/*    */   {
/* 64 */     return (!this.hasConstructorInterception.containsKey(classname)) && (this.skipConstructorInterception.containsKey(classname));
/*    */   }
/*    */ 
/*    */   public boolean shouldSkipFieldAccess(String classname)
/*    */   {
/* 70 */     return (!this.hasFieldInterception.containsKey(classname)) && (this.skipFieldInterception.containsKey(classname));
/*    */   }
/*    */ 
/*    */   public void skipConstruction(String classname)
/*    */   {
/* 76 */     this.skipConstructorInterception.put(classname, classname);
/*    */   }
/*    */ 
/*    */   public void skipFieldAccess(String classname)
/*    */   {
/* 81 */     this.skipFieldInterception.put(classname, classname);
/*    */   }
/*    */ 
/*    */   public boolean convertReference(String classname)
/*    */   {
/* 86 */     return (!this.skipConvertableReference.containsKey(classname)) || (this.convertableReference.containsKey(classname));
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.InterceptionMarkers
 * JD-Core Version:    0.6.0
 */