/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodExecution;
/*     */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ 
/*     */ public class MethodInfo extends JoinPointInfo
/*     */   implements MethodExecution
/*     */ {
/*     */   private Method advisedMethod;
/*     */   private Method unadvisedMethod;
/*     */   private long hash;
/*     */ 
/*     */   public MethodInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MethodInfo(Class clazz, long hash, long unadvisedHash, Advisor advisor)
/*     */   {
/*  46 */     super(advisor, clazz);
/*     */     try
/*     */     {
/*  50 */       this.hash = hash;
/*  51 */       this.advisedMethod = MethodHashing.findMethodByHash(clazz, hash);
/*  52 */       this.unadvisedMethod = MethodHashing.findMethodByHash(clazz, unadvisedHash);
/*  53 */       setAdvisor(advisor);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  57 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private MethodInfo(MethodInfo other)
/*     */   {
/*  67 */     super(other);
/*  68 */     this.advisedMethod = other.advisedMethod;
/*  69 */     this.unadvisedMethod = other.unadvisedMethod;
/*  70 */     this.hash = other.hash;
/*     */   }
/*     */ 
/*     */   protected Joinpoint internalGetJoinpoint()
/*     */   {
/*  75 */     return new MethodJoinpoint(this.advisedMethod);
/*     */   }
/*     */ 
/*     */   public JoinPointInfo copy()
/*     */   {
/*  80 */     return new MethodInfo(this);
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public Method getAdvisedMethod() {
/*  86 */     return this.advisedMethod;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/*  91 */     return this.advisedMethod;
/*     */   }
/*     */ 
/*     */   public void setAdvisedMethod(Method advisedMethod)
/*     */   {
/*  96 */     this.advisedMethod = advisedMethod;
/*     */   }
/*     */ 
/*     */   public long getHash() {
/* 100 */     return this.hash;
/*     */   }
/*     */ 
/*     */   public void setHash(long hash)
/*     */   {
/* 105 */     this.hash = hash;
/*     */   }
/*     */ 
/*     */   public Method getUnadvisedMethod()
/*     */   {
/* 110 */     return this.unadvisedMethod;
/*     */   }
/*     */ 
/*     */   public void setUnadvisedMethod(Method unadvisedMethod) {
/* 114 */     this.unadvisedMethod = unadvisedMethod;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 119 */     StringBuffer sb = new StringBuffer("Method");
/* 120 */     sb.append("[");
/* 121 */     sb.append("method=" + this.advisedMethod);
/* 122 */     sb.append("]");
/* 123 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 128 */     Object val = super.resolveAnnotation(annotation);
/* 129 */     if (val != null)
/*     */     {
/* 131 */       return val;
/*     */     }
/*     */ 
/* 134 */     Advisor advisor = getAdvisor();
/* 135 */     if (advisor != null)
/*     */     {
/* 137 */       return getAdvisor().resolveAnnotation(this.hash, this.advisedMethod, annotation);
/*     */     }
/* 139 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.MethodInfo
 * JD-Core Version:    0.6.0
 */