/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ 
/*     */ public class AdviceMethodProperties
/*     */ {
/*     */   public static final int JOINPOINT_ARG = -1;
/*     */   public static final int INVOCATION_ARG = -2;
/*     */   public static final int TARGET_ARG = -3;
/*     */   public static final int RETURN_ARG = -4;
/*     */   public static final int THROWABLE_ARG = -5;
/*     */   public static final int ARGS_ARG = -6;
/*     */   public static final int CALLER_ARG = -7;
/*     */   public static final int ARG_ARG = -8;
/*  49 */   public static final CtClass[] EMPTY_PARAMETERS = new CtClass[0];
/*     */   private JoinPointBean joinPoint;
/*     */   private Class aspectClass;
/*     */   private String adviceName;
/*     */   private Class thrownType;
/*     */   private Class joinPointBeanType;
/*     */   private Class invocationType;
/*     */   private Type target;
/*     */   private Type caller;
/*     */   private Type joinpointReturnType;
/*     */   private Type[] joinpointParameters;
/*     */   private Class<?>[] joinpointParameterClassTypes;
/*     */   private Type[] joinpointExceptions;
/*     */   private OptionalParameters optionalParameters;
/*     */   private boolean targetAvailable;
/*     */   private boolean callerAvailable;
/*     */   private Method adviceMethod;
/*     */   private int[] args;
/*     */   private boolean overloadedMethod;
/*     */ 
/*     */   public AdviceMethodProperties(JoinPointBean joinPoint, Class aspectClass, String adviceName, Class joinPointBeanType, Class invocationType, Type joinpointReturnType, Type[] joinpointParameters, Class[] joinpointParameterClassTypes, Type[] joinpointExceptions, Type target, boolean targetAvailable)
/*     */   {
/*  91 */     this(joinPoint, aspectClass, adviceName, null, joinPointBeanType, invocationType, joinpointReturnType, joinpointParameters, joinpointParameterClassTypes, joinpointExceptions, target, targetAvailable);
/*     */   }
/*     */ 
/*     */   public AdviceMethodProperties(JoinPointBean joinPoint, Class aspectClass, String adviceName, Class thrownType, Class joinPointBeanType, Class invocationType, Type joinpointReturnType, Type[] joinpointParameters, Class[] joinpointParameterClassTypes, Type[] joinpointExceptions, Type target, boolean targetAvailable)
/*     */   {
/* 110 */     this.joinPoint = joinPoint;
/* 111 */     this.aspectClass = aspectClass;
/* 112 */     this.adviceName = adviceName;
/* 113 */     this.joinPointBeanType = joinPointBeanType;
/* 114 */     this.invocationType = invocationType;
/* 115 */     this.joinpointReturnType = joinpointReturnType;
/* 116 */     this.joinpointParameters = joinpointParameters;
/* 117 */     this.joinpointParameterClassTypes = joinpointParameterClassTypes;
/* 118 */     this.joinpointExceptions = joinpointExceptions;
/* 119 */     this.target = target;
/* 120 */     this.targetAvailable = targetAvailable;
/* 121 */     this.optionalParameters = OptionalParameters.TARGET;
/*     */   }
/*     */ 
/*     */   public AdviceMethodProperties(JoinPointBean joinPoint, Class aspectClass, String adviceName, Class joinPointBeanType, Class invocationType, Type joinpointReturnType, Type[] joinpointParameters, Class<?>[] joinpointParameterClassTypes, Type[] joinpointExceptions, Type target, boolean targetAvailable, Type caller, boolean callerAvailable)
/*     */   {
/* 139 */     this(joinPoint, aspectClass, adviceName, null, joinPointBeanType, invocationType, joinpointReturnType, joinpointParameters, joinpointParameterClassTypes, joinpointExceptions, target, targetAvailable, caller, callerAvailable);
/*     */   }
/*     */ 
/*     */   public AdviceMethodProperties(JoinPointBean joinPoint, Class aspectClass, String adviceName, Class thrownType, Class joinPointBeanType, Class invocationType, Type joinpointReturnType, Type[] joinpointParameters, Class<?>[] joinpointParameterClassTypes, Type[] joinpointExceptions, Type target, boolean targetAvailable, Type caller, boolean callerAvailable)
/*     */   {
/* 161 */     this(joinPoint, aspectClass, adviceName, thrownType, joinPointBeanType, invocationType, joinpointReturnType, joinpointParameters, joinpointParameterClassTypes, joinpointExceptions, target, targetAvailable);
/*     */ 
/* 164 */     this.caller = caller;
/* 165 */     this.callerAvailable = callerAvailable;
/* 166 */     this.optionalParameters = OptionalParameters.TARGET_CALLER;
/*     */   }
/*     */ 
/*     */   public void setFoundProperties(Method adviceMethod, int[] args)
/*     */   {
/* 171 */     this.adviceMethod = adviceMethod;
/* 172 */     this.args = args;
/*     */   }
/*     */ 
/*     */   public JoinPointBean getJoinPoint()
/*     */   {
/* 177 */     return this.joinPoint;
/*     */   }
/*     */ 
/*     */   public String getAdviceName()
/*     */   {
/* 182 */     return this.adviceName;
/*     */   }
/*     */ 
/*     */   public Class getAspectClass()
/*     */   {
/* 188 */     return this.aspectClass;
/*     */   }
/*     */ 
/*     */   public Class getThrownType()
/*     */   {
/* 193 */     return this.thrownType;
/*     */   }
/*     */ 
/*     */   public Class getJoinPointBeanType()
/*     */   {
/* 198 */     return this.joinPointBeanType;
/*     */   }
/*     */ 
/*     */   public Class getInvocationType()
/*     */   {
/* 204 */     return this.invocationType;
/*     */   }
/*     */ 
/*     */   public Type[] getJoinpointExceptions()
/*     */   {
/* 210 */     return this.joinpointExceptions;
/*     */   }
/*     */ 
/*     */   public Type[] getJoinpointParameters()
/*     */   {
/* 216 */     return this.joinpointParameters;
/*     */   }
/*     */ 
/*     */   public Class<?>[] getJoinpointParameterClassTypes()
/*     */   {
/* 221 */     return this.joinpointParameterClassTypes;
/*     */   }
/*     */ 
/*     */   public Type getJoinpointReturnType()
/*     */   {
/* 226 */     return this.joinpointReturnType;
/*     */   }
/*     */ 
/*     */   public boolean isAdviceVoid() throws NotFoundException
/*     */   {
/* 231 */     return this.adviceMethod.getReturnType().equals(Void.TYPE);
/*     */   }
/*     */ 
/*     */   public Method getAdviceMethod()
/*     */   {
/* 236 */     return this.adviceMethod;
/*     */   }
/*     */ 
/*     */   public int[] getArgs()
/*     */   {
/* 241 */     return this.args;
/*     */   }
/*     */ 
/*     */   public Type getTargetType()
/*     */   {
/* 246 */     return this.target;
/*     */   }
/*     */ 
/*     */   public boolean isTargetAvailable()
/*     */   {
/* 251 */     return this.targetAvailable;
/*     */   }
/*     */ 
/*     */   public Type getCallerType()
/*     */   {
/* 256 */     return this.caller;
/*     */   }
/*     */ 
/*     */   public boolean isCallerAvailable()
/*     */   {
/* 261 */     return this.callerAvailable;
/*     */   }
/*     */ 
/*     */   public OptionalParameters getOptionalParameters()
/*     */   {
/* 266 */     return this.optionalParameters;
/*     */   }
/*     */ 
/*     */   public void setOptionalParameters(OptionalParameters optionalParameters)
/*     */   {
/* 271 */     this.optionalParameters = optionalParameters;
/*     */   }
/*     */ 
/*     */   public boolean isAdviceOverloaded()
/*     */   {
/* 276 */     return this.overloadedMethod;
/*     */   }
/*     */ 
/*     */   public void setAdviceOverloaded(boolean overloaded)
/*     */   {
/* 281 */     this.overloadedMethod = overloaded;
/*     */   }
/*     */ 
/*     */   public static enum OptionalParameters
/*     */   {
/*  51 */     TARGET, TARGET_CALLER;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.AdviceMethodProperties
 * JD-Core Version:    0.6.0
 */