/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import org.jboss.aop.advice.annotation.AdviceMethodFactory;
/*     */ 
/*     */ public enum AdviceType
/*     */ {
/*  36 */   BEFORE("before", AdviceMethodFactory.BEFORE, true, "before"), 
/*  37 */   AROUND("around", AdviceMethodFactory.AROUND, false, "around"), 
/*  38 */   AFTER("after", AdviceMethodFactory.AFTER, false, "after"), 
/*  39 */   THROWING("throwing", AdviceMethodFactory.THROWING, false, "after-throwing"), 
/*  40 */   FINALLY("finally", AdviceMethodFactory.FINALLY, false, "finally");
/*     */ 
/*     */   private String name;
/*     */   private String description;
/*     */   private String accessor;
/*     */   private AdviceMethodFactory factory;
/*     */   private boolean generatedOnly;
/*     */ 
/*  51 */   private AdviceType(String name, AdviceMethodFactory factory, boolean generatedOnly, String description) { this.name = name;
/*  52 */     this.accessor = ("get" + Character.toUpperCase(name.charAt(0)) + name.substring(1));
/*     */ 
/*  54 */     this.factory = factory;
/*  55 */     this.factory.setAdviceType(this);
/*  56 */     this.generatedOnly = generatedOnly;
/*  57 */     this.description = description;
/*     */   }
/*     */ 
/*     */   public final String getName()
/*     */   {
/*  65 */     return this.name;
/*     */   }
/*     */ 
/*     */   public final String getAccessor()
/*     */   {
/*  78 */     return this.accessor;
/*     */   }
/*     */ 
/*     */   public final AdviceMethodFactory getFactory()
/*     */   {
/*  89 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public final boolean isGeneratedOnly()
/*     */   {
/* 101 */     return this.generatedOnly;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 111 */     return this.description;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.AdviceType
 * JD-Core Version:    0.6.0
 */