/*    */ package org.jboss.aop.advice;
/*    */ 
/*    */ import java.lang.ref.WeakReference;
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.aop.util.logging.AOPLogger;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public abstract class AspectFactoryWithClassLoaderSupport
/*    */   implements AspectFactory, AspectFactoryWithClassLoader
/*    */ {
/* 37 */   private static final Logger logger = AOPLogger.getLogger(AspectFactoryWithClassLoaderSupport.class);
/*    */   private WeakReference loader;
/* 41 */   private ThreadLocal scopedClassLoader = new ThreadLocal();
/*    */ 
/*    */   public void setClassLoader(ClassLoader cl)
/*    */   {
/* 49 */     this.loader = new WeakReference(cl);
/*    */   }
/*    */ 
/*    */   protected ClassLoader getLoader()
/*    */   {
/* 54 */     ClassLoader scopedClassLoader = peekScopedClassLoader();
/* 55 */     if (scopedClassLoader != null)
/*    */     {
/* 57 */       return scopedClassLoader;
/*    */     }
/* 59 */     if (this.loader != null)
/*    */     {
/* 61 */       return (ClassLoader)this.loader.get();
/*    */     }
/* 63 */     return null;
/*    */   }
/*    */ 
/*    */   public void pushScopedClassLoader(ClassLoader scopedCl)
/*    */   {
/* 68 */     this.scopedClassLoader.set(scopedCl);
/*    */   }
/*    */ 
/*    */   public void popScopedClassLoader()
/*    */   {
/* 73 */     this.scopedClassLoader.set(null);
/*    */   }
/*    */ 
/*    */   public ClassLoader peekScopedClassLoader()
/*    */   {
/* 78 */     return (ClassLoader)this.scopedClassLoader.get();
/*    */   }
/*    */ 
/*    */   protected Class loadClass(String name) throws ClassNotFoundException
/*    */   {
/* 83 */     ClassLoader cl = getLoader();
/* 84 */     if (cl == null)
/*    */     {
/* 87 */       ClassLoader tcl = SecurityActions.getContextClassLoader();
/* 88 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Using context classloader " + tcl + " to load aspect " + name);
/* 89 */       return tcl.loadClass(name);
/*    */     }
/*    */ 
/* 93 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("Using scoped classloader " + cl + " to load aspect " + name);
/* 94 */     return cl.loadClass(name);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.AspectFactoryWithClassLoaderSupport
 * JD-Core Version:    0.6.0
 */