/*    */ package org.jboss.aop.advice;
/*    */ 
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.pointcut.CFlowMatcher;
/*    */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*    */ 
/*    */ public class CFlowInterceptor
/*    */   implements Interceptor
/*    */ {
/*    */   Interceptor[] chain;
/*    */   ASTCFlowExpression expr;
/*    */   String cflowString;
/*    */ 
/*    */   public CFlowInterceptor(String cflowString, ASTCFlowExpression expr, Interceptor[] chain)
/*    */   {
/* 43 */     this.chain = chain;
/* 44 */     this.expr = expr;
/* 45 */     this.cflowString = cflowString;
/*    */   }
/*    */ 
/*    */   public String getName() {
/* 49 */     return "CFlowInterceptor";
/*    */   }
/*    */ 
/*    */   public String getCFlowString()
/*    */   {
/* 54 */     return this.cflowString;
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 59 */     if (new CFlowMatcher().matches(this.expr, invocation))
/*    */     {
/* 61 */       Invocation wrapper = invocation.getWrapper(this.chain);
/* 62 */       return wrapper.invokeNext();
/*    */     }
/*    */ 
/* 65 */     return invocation.invokeNext();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.CFlowInterceptor
 * JD-Core Version:    0.6.0
 */