/*    */ package org.jboss.aop.advice;
/*    */ 
/*    */ import org.jboss.aop.pointcut.DynamicCFlow;
/*    */ import org.jboss.util.xml.XmlLoadable;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class DynamicCFlowDefinition
/*    */ {
/*    */   private String name;
/*    */   private String className;
/*    */   private Element element;
/*    */   private Class pClass;
/*    */ 
/*    */   public DynamicCFlowDefinition(Element element, String className, String name)
/*    */   {
/* 43 */     this.className = className;
/* 44 */     this.element = element;
/* 45 */     this.name = name;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 50 */     return this.name;
/*    */   }
/*    */ 
/*    */   public String getClassName()
/*    */   {
/* 55 */     return this.className;
/*    */   }
/*    */ 
/*    */   public DynamicCFlow create()
/*    */   {
/* 60 */     if (this.pClass == null)
/*    */     {
/*    */       try
/*    */       {
/* 65 */         this.pClass = SecurityActions.getContextClassLoader().loadClass(this.className);
/*    */       }
/*    */       catch (ClassNotFoundException e)
/*    */       {
/* 69 */         throw new RuntimeException("dynamic cflow class not found: " + this.className);
/*    */       }
/*    */     }
/*    */     try
/*    */     {
/* 74 */       DynamicCFlow cflow = (DynamicCFlow)this.pClass.newInstance();
/* 75 */       if ((cflow instanceof XmlLoadable))
/*    */       {
/* 77 */         ((XmlLoadable)cflow).importXml(this.element);
/*    */       }
/* 79 */       return cflow;
/*    */     }
/*    */     catch (InstantiationException e)
/*    */     {
/* 83 */       throw new RuntimeException(e);
/*    */     }
/*    */     catch (IllegalAccessException e) {
/*    */     }
/* 87 */     throw new RuntimeException(e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.DynamicCFlowDefinition
 * JD-Core Version:    0.6.0
 */