/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.joinpoint.CallerInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
/*     */ import org.jboss.aop.joinpoint.ConstructorJoinpoint;
/*     */ import org.jboss.aop.joinpoint.FieldJoinpoint;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*     */ 
/*     */ public class PerJoinpointInterceptor
/*     */   implements Interceptor
/*     */ {
/*     */   AspectDefinition aspectDefinition;
/*     */   Joinpoint joinpoint;
/*     */ 
/*     */   public static Interceptor createInterceptor(Advisor advisor, Joinpoint joinpoint, AspectDefinition def)
/*     */     throws Exception
/*     */   {
/*  49 */     if ((joinpoint instanceof MethodJoinpoint))
/*     */     {
/*  51 */       MethodJoinpoint method = (MethodJoinpoint)joinpoint;
/*  52 */       if (Modifier.isStatic(method.getMethod().getModifiers()))
/*     */       {
/*  54 */         return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
/*     */       }
/*     */     } else {
/*  57 */       if ((joinpoint instanceof ConstructorJoinpoint))
/*     */       {
/*  59 */         return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
/*     */       }
/*  61 */       if ((joinpoint instanceof MethodCalledByMethodJoinpoint))
/*     */       {
/*  63 */         MethodCalledByMethodJoinpoint method = (MethodCalledByMethodJoinpoint)joinpoint;
/*  64 */         if (Modifier.isStatic(method.getCalling().getModifiers()))
/*     */         {
/*  66 */           return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
/*     */         }
/*     */       }
/*  69 */       else if ((joinpoint instanceof ConstructorCalledByMethodJoinpoint))
/*     */       {
/*  71 */         ConstructorCalledByMethodJoinpoint method = (ConstructorCalledByMethodJoinpoint)joinpoint;
/*  72 */         if (Modifier.isStatic(method.getCalling().getModifiers()))
/*     */         {
/*  74 */           return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
/*     */         }
/*     */       }
/*  77 */       else if ((joinpoint instanceof FieldJoinpoint))
/*     */       {
/*  79 */         FieldJoinpoint field = (FieldJoinpoint)joinpoint;
/*  80 */         if (Modifier.isStatic(field.getField().getModifiers()))
/*     */         {
/*  82 */           ClassAdvisor classAdvisor = (ClassAdvisor)advisor;
/*  83 */           return (Interceptor)classAdvisor.getFieldAspect(field, def);
/*     */         }
/*     */       }
/*     */     }
/*  87 */     return new PerJoinpointInterceptor(def, advisor, joinpoint);
/*     */   }
/*     */ 
/*     */   public PerJoinpointInterceptor(AspectDefinition a, Advisor advisor, Joinpoint joinpoint)
/*     */   {
/*  95 */     this.aspectDefinition = a;
/*  96 */     advisor.addPerInstanceJoinpointAspect(joinpoint, a);
/*  97 */     this.joinpoint = joinpoint;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 102 */     return this.aspectDefinition.getName();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/* 107 */     if ((invocation instanceof CallerInvocation))
/*     */     {
/* 111 */       Object callingObject = ((CallerInvocation)invocation).getCallingObject();
/*     */ 
/* 113 */       if (callingObject == null) return invocation.invokeNext();
/*     */ 
/* 115 */       Advised advised = (Advised)callingObject;
/* 116 */       InstanceAdvisor advisor = advised._getInstanceAdvisor();
/* 117 */       Interceptor interceptor = (Interceptor)advisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
/* 118 */       return interceptor.invoke(invocation);
/*     */     }
/*     */ 
/* 123 */     Object targetObject = invocation.getTargetObject();
/* 124 */     if (targetObject == null) return invocation.invokeNext();
/*     */ 
/* 126 */     Advised advised = (Advised)targetObject;
/* 127 */     InstanceAdvisor advisor = advised._getInstanceAdvisor();
/* 128 */     Interceptor interceptor = (Interceptor)advisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
/* 129 */     return interceptor.invoke(invocation);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.PerJoinpointInterceptor
 * JD-Core Version:    0.6.0
 */