/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import org.jboss.util.propertyeditor.ClassArrayEditor;
/*     */ import org.jboss.util.propertyeditor.IntArrayEditor;
/*     */ import org.jboss.util.propertyeditor.StringArrayEditor;
/*     */ 
/*     */ public class SecurityActions
/*     */ {
/*     */   private static void doInitEditors()
/*     */   {
/*  78 */     String[] currentPath = PropertyEditorManager.getEditorSearchPath();
/*  79 */     int length = currentPath != null ? currentPath.length : 0;
/*  80 */     String[] newPath = new String[length + 2];
/*  81 */     System.arraycopy(currentPath, 0, newPath, 2, length);
/*     */ 
/*  84 */     newPath[0] = "org.jboss.util.propertyeditor";
/*  85 */     newPath[1] = "org.jboss.mx.util.propertyeditor";
/*  86 */     PropertyEditorManager.setEditorSearchPath(newPath);
/*     */ 
/*  92 */     Class strArrayType = [Ljava.lang.String.class;
/*  93 */     PropertyEditorManager.registerEditor(strArrayType, StringArrayEditor.class);
/*  94 */     Class clsArrayType = [Ljava.lang.Class.class;
/*  95 */     PropertyEditorManager.registerEditor(clsArrayType, ClassArrayEditor.class);
/*  96 */     Class intArrayType = [I.class;
/*  97 */     PropertyEditorManager.registerEditor(intArrayType, IntArrayEditor.class);
/*     */   }
/*     */ 
/*     */   static void initEditors()
/*     */   {
/* 103 */     if (System.getSecurityManager() == null)
/*     */     {
/* 105 */       InitPropertyEditorsAction.NON_PRIVILEGED.initEditors();
/*     */     }
/*     */     else
/*     */     {
/* 109 */       InitPropertyEditorsAction.PRIVILEGED.initEditors();
/*     */     }
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 125 */     if (System.getSecurityManager() == null) {
/* 126 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/* 128 */     return (ClassLoader)AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
/*     */   }
/*     */ 
/*     */   public static class GetContextClassLoaderAction
/*     */     implements PrivilegedAction<ClassLoader>
/*     */   {
/* 115 */     public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();
/*     */ 
/*     */     public ClassLoader run()
/*     */     {
/* 119 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract interface InitPropertyEditorsAction
/*     */   {
/*  45 */     public static final InitPropertyEditorsAction PRIVILEGED = new InitPropertyEditorsAction()
/*     */     {
/*     */       public void initEditors()
/*     */       {
/*     */         try
/*     */         {
/*  51 */           AccessController.doPrivileged(new PrivilegedExceptionAction()
/*     */           {
/*     */             public Object run() throws Exception
/*     */             {
/*  55 */               SecurityActions.access$000();
/*  56 */               return null;
/*     */             }
/*     */           });
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*  62 */           throw new RuntimeException(e.getException());
/*     */         }
/*     */       }
/*  45 */     };
/*     */ 
/*  67 */     public static final InitPropertyEditorsAction NON_PRIVILEGED = new InitPropertyEditorsAction()
/*     */     {
/*     */       public void initEditors()
/*     */       {
/*  71 */         SecurityActions.access$000();
/*     */       }
/*  67 */     };
/*     */ 
/*     */     public abstract void initEditors();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.SecurityActions
 * JD-Core Version:    0.6.0
 */