/*    */ package org.jboss.aop.advice.annotation;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.AdviceMethodProperties;
/*    */ import org.jboss.aop.advice.annotation.assignability.DegreeAlgorithm;
/*    */ 
/*    */ abstract class AdviceInfo
/*    */   implements Comparable<AdviceInfo>
/*    */ {
/* 16 */   protected static final DegreeAlgorithm DEGREE = DegreeAlgorithm.getInstance();
/*    */   protected int rank;
/*    */   protected Method method;
/*    */   protected Class<?>[] parameterTypes;
/*    */ 
/*    */   protected AdviceInfo(Method method, int rank)
/*    */   {
/* 33 */     this.method = method;
/* 34 */     this.rank = rank;
/* 35 */     this.parameterTypes = method.getParameterTypes();
/*    */   }
/*    */ 
/*    */   public final short getReturnAssignabilityDegree(AdviceMethodProperties properties)
/*    */   {
/* 50 */     Class returnType = this.method.getReturnType();
/* 51 */     if (returnType == Void.TYPE)
/*    */     {
/* 53 */       return 32767;
/*    */     }
/* 55 */     short degree = DEGREE.getAssignabilityDegree(properties.getJoinpointReturnType(), returnType);
/*    */ 
/* 57 */     if (degree == 32767)
/*    */     {
/* 61 */       return 32766;
/*    */     }
/* 63 */     return degree;
/*    */   }
/*    */ 
/*    */   public final int getRank()
/*    */   {
/* 72 */     return this.rank;
/*    */   }
/*    */ 
/*    */   public int compareTo(AdviceInfo o)
/*    */   {
/* 81 */     return o.rank - this.rank;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 86 */     return this.method.toString();
/*    */   }
/*    */ 
/*    */   public abstract boolean matches(AdviceMethodProperties paramAdviceMethodProperties, AdviceMethodFactory.ReturnType paramReturnType);
/*    */ 
/*    */   public abstract void resetMatching();
/*    */ 
/*    */   public abstract short getAssignabilityDegree(int paramInt, boolean paramBoolean, AdviceMethodProperties paramAdviceMethodProperties);
/*    */ 
/*    */   public abstract void assignAdviceInfo(AdviceMethodProperties paramAdviceMethodProperties);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.AdviceInfo
 * JD-Core Version:    0.6.0
 */