/*    */ package org.jboss.aop.advice.annotation.assignability;
/*    */ 
/*    */ import java.lang.reflect.TypeVariable;
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ 
/*    */ public class VariableHierarchy
/*    */ {
/*    */   private Map<String, VariableNode> map;
/*    */   private int boundComparation;
/*    */   private int realBoundComparation;
/*    */ 
/*    */   public VariableHierarchy()
/*    */   {
/* 42 */     this.map = new HashMap();
/*    */   }
/*    */ 
/*    */   public void reset()
/*    */   {
/* 47 */     this.map.clear();
/* 48 */     this.boundComparation = 0;
/* 49 */     this.realBoundComparation = 0;
/*    */   }
/*    */ 
/*    */   VariableNode getVariableNode(TypeVariable typeVariable)
/*    */   {
/* 54 */     String key = typeVariable.getName();
/* 55 */     if (this.map.containsKey(key))
/*    */     {
/* 57 */       return (VariableNode)this.map.get(key);
/*    */     }
/* 59 */     VariableNode node = new VariableNode(typeVariable, this);
/* 60 */     this.map.put(key, node);
/* 61 */     return node;
/*    */   }
/*    */ 
/*    */   void startBoundComparation()
/*    */   {
/* 66 */     this.boundComparation += 1;
/*    */   }
/*    */ 
/*    */   void finishBoundComparation()
/*    */   {
/* 71 */     this.boundComparation -= 1;
/*    */   }
/*    */ 
/*    */   boolean isBoundComparation()
/*    */   {
/* 76 */     return this.boundComparation > 0;
/*    */   }
/*    */ 
/*    */   void startRealBoundComparation()
/*    */   {
/* 81 */     this.realBoundComparation += 1;
/*    */   }
/*    */ 
/*    */   void finishRealBoundComparation()
/*    */   {
/* 86 */     this.realBoundComparation -= 1;
/*    */   }
/*    */ 
/*    */   boolean isRealBoundComparation()
/*    */   {
/* 91 */     return this.realBoundComparation > 0;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.assignability.VariableHierarchy
 * JD-Core Version:    0.6.0
 */