/*     */ package org.jboss.aop.annotation;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.bytecode.AnnotationsAttribute;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import javassist.bytecode.FieldInfo;
/*     */ import javassist.bytecode.MethodInfo;
/*     */ import javassist.bytecode.annotation.Annotation;
/*     */ import org.jboss.annotation.factory.javassist.AnnotationProxy;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.util.ReflectToJavassist;
/*     */ 
/*     */ public class PortableAnnotationElement
/*     */ {
/*     */   public static boolean isInvisibleAnnotationPresent(Field field, String annotation)
/*     */     throws Exception
/*     */   {
/*  55 */     CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
/*  56 */     return AnnotationElement.isInvisibleAnnotationPresent(ctMethod, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isInvisibleAnnotationPresent(CtField field, String annotation)
/*     */   {
/*  62 */     FieldInfo mi = field.getFieldInfo2();
/*     */ 
/*  64 */     AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/*  65 */     if (invisible == null) return false;
/*     */ 
/*  67 */     return invisible.getAnnotation(annotation) != null;
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(CtField field, String annotation)
/*     */   {
/*  72 */     FieldInfo mi = field.getFieldInfo2();
/*     */ 
/*  74 */     AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/*  75 */     if (visible == null) return false;
/*     */ 
/*  77 */     return visible.getAnnotation(annotation) != null;
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(CtField ctField, String annotation)
/*     */   {
/*  82 */     FieldInfo mi = ctField.getFieldInfo2();
/*     */ 
/*  84 */     AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/*  85 */     if (visible != null)
/*     */     {
/*  87 */       if (visible.getAnnotation(annotation) != null) return true;
/*     */     }
/*     */ 
/*  90 */     AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/*  91 */     if (invisible != null)
/*     */     {
/*  93 */       if (invisible.getAnnotation(annotation) != null) return true;
/*     */     }
/*     */ 
/*  96 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean isInvisibleAnnotationPresent(Method method, String annotation) throws Exception
/*     */   {
/* 101 */     CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
/* 102 */     if (ctMethod == null) return false;
/* 103 */     MethodInfo mi = ctMethod.getMethodInfo2();
/*     */ 
/* 106 */     AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/* 107 */     if (invisible == null) return false;
/*     */ 
/* 110 */     return invisible.getAnnotation(annotation) != null;
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(Field field, String annotation) throws Exception
/*     */   {
/* 115 */     CtField ctField = ReflectToJavassist.fieldToJavassist(field);
/* 116 */     return AnnotationElement.isAnyAnnotationPresent(ctField, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(Method method, String annotation)
/*     */     throws Exception
/*     */   {
/* 122 */     CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
/* 123 */     if (ctMethod == null) return false;
/* 124 */     boolean present = AnnotationElement.isAnyAnnotationPresent(ctMethod, annotation);
/* 125 */     return present;
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(CtMethod ctMethod, String annotation)
/*     */   {
/* 131 */     MethodInfo mi = ctMethod.getMethodInfo2();
/*     */ 
/* 133 */     AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/* 134 */     if (visible != null)
/*     */     {
/* 136 */       if (visible.getAnnotation(annotation) != null) return true;
/*     */     }
/*     */ 
/* 139 */     AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/* 140 */     if (invisible != null)
/*     */     {
/* 142 */       if (invisible.getAnnotation(annotation) != null) return true;
/*     */     }
/*     */ 
/* 145 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean isInvisibleAnnotationPresent(Constructor con, String annotation) throws Exception
/*     */   {
/* 150 */     CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
/* 151 */     return AnnotationElement.isInvisibleAnnotationPresent(ctMethod, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isInvisibleAnnotationPresent(CtConstructor ctMethod, String annotation)
/*     */   {
/* 158 */     MethodInfo mi = ctMethod.getMethodInfo2();
/*     */ 
/* 161 */     AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/* 162 */     if (invisible == null) return false;
/*     */ 
/* 164 */     return invisible.getAnnotation(annotation) != null;
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(CtConstructor ctMethod, String annotation)
/*     */   {
/* 169 */     MethodInfo mi = ctMethod.getMethodInfo2();
/*     */ 
/* 172 */     AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/* 173 */     if (visible == null) return false;
/*     */ 
/* 175 */     return visible.getAnnotation(annotation) != null;
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(Constructor con, String annotation) throws Exception
/*     */   {
/* 180 */     CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
/* 181 */     return AnnotationElement.isAnyAnnotationPresent(ctMethod, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(CtConstructor ctMethod, String annotation)
/*     */   {
/* 187 */     MethodInfo mi = ctMethod.getMethodInfo2();
/*     */ 
/* 189 */     AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/* 190 */     if (visible != null)
/*     */     {
/* 192 */       if (visible.getAnnotation(annotation) != null) return true;
/*     */     }
/*     */ 
/* 195 */     AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/* 196 */     if (invisible != null)
/*     */     {
/* 198 */       if (invisible.getAnnotation(annotation) != null) return true;
/*     */     }
/*     */ 
/* 201 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean isInvisibleAnnotationPresent(Class clazz, String annotation) throws Exception
/*     */   {
/* 206 */     if (clazz == Void.TYPE) return false;
/* 207 */     ClassFile cf = AnnotationElement.getClassFile(clazz);
/*     */ 
/* 209 */     AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
/* 210 */     if (invisible == null) return false;
/*     */ 
/* 212 */     return invisible.getAnnotation(annotation) != null;
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(CtClass clazz, String annotation) throws Exception {
/*     */     String name;
/*     */     try {
/* 219 */       if (clazz == CtClass.voidType) return false;
/*     */ 
/* 221 */       CtClass theClass = clazz;
/* 222 */       while (theClass.isArray())
/*     */       {
/* 224 */         theClass = theClass.getComponentType();
/*     */       }
/*     */ 
/* 227 */       if (theClass.isPrimitive()) return false;
/*     */ 
/* 229 */       ClassFile cf = theClass.getClassFile2();
/* 230 */       AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
/* 231 */       if (visible != null)
/*     */       {
/* 233 */         if (visible.getAnnotation(annotation) != null) return true;
/*     */       }
/*     */ 
/* 236 */       AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
/* 237 */       if (invisible != null)
/*     */       {
/* 239 */         if (invisible.getAnnotation(annotation) != null) return true;
/*     */       }
/*     */ 
/* 242 */       return false;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 246 */       name = clazz != null ? clazz.getName() : null;
/* 247 */     }throw new RuntimeException("Error looking for " + annotation + " in " + clazz.getName(), e);
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(Class clazz, String annotation)
/*     */     throws Exception
/*     */   {
/* 253 */     if (clazz == Void.TYPE) return false;
/* 254 */     ClassFile cf = AnnotationElement.getClassFile(clazz);
/* 255 */     AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
/* 256 */     if (visible != null)
/*     */     {
/* 258 */       if (visible.getAnnotation(annotation) != null) return true;
/*     */     }
/*     */ 
/* 261 */     AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
/* 262 */     if (invisible != null)
/*     */     {
/* 264 */       if (invisible.getAnnotation(annotation) != null) return true;
/*     */     }
/*     */ 
/* 267 */     return false;
/*     */   }
/*     */ 
/*     */   protected static ClassFile getClassFile(Class clazz) throws NotFoundException
/*     */   {
/* 272 */     ClassPool pool = AspectManager.instance().findClassPool(clazz.getClassLoader());
/* 273 */     CtClass ct = pool.get(clazz.getName());
/* 274 */     ClassFile cf = ct.getClassFile2();
/* 275 */     return cf;
/*     */   }
/*     */ 
/*     */   protected static Object create(AnnotationsAttribute group, Class annotation) throws Exception
/*     */   {
/* 280 */     if (group == null) return null;
/* 281 */     Annotation info = group.getAnnotation(annotation.getName());
/* 282 */     if (info == null) return null;
/* 283 */     return AnnotationProxy.createProxy(info, annotation);
/*     */   }
/*     */ 
/*     */   public static Object getInvisibleAnnotation(Method method, Class annotation)
/*     */   {
/*     */     try
/*     */     {
/* 290 */       CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
/* 291 */       if (ctMethod == null)
/*     */       {
/* 293 */         return null;
/*     */       }
/* 295 */       MethodInfo mi = ctMethod.getMethodInfo2();
/*     */ 
/* 297 */       AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/* 298 */       if (invisible == null) return null;
/*     */ 
/* 300 */       return create(invisible, annotation);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 304 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static Object getInvisibleAnnotation(Constructor con, Class annotation)
/*     */   {
/*     */     try
/*     */     {
/* 312 */       CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
/* 313 */       MethodInfo mi = ctMethod.getMethodInfo2();
/*     */ 
/* 316 */       AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/* 317 */       if (invisible == null) return null;
/*     */ 
/* 319 */       return create(invisible, annotation);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 323 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static Object getInvisibleAnnotation(Field field, Class annotation)
/*     */   {
/*     */     try
/*     */     {
/* 331 */       CtField ctField = ReflectToJavassist.fieldToJavassist(field);
/* 332 */       FieldInfo mi = ctField.getFieldInfo2();
/*     */ 
/* 335 */       AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/* 336 */       if (invisible == null) return null;
/*     */ 
/* 338 */       return create(invisible, annotation);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 342 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static Object getInvisibleAnnotation(Class clazz, Class annotation)
/*     */   {
/*     */     try
/*     */     {
/* 350 */       if (clazz == Void.TYPE) return null;
/* 351 */       ClassFile cf = getClassFile(clazz);
/*     */ 
/* 353 */       AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
/* 354 */       if (invisible == null) return null;
/*     */ 
/* 356 */       return create(invisible, annotation);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 360 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static Object getAnyAnnotation(Method method, Class annotation)
/*     */   {
/* 373 */     Object rtn = AnnotationElement.getVisibleAnnotation(method, annotation);
/* 374 */     if (rtn != null) return rtn;
/* 375 */     return getInvisibleAnnotation(method, annotation);
/*     */   }
/*     */ 
/*     */   public static Object getAnyAnnotation(Constructor con, Class annotation)
/*     */   {
/* 387 */     Object rtn = AnnotationElement.getVisibleAnnotation(con, annotation);
/* 388 */     if (rtn != null) return rtn;
/* 389 */     return getInvisibleAnnotation(con, annotation);
/*     */   }
/*     */ 
/*     */   public static Object getAnyAnnotation(Field field, Class annotation)
/*     */   {
/* 394 */     Object rtn = AnnotationElement.getVisibleAnnotation(field, annotation);
/* 395 */     if (rtn != null) return rtn;
/* 396 */     return getInvisibleAnnotation(field, annotation);
/*     */   }
/*     */ 
/*     */   public static Object getAnyAnnotation(Class clazz, Class annotation)
/*     */   {
/* 401 */     if (clazz == Void.TYPE) return null;
/* 402 */     Object rtn = AnnotationElement.getVisibleAnnotation(clazz, annotation);
/* 403 */     if (rtn != null) return rtn;
/* 404 */     return getInvisibleAnnotation(clazz, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(Field field, Class annotation) throws Exception
/*     */   {
/* 409 */     if (AnnotationElement.isVisibleAnnotationPresent(field, annotation)) return true;
/* 410 */     CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
/* 411 */     return isInvisibleAnnotationPresent(ctMethod, annotation.getName());
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(Class clazz, Class annotation) throws Exception
/*     */   {
/* 416 */     if (clazz == Void.TYPE) return false;
/* 417 */     if (AnnotationElement.isVisibleAnnotationPresent(clazz, annotation)) return true;
/* 418 */     ClassFile cf = getClassFile(clazz);
/*     */ 
/* 420 */     AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
/* 421 */     if (invisible == null) return false;
/*     */ 
/* 423 */     return invisible.getAnnotation(annotation.getName()) != null;
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(Constructor con, Class annotation) throws Exception
/*     */   {
/* 428 */     if (AnnotationElement.isVisibleAnnotationPresent(con, annotation)) return true;
/* 429 */     CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
/* 430 */     return isVisibleAnnotationPresent(ctMethod, annotation.getName());
/*     */   }
/*     */ 
/*     */   public static boolean isAnyAnnotationPresent(Method method, Class annotation)
/*     */     throws Exception
/*     */   {
/* 437 */     if (AnnotationElement.isVisibleAnnotationPresent(method, annotation)) return true;
/* 438 */     CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
/* 439 */     if (ctMethod == null) return false;
/* 440 */     MethodInfo mi = ctMethod.getMethodInfo2();
/*     */ 
/* 443 */     AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/* 444 */     if (invisible == null) return false;
/*     */ 
/* 446 */     return invisible.getAnnotation(annotation.getName()) != null;
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(Field field, String annotation) throws Exception
/*     */   {
/* 451 */     CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
/* 452 */     return isVisibleAnnotationPresent(ctMethod, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(Class clazz, String annotation) throws Exception
/*     */   {
/* 457 */     if (clazz == Void.TYPE) return false;
/*     */ 
/* 459 */     ClassFile cf = getClassFile(clazz);
/*     */ 
/* 461 */     AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
/* 462 */     if (visible == null) return false;
/*     */ 
/* 464 */     return visible.getAnnotation(annotation) != null;
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(Constructor con, String annotation) throws Exception
/*     */   {
/* 469 */     CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
/* 470 */     return isVisibleAnnotationPresent(ctMethod, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(Method method, String annotation)
/*     */     throws Exception
/*     */   {
/* 477 */     CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
/* 478 */     if (ctMethod == null) return false;
/* 479 */     MethodInfo mi = ctMethod.getMethodInfo2();
/*     */ 
/* 482 */     AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/* 483 */     if (visible == null) return false;
/*     */ 
/* 485 */     return visible.getAnnotation(annotation) != null;
/*     */   }
/*     */ 
/*     */   public static Object[] getVisibleAnnotations(Class clazz) throws Exception
/*     */   {
/* 490 */     return AnnotationElement.getVisibleAnnotations(clazz);
/*     */   }
/*     */ 
/*     */   public static Object[] getVisibleAnnotations(Method m) throws Exception
/*     */   {
/* 495 */     return AnnotationElement.getVisibleAnnotations(m);
/*     */   }
/*     */ 
/*     */   public static Object[] getVisibleAnnotations(Field f) throws Exception
/*     */   {
/* 500 */     return AnnotationElement.getVisibleAnnotations(f);
/*     */   }
/*     */ 
/*     */   public static Object[] getVisibleAnnotations(Constructor c) throws Exception
/*     */   {
/* 505 */     return AnnotationElement.getVisibleAnnotations(c);
/*     */   }
/*     */ 
/*     */   public static Class getAnnotationType(Object o)
/*     */   {
/* 510 */     Class proxy = o.getClass();
/* 511 */     if (Proxy.isProxyClass(proxy))
/*     */     {
/* 513 */       Class[] interfaces = proxy.getInterfaces();
/* 514 */       if (interfaces.length == 1)
/*     */       {
/* 516 */         return interfaces[0];
/*     */       }
/*     */     }
/* 519 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.PortableAnnotationElement
 * JD-Core Version:    0.6.0
 */