/*     */ package org.jboss.aop.annotation.compiler;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.bytecode.ConstPool;
/*     */ import javassist.bytecode.annotation.Annotation;
/*     */ import javassist.bytecode.annotation.AnnotationMemberValue;
/*     */ import javassist.bytecode.annotation.ArrayMemberValue;
/*     */ import javassist.bytecode.annotation.CharMemberValue;
/*     */ import javassist.bytecode.annotation.MemberValue;
/*     */ import javassist.bytecode.annotation.StringMemberValue;
/*     */ import org.jboss.annotation.factory.ast.ASTAnnotation;
/*     */ import org.jboss.annotation.factory.ast.ASTChar;
/*     */ import org.jboss.annotation.factory.ast.ASTIdentifier;
/*     */ import org.jboss.annotation.factory.ast.ASTMemberValue;
/*     */ import org.jboss.annotation.factory.ast.ASTMemberValueArrayInitializer;
/*     */ import org.jboss.annotation.factory.ast.ASTMemberValuePair;
/*     */ import org.jboss.annotation.factory.ast.ASTMemberValuePairs;
/*     */ import org.jboss.annotation.factory.ast.ASTSingleMemberValue;
/*     */ import org.jboss.annotation.factory.ast.ASTStart;
/*     */ import org.jboss.annotation.factory.ast.ASTString;
/*     */ import org.jboss.annotation.factory.ast.AnnotationParserVisitor;
/*     */ import org.jboss.annotation.factory.ast.Node;
/*     */ import org.jboss.annotation.factory.ast.SimpleNode;
/*     */ 
/*     */ public class AnnotationInfoCreator
/*     */   implements AnnotationParserVisitor
/*     */ {
/*     */   private ClassPool pool;
/*     */   private ConstPool cp;
/*     */   private Annotation base;
/*     */ 
/*     */   public AnnotationInfoCreator(ClassPool pool, ConstPool cp, Annotation base)
/*     */   {
/*  62 */     this.pool = pool;
/*  63 */     this.cp = cp;
/*  64 */     this.base = base;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberValuePairs node, Object data)
/*     */   {
/*  69 */     node.childrenAccept(this, data);
/*  70 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberValuePair node, Object data)
/*     */   {
/*  75 */     String name = node.getIdentifier().getValue();
/*  76 */     MemberValue mv = this.base.getMemberValue(name);
/*  77 */     if (mv == null)
/*     */     {
/*  79 */       throw new RuntimeException("member value is null for created annotation: " + this.base.getTypeName() + " for name: " + name);
/*     */     }
/*  81 */     node.getValue().jjtAccept(this, mv);
/*  82 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSingleMemberValue node, Object data)
/*     */   {
/*  87 */     if (this.base.getMemberNames().size() > 1) throw new RuntimeException("single value expected from annotation: " + this.base.getTypeName());
/*     */ 
/*  89 */     Set set = this.base.getMemberNames();
/*  90 */     MemberValue mv = this.base.getMemberValue((String)set.iterator().next());
/*  91 */     node.getValue().jjtAccept(this, mv);
/*  92 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTIdentifier node, Object data)
/*     */   {
/*  97 */     MemberValue mv = (MemberValue)data;
/*  98 */     MemberValuePopulate mvc = new MemberValuePopulate(node.getValue());
/*  99 */     mv.accept(mvc);
/* 100 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTString node, Object data)
/*     */   {
/* 105 */     StringMemberValue mv = (StringMemberValue)data;
/* 106 */     mv.setValue(node.getValue());
/* 107 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTChar node, Object data)
/*     */   {
/* 112 */     CharMemberValue mv = (CharMemberValue)data;
/* 113 */     mv.setValue(node.getValue());
/* 114 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberValueArrayInitializer node, Object data)
/*     */   {
/* 120 */     ArrayMemberValue mv = (ArrayMemberValue)data;
/* 121 */     int size = node.jjtGetNumChildren();
/* 122 */     MemberValue[] elements = new MemberValue[size];
/* 123 */     MemberValueCreation mvc = new MemberValueCreation(this.cp);
/* 124 */     for (int i = 0; i < size; i++)
/*     */     {
/* 126 */       mv.getType().accept(mvc);
/* 127 */       elements[i] = mvc.value;
/* 128 */       node.jjtGetChild(i).jjtAccept(this, elements[i]);
/*     */     }
/* 130 */     mv.setValue(elements);
/* 131 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAnnotation node, Object data)
/*     */   {
/*     */     try
/*     */     {
/* 138 */       CtClass annotation = this.pool.get(node.getIdentifier());
/* 139 */       Annotation info = new Annotation(this.cp, annotation);
/* 140 */       AnnotationInfoCreator creator = new AnnotationInfoCreator(this.pool, this.cp, info);
/* 141 */       node.childrenAccept(creator, data);
/* 142 */       AnnotationMemberValue mv = (AnnotationMemberValue)data;
/* 143 */       mv.setValue(info);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 147 */       throw new RuntimeException(e);
/*     */     }
/* 149 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(SimpleNode node, Object data)
/*     */   {
/* 156 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStart node, Object data)
/*     */   {
/* 161 */     return null;
/*     */   }
/*     */ 
/*     */   public static Annotation createAnnotationInfo(ClassPool pool, ConstPool cp, ASTAnnotation node) throws Exception
/*     */   {
/* 166 */     CtClass annotation = pool.get(node.getIdentifier());
/* 167 */     Annotation info = new Annotation(cp, annotation);
/* 168 */     AnnotationInfoCreator creator = new AnnotationInfoCreator(pool, cp, info);
/* 169 */     if (node.jjtGetNumChildren() > 0)
/*     */     {
/* 171 */       node.jjtGetChild(0).jjtAccept(creator, null);
/*     */     }
/* 173 */     return info;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.compiler.AnnotationInfoCreator
 * JD-Core Version:    0.6.0
 */