/*    */ package org.jboss.aop.annotation.compiler;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ 
/*    */ public class SecurityActions
/*    */ {
/*    */   static ClassLoader getContextClassLoader()
/*    */   {
/* 47 */     if (System.getSecurityManager() == null) {
/* 48 */       return Thread.currentThread().getContextClassLoader();
/*    */     }
/* 50 */     return (ClassLoader)AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
/*    */   }
/*    */ 
/*    */   public static class GetContextClassLoaderAction
/*    */     implements PrivilegedAction<ClassLoader>
/*    */   {
/* 37 */     public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();
/*    */ 
/*    */     public ClassLoader run()
/*    */     {
/* 41 */       return Thread.currentThread().getContextClassLoader();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.compiler.SecurityActions
 * JD-Core Version:    0.6.0
 */