/*     */ package org.jboss.aop.annotation.compiler;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import org.jboss.annotation.factory.ast.ASTAnnotation;
/*     */ import org.jboss.annotation.factory.ast.ASTChar;
/*     */ import org.jboss.annotation.factory.ast.ASTIdentifier;
/*     */ import org.jboss.annotation.factory.ast.ASTMemberValue;
/*     */ import org.jboss.annotation.factory.ast.ASTMemberValueArrayInitializer;
/*     */ import org.jboss.annotation.factory.ast.ASTMemberValuePair;
/*     */ import org.jboss.annotation.factory.ast.ASTMemberValuePairs;
/*     */ import org.jboss.annotation.factory.ast.ASTSingleMemberValue;
/*     */ import org.jboss.annotation.factory.ast.ASTStart;
/*     */ import org.jboss.annotation.factory.ast.ASTString;
/*     */ import org.jboss.annotation.factory.ast.AnnotationParserVisitor;
/*     */ import org.jboss.annotation.factory.ast.Node;
/*     */ import org.jboss.annotation.factory.ast.SimpleNode;
/*     */ 
/*     */ public class XmlAnnotationVisitor
/*     */   implements AnnotationParserVisitor
/*     */ {
/*     */   private int indent;
/*     */   PrintWriter pw;
/*     */ 
/*     */   public XmlAnnotationVisitor(int indent, PrintWriter pw)
/*     */   {
/*  52 */     this.indent = indent;
/*  53 */     this.pw = pw;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberValuePairs node, Object data)
/*     */   {
/*  58 */     node.childrenAccept(this, data);
/*  59 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberValuePair node, Object data)
/*     */   {
/*  65 */     XmlAnnotationCompiler.indenter(this.pw, this.indent);
/*  66 */     this.pw.print("<" + node.getIdentifier().getValue() + ">");
/*  67 */     node.getValue().jjtAccept(this, null);
/*  68 */     this.pw.println("</" + node.getIdentifier().getValue() + ">");
/*  69 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSingleMemberValue node, Object data)
/*     */   {
/*  74 */     XmlAnnotationCompiler.indenter(this.pw, this.indent);
/*  75 */     this.pw.print("<value>");
/*  76 */     node.getValue().jjtAccept(this, null);
/*  77 */     this.pw.println("</value>");
/*  78 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAnnotation node, Object data)
/*     */   {
/*  83 */     this.pw.println("");
/*  84 */     this.indent += 1;
/*  85 */     XmlAnnotationCompiler.indenter(this.pw, this.indent);
/*  86 */     this.pw.println("<annotation tag=\"" + node.getIdentifier() + "\">");
/*  87 */     this.indent += 1;
/*  88 */     node.childrenAccept(this, data);
/*  89 */     this.indent -= 1;
/*  90 */     XmlAnnotationCompiler.indenter(this.pw, this.indent);
/*  91 */     this.pw.println("</annotation>");
/*  92 */     this.indent -= 1;
/*  93 */     XmlAnnotationCompiler.indenter(this.pw, this.indent);
/*  94 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMemberValueArrayInitializer node, Object data)
/*     */   {
/*  99 */     this.pw.println("");
/* 100 */     this.indent += 1;
/* 101 */     XmlAnnotationCompiler.indenter(this.pw, this.indent);
/* 102 */     this.pw.println("<array>");
/* 103 */     this.indent += 1;
/* 104 */     int size = node.jjtGetNumChildren();
/* 105 */     for (int i = 0; i < size; i++)
/*     */     {
/* 107 */       XmlAnnotationCompiler.indenter(this.pw, this.indent);
/* 108 */       this.pw.print("<value>");
/* 109 */       node.jjtGetChild(i).jjtAccept(this, null);
/* 110 */       this.pw.println("</value>");
/*     */     }
/* 112 */     this.indent -= 1;
/* 113 */     XmlAnnotationCompiler.indenter(this.pw, this.indent);
/* 114 */     this.pw.println("</array>");
/* 115 */     this.indent -= 1;
/* 116 */     XmlAnnotationCompiler.indenter(this.pw, this.indent);
/* 117 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTIdentifier node, Object data)
/*     */   {
/* 122 */     this.pw.print(node.getValue());
/* 123 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTString node, Object data)
/*     */   {
/* 128 */     this.pw.print(node.getValue());
/* 129 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTChar node, Object data)
/*     */   {
/* 134 */     this.pw.print(node.getValue());
/* 135 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(SimpleNode node, Object data) {
/* 139 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTStart node, Object data)
/*     */   {
/* 144 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.compiler.XmlAnnotationVisitor
 * JD-Core Version:    0.6.0
 */