/*     */ package org.jboss.aop.ant;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.util.ArrayList;
/*     */ import org.apache.tools.ant.BuildException;
/*     */ import org.apache.tools.ant.DirectoryScanner;
/*     */ import org.apache.tools.ant.Project;
/*     */ import org.apache.tools.ant.taskdefs.Java;
/*     */ import org.apache.tools.ant.taskdefs.MatchingTask;
/*     */ import org.apache.tools.ant.types.Commandline;
/*     */ import org.apache.tools.ant.types.Commandline.Argument;
/*     */ import org.apache.tools.ant.types.CommandlineJava;
/*     */ import org.apache.tools.ant.types.Path;
/*     */ import org.apache.tools.ant.types.Reference;
/*     */ 
/*     */ public class AnnotationC extends MatchingTask
/*     */ {
/*  46 */   private static String lSep = System.getProperty("line.separator");
/*     */   private Path classpath;
/*     */   private Path output;
/*     */   private Path compilerClasspath;
/*     */   private Path compileSourcepath;
/*  52 */   boolean xml = false;
/*  53 */   boolean bytecode = false;
/*     */ 
/*  58 */   protected boolean failOnError = true;
/*     */ 
/*     */   public void setXml(boolean i)
/*     */   {
/*  62 */     this.xml = i;
/*     */   }
/*     */ 
/*     */   public boolean getXml()
/*     */   {
/*  67 */     return this.xml;
/*     */   }
/*     */ 
/*     */   public void setBytecode(boolean i)
/*     */   {
/*  72 */     this.bytecode = i;
/*     */   }
/*     */ 
/*     */   public boolean getBytecode()
/*     */   {
/*  77 */     return this.xml;
/*     */   }
/*     */ 
/*     */   public void setFailonerror(boolean fail)
/*     */   {
/*  86 */     this.failOnError = fail;
/*     */   }
/*     */ 
/*     */   public boolean getFailonerror()
/*     */   {
/*  94 */     return this.failOnError;
/*     */   }
/*     */ 
/*     */   public void setClasspath(Path cp)
/*     */   {
/* 102 */     if (this.classpath == null)
/*     */     {
/* 104 */       this.classpath = cp;
/*     */     }
/*     */     else
/*     */     {
/* 108 */       this.classpath.append(cp);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Path createClasspath()
/*     */   {
/* 117 */     if (this.classpath == null)
/*     */     {
/* 119 */       this.classpath = new Path(getProject());
/*     */     }
/* 121 */     return this.classpath.createPath();
/*     */   }
/*     */ 
/*     */   public void setClasspathRef(Reference r)
/*     */   {
/* 129 */     createClasspath().setRefid(r);
/*     */   }
/*     */ 
/*     */   public Path getClasspath()
/*     */   {
/* 134 */     return this.classpath;
/*     */   }
/*     */ 
/*     */   public void setCompilerClasspathRef(Reference r)
/*     */   {
/* 142 */     if (this.compilerClasspath == null) this.compilerClasspath = new Path(getProject());
/* 143 */     this.compilerClasspath.setRefid(r);
/*     */   }
/*     */ 
/*     */   public void setCompilerclasspath(Path cp)
/*     */   {
/* 151 */     if (this.compilerClasspath == null)
/*     */     {
/* 153 */       this.compilerClasspath = cp;
/*     */     }
/*     */     else
/*     */     {
/* 157 */       this.compilerClasspath.append(cp);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Path getCompilerclasspath()
/*     */   {
/* 166 */     return this.compilerClasspath;
/*     */   }
/*     */ 
/*     */   public Path createCompilerclasspath()
/*     */   {
/* 174 */     if (this.compilerClasspath == null)
/*     */     {
/* 176 */       this.compilerClasspath = new Path(getProject());
/*     */     }
/* 178 */     return this.compilerClasspath.createPath();
/*     */   }
/*     */ 
/*     */   public Path createSrc()
/*     */   {
/* 188 */     if (this.compileSourcepath == null)
/*     */     {
/* 190 */       this.compileSourcepath = new Path(getProject());
/*     */     }
/* 192 */     return this.compileSourcepath.createPath();
/*     */   }
/*     */ 
/*     */   public Path createOutput()
/*     */   {
/* 197 */     if (this.output == null)
/*     */     {
/* 199 */       this.output = new Path(getProject());
/*     */     }
/* 201 */     return this.output.createPath();
/*     */   }
/*     */ 
/*     */   public void setOutput(Path cp)
/*     */   {
/* 209 */     if (this.output == null)
/*     */     {
/* 211 */       this.output = cp;
/*     */     }
/*     */     else
/*     */     {
/* 215 */       this.output.append(cp);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Path getOutput()
/*     */   {
/* 224 */     return this.output;
/*     */   }
/*     */ 
/*     */   public void execute()
/*     */     throws BuildException
/*     */   {
/* 230 */     CommandlineJava cmd = new CommandlineJava();
/*     */ 
/* 232 */     if (this.output != null)
/*     */     {
/* 234 */       cmd.createArgument().setValue("-o");
/* 235 */       cmd.createArgument().setValue(this.output.toString());
/*     */     }
/* 237 */     if (this.xml)
/*     */     {
/* 239 */       cmd.createArgument().setValue("-xml");
/*     */     }
/* 241 */     if (this.bytecode)
/*     */     {
/* 243 */       cmd.createArgument().setValue("-bytecode");
/*     */     }
/* 245 */     logAndAddFilesToCompile(cmd);
/*     */     try
/*     */     {
/* 250 */       this.classpath.append(this.compilerClasspath);
/* 251 */       Java java = (Java)(Java)getProject().createTask("java");
/* 252 */       if (getClasspath() != null)
/*     */       {
/* 254 */         getProject().log("using user supplied classpath: " + getClasspath(), 4);
/*     */ 
/* 256 */         java.setClasspath(getClasspath().concatSystemClasspath("ignore"));
/*     */       }
/*     */       else
/*     */       {
/* 261 */         Path classpath = new Path(getProject());
/* 262 */         classpath = classpath.concatSystemClasspath("only");
/* 263 */         getProject().log("using system classpath: " + classpath, 4);
/*     */ 
/* 265 */         java.setClasspath(classpath);
/*     */       }
/* 267 */       java.setDir(getProject().getBaseDir());
/* 268 */       java.setClassname("org.jboss.aop.annotation.compiler.AnnotationCompiler");
/*     */ 
/* 270 */       String[] args = cmd.getJavaCommand().getArguments();
/* 271 */       for (int i = 0; i < args.length; i++)
/*     */       {
/* 273 */         java.createArg().setValue(args[i]);
/*     */       }
/* 275 */       java.setFailonerror(getFailonerror());
/*     */ 
/* 278 */       java.setFork(false);
/* 279 */       java.setTaskName("annotationc");
/* 280 */       java.execute();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 284 */       if ((ex instanceof BuildException))
/*     */       {
/* 286 */         throw ((BuildException)ex);
/*     */       }
/*     */ 
/* 290 */       throw new BuildException("Error running aopc compiler: ", ex, getLocation());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void logAndAddFilesToCompile(CommandlineJava cmd)
/*     */   {
/* 300 */     String[] list = this.compileSourcepath.list();
/*     */ 
/* 302 */     ArrayList compilingFiles = new ArrayList();
/* 303 */     for (int i = 0; i < list.length; i++)
/*     */     {
/* 305 */       File srcDir = getProject().resolveFile(list[i]);
/* 306 */       if (!srcDir.exists())
/*     */       {
/* 308 */         throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", getLocation());
/*     */       }
/*     */ 
/* 313 */       DirectoryScanner ds = getDirectoryScanner(srcDir);
/* 314 */       String[] files = ds.getIncludedFiles();
/* 315 */       for (int j = 0; j < files.length; j++)
/*     */       {
/* 317 */         if (!files[j].endsWith(".java"))
/*     */           continue;
/* 319 */         File f = new File(srcDir, files[j]);
/* 320 */         compilingFiles.add(f.getAbsolutePath());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 326 */     StringBuffer niceSourceList = new StringBuffer("File");
/* 327 */     for (int i = 0; i < compilingFiles.size(); i++)
/*     */     {
/* 329 */       String file = (String)compilingFiles.get(i);
/* 330 */       cmd.createArgument().setValue(file);
/* 331 */       niceSourceList.append("    " + file + lSep);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ant.AnnotationC
 * JD-Core Version:    0.6.0
 */