/*     */ package org.jboss.aop.ant;
/*     */ 
/*     */ import java.io.BufferedWriter;
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import org.apache.tools.ant.BuildException;
/*     */ import org.apache.tools.ant.DirectoryScanner;
/*     */ import org.apache.tools.ant.Project;
/*     */ import org.apache.tools.ant.taskdefs.Java;
/*     */ import org.apache.tools.ant.taskdefs.MatchingTask;
/*     */ import org.apache.tools.ant.types.Commandline;
/*     */ import org.apache.tools.ant.types.Commandline.Argument;
/*     */ import org.apache.tools.ant.types.CommandlineJava;
/*     */ import org.apache.tools.ant.types.Environment.Variable;
/*     */ import org.apache.tools.ant.types.Path;
/*     */ import org.apache.tools.ant.types.Reference;
/*     */ 
/*     */ public class AopC extends MatchingTask
/*     */ {
/*     */   static final String SYS_OPTIMIZED = "jboss.aop.optimized";
/*     */   static final String SYS_INSTRUMENTOR = "jboss.aop.instrumentor";
/*  53 */   private static String lSep = System.getProperty("line.separator");
/*  54 */   private int maxSrc = 1000;
/*     */   private String instrumentor;
/*     */   private String jvm;
/*     */   private Path classpath;
/*     */   private Path aoppath;
/*     */   private Path aopclasspath;
/*     */   private Path compilerClasspath;
/*     */   private Path compileSourcepath;
/*  63 */   private boolean verbose = false;
/*  64 */   private boolean suppress = true;
/*  65 */   private boolean report = false;
/*  66 */   private boolean optimized = true;
/*  67 */   private String maxmemory = null;
/*  68 */   ArrayList sysproperties = new ArrayList();
/*     */   File sourceFiles;
/*  74 */   protected boolean failOnError = true;
/*     */ 
/*     */   public void setVerbose(boolean i)
/*     */   {
/*  81 */     this.verbose = i;
/*     */   }
/*     */ 
/*     */   public boolean getVerbose()
/*     */   {
/*  86 */     return this.verbose;
/*     */   }
/*     */ 
/*     */   public String getInstrumentor()
/*     */   {
/*  91 */     return this.instrumentor;
/*     */   }
/*     */ 
/*     */   public void setInstrumentor(String instrumentor)
/*     */   {
/*  96 */     this.instrumentor = instrumentor;
/*     */   }
/*     */ 
/*     */   public void setSuppress(boolean i)
/*     */   {
/* 104 */     this.suppress = i;
/*     */   }
/*     */ 
/*     */   public boolean getSupress()
/*     */   {
/* 109 */     return this.suppress;
/*     */   }
/*     */ 
/*     */   public void setReport(boolean i)
/*     */   {
/* 114 */     this.report = i;
/*     */   }
/*     */ 
/*     */   public boolean getReport()
/*     */   {
/* 119 */     return this.report;
/*     */   }
/*     */ 
/*     */   public String getJvm()
/*     */   {
/* 124 */     return this.jvm;
/*     */   }
/*     */ 
/*     */   public void setJvm(String jvm)
/*     */   {
/* 129 */     this.jvm = jvm;
/*     */   }
/*     */ 
/*     */   public void setOptimized(boolean optimized)
/*     */   {
/* 134 */     this.optimized = optimized;
/*     */   }
/*     */ 
/*     */   public boolean getOptimized()
/*     */   {
/* 139 */     return this.optimized;
/*     */   }
/*     */ 
/*     */   public void setMaxmemory(String maxmemory)
/*     */   {
/* 147 */     this.maxmemory = maxmemory;
/*     */   }
/*     */ 
/*     */   public String getMaxmemory()
/*     */   {
/* 152 */     return this.maxmemory;
/*     */   }
/*     */ 
/*     */   public void setFailonerror(boolean fail)
/*     */   {
/* 162 */     this.failOnError = fail;
/*     */   }
/*     */ 
/*     */   public boolean getFailonerror()
/*     */   {
/* 170 */     return this.failOnError;
/*     */   }
/*     */ 
/*     */   public void setClasspath(Path cp)
/*     */   {
/* 178 */     if (this.classpath == null)
/*     */     {
/* 180 */       this.classpath = cp;
/*     */     }
/*     */     else
/*     */     {
/* 184 */       this.classpath.append(cp);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMaxSrc(int maxSrc)
/*     */   {
/* 190 */     this.maxSrc = maxSrc;
/*     */   }
/*     */ 
/*     */   public int getMaxSrc()
/*     */   {
/* 195 */     return this.maxSrc;
/*     */   }
/*     */ 
/*     */   public Path createClasspath()
/*     */   {
/* 203 */     if (this.classpath == null)
/*     */     {
/* 205 */       this.classpath = new Path(getProject());
/*     */     }
/* 207 */     return this.classpath.createPath();
/*     */   }
/*     */ 
/*     */   public void setClasspathRef(Reference r)
/*     */   {
/* 215 */     createClasspath().setRefid(r);
/*     */   }
/*     */ 
/*     */   public Path getClasspath()
/*     */   {
/* 220 */     return this.classpath;
/*     */   }
/*     */ 
/*     */   public void setCompilerClasspathRef(Reference r)
/*     */   {
/* 228 */     if (this.compilerClasspath == null) this.compilerClasspath = new Path(getProject());
/* 229 */     this.compilerClasspath.setRefid(r);
/*     */   }
/*     */ 
/*     */   public void setCompilerclasspath(Path cp)
/*     */   {
/* 237 */     if (this.compilerClasspath == null)
/*     */     {
/* 239 */       this.compilerClasspath = cp;
/*     */     }
/*     */     else
/*     */     {
/* 243 */       this.compilerClasspath.append(cp);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Path getCompilerclasspath()
/*     */   {
/* 252 */     return this.compilerClasspath;
/*     */   }
/*     */ 
/*     */   public Path createCompilerclasspath()
/*     */   {
/* 260 */     if (this.compilerClasspath == null)
/*     */     {
/* 262 */       this.compilerClasspath = new Path(getProject());
/*     */     }
/* 264 */     return this.compilerClasspath.createPath();
/*     */   }
/*     */ 
/*     */   public Path createSrc()
/*     */   {
/* 274 */     if (this.compileSourcepath == null)
/*     */     {
/* 276 */       this.compileSourcepath = new Path(getProject());
/*     */     }
/* 278 */     return this.compileSourcepath.createPath();
/*     */   }
/*     */ 
/*     */   public Path createAoppath()
/*     */   {
/* 283 */     if (this.aoppath == null)
/*     */     {
/* 285 */       this.aoppath = new Path(getProject());
/*     */     }
/*     */ 
/* 288 */     Path path = this.aoppath.createPath();
/* 289 */     return path;
/*     */   }
/*     */ 
/*     */   public Path createAopclasspath()
/*     */   {
/* 294 */     if (this.aopclasspath == null)
/*     */     {
/* 296 */       this.aopclasspath = new Path(getProject());
/*     */     }
/* 298 */     return this.aopclasspath.createPath();
/*     */   }
/*     */ 
/*     */   public void addSysproperty(Environment.Variable property)
/*     */   {
/* 303 */     this.sysproperties.add(property);
/*     */   }
/*     */ 
/*     */   public void execute()
/*     */     throws BuildException
/*     */   {
/* 309 */     CommandlineJava cmd = new CommandlineJava();
/*     */ 
/* 311 */     if (this.verbose)
/* 312 */       cmd.createArgument().setValue("-verbose");
/* 313 */     if (this.suppress)
/* 314 */       cmd.createArgument().setValue("-suppress");
/* 315 */     if (!this.optimized)
/* 316 */       cmd.createArgument().setValue("-noopt");
/* 317 */     if (this.report)
/* 318 */       cmd.createArgument().setValue("-report");
/* 319 */     if ((this.aoppath != null) && (this.aoppath.size() > 0))
/*     */     {
/* 321 */       cmd.createArgument().setValue("-aoppath");
/* 322 */       cmd.createArgument().setValue(this.aoppath.toString());
/*     */     }
/* 324 */     if ((this.aopclasspath != null) && (this.aopclasspath.size() > 0))
/*     */     {
/* 326 */       cmd.createArgument().setValue("-aopclasspath");
/* 327 */       cmd.createArgument().setValue(this.aopclasspath.toString());
/*     */     }
/* 329 */     logAndAddFilesToCompile(cmd);
/*     */     try
/*     */     {
/* 335 */       this.classpath.append(this.compilerClasspath);
/* 336 */       Java java = (Java)(Java)getProject().createTask("java");
/* 337 */       if ((this.jvm != null) && (this.jvm.length() > 0))
/*     */       {
/* 339 */         java.setJvm(this.jvm);
/*     */       }
/* 341 */       if (getClasspath() != null)
/*     */       {
/* 343 */         getProject().log("using user supplied classpath: " + getClasspath(), 4);
/*     */ 
/* 345 */         java.setClasspath(getClasspath().concatSystemClasspath("ignore"));
/*     */       }
/*     */       else
/*     */       {
/* 350 */         Path classpath = new Path(getProject());
/* 351 */         classpath = classpath.concatSystemClasspath("only");
/* 352 */         getProject().log("using system classpath: " + classpath, 4);
/*     */ 
/* 354 */         java.setClasspath(classpath);
/*     */       }
/* 356 */       java.setDir(getProject().getBaseDir());
/* 357 */       java.setClassname("org.jboss.aop.standalone.Compiler");
/*     */ 
/* 359 */       String[] args = cmd.getJavaCommand().getArguments();
/* 360 */       for (int i = 0; i < args.length; i++)
/*     */       {
/* 362 */         java.createArg().setValue(args[i]);
/*     */       }
/* 364 */       java.setFailonerror(getFailonerror());
/*     */ 
/* 367 */       java.setFork(true);
/* 368 */       java.setTaskName("aopc");
/*     */ 
/* 370 */       Environment.Variable optimize = new Environment.Variable();
/* 371 */       optimize.setKey("jboss.aop.optimized");
/* 372 */       optimize.setValue(String.valueOf(this.optimized));
/* 373 */       java.addSysproperty(optimize);
/*     */ 
/* 375 */       for (Iterator it = this.sysproperties.iterator(); it.hasNext(); )
/*     */       {
/* 377 */         Environment.Variable var = (Environment.Variable)it.next();
/* 378 */         java.addSysproperty(var);
/*     */       }
/*     */ 
/* 381 */       if (this.maxmemory != null)
/*     */       {
/* 383 */         java.setMaxmemory(this.maxmemory);
/*     */       }
/* 385 */       java.execute();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 389 */       if ((ex instanceof BuildException))
/*     */       {
/* 391 */         throw ((BuildException)ex);
/*     */       }
/*     */ 
/* 395 */       throw new BuildException("Error running aopc compiler: ", ex, getLocation());
/*     */     }
/*     */     finally
/*     */     {
/* 401 */       if (this.sourceFiles != null)
/*     */       {
/* 404 */         this.sourceFiles.delete();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void logAndAddFilesToCompile(CommandlineJava cmd)
/*     */   {
/* 413 */     String[] list = this.compileSourcepath.list();
/* 414 */     ArrayList compilingFiles = new ArrayList();
/* 415 */     for (int i = 0; i < list.length; i++)
/*     */     {
/* 417 */       File srcDir = getProject().resolveFile(list[i]);
/* 418 */       if (!srcDir.exists())
/*     */       {
/* 420 */         throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", getLocation());
/*     */       }
/*     */ 
/* 425 */       DirectoryScanner ds = getDirectoryScanner(srcDir);
/* 426 */       String[] files = ds.getIncludedFiles();
/* 427 */       for (int j = 0; j < files.length; j++)
/*     */       {
/* 429 */         if (!files[j].endsWith(".class"))
/*     */           continue;
/* 431 */         File f = new File(srcDir, files[j]);
/* 432 */         compilingFiles.add(f.getAbsolutePath());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 437 */     int length = 0;
/* 438 */     for (int i = 0; i < compilingFiles.size(); i++)
/*     */     {
/* 441 */       length += ((String)compilingFiles.get(i)).length() + 1;
/*     */ 
/* 443 */       if (length > this.maxSrc)
/*     */       {
/*     */         break;
/*     */       }
/*     */     }
/*     */ 
/* 449 */     if (length < this.maxSrc)
/*     */     {
/* 451 */       StringBuffer niceSourceList = new StringBuffer("Files\n");
/* 452 */       for (int i = 0; i < compilingFiles.size(); i++)
/*     */       {
/* 454 */         String file = (String)compilingFiles.get(i);
/* 455 */         cmd.createArgument().setValue(file);
/* 456 */         niceSourceList.append("    " + file + lSep);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 461 */       for (Iterator it = this.sysproperties.iterator(); it.hasNext(); )
/*     */       {
/* 463 */         Environment.Variable var = (Environment.Variable)it.next();
/* 464 */         if (var.getKey().equals("java.io.tmpdir"))
/*     */         {
/* 466 */           System.setProperty("java.io.tmpdir", var.getValue());
/*     */         }
/*     */       }
/* 469 */       BufferedWriter writer = null;
/*     */       try
/*     */       {
/* 472 */         this.sourceFiles = File.createTempFile("src", ".tmp");
/* 473 */         if (this.verbose)
/*     */         {
/* 475 */           System.out.println("[info] Total length of filenames to be compiled is greater than " + this.maxSrc + ", listing files in --SOURCEPATH: " + this.sourceFiles.getAbsolutePath());
/*     */         }
/*     */ 
/* 479 */         this.sourceFiles.deleteOnExit();
/* 480 */         writer = new BufferedWriter(new FileWriter(this.sourceFiles));
/*     */ 
/* 482 */         for (int i = 0; i < compilingFiles.size(); i++)
/*     */         {
/* 484 */           writer.write((String)compilingFiles.get(i));
/* 485 */           writer.newLine();
/*     */         }
/* 487 */         writer.flush();
/* 488 */         cmd.createArgument().setValue("--SOURCEPATH");
/* 489 */         cmd.createArgument().setValue(this.sourceFiles.getAbsolutePath());
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 493 */         if (writer != null)
/*     */         {
/*     */           try
/*     */           {
/* 497 */             writer.close();
/*     */           }
/*     */           catch (IOException e1)
/*     */           {
/*     */           }
/*     */         }
/* 503 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.ant.AopC
 * JD-Core Version:    0.6.0
 */