/*     */ package org.jboss.aop.array;
/*     */ 
/*     */ import javassist.CtClass;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.TypeMatcher;
/*     */ import org.jboss.aop.pointcut.Util;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ 
/*     */ public class ArrayReplacement
/*     */ {
/*     */   private String name;
/*     */   protected ClassExpression classExpr;
/*     */   protected ASTStart ast;
/*     */ 
/*     */   public ArrayReplacement(String name, String exp)
/*     */   {
/*  45 */     this.name = name;
/*  46 */     this.classExpr = new ClassExpression(exp);
/*     */   }
/*     */ 
/*     */   public ArrayReplacement(String name, ASTStart ast)
/*     */   {
/*  51 */     this.name = name;
/*  52 */     this.ast = ast;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  57 */     if (obj == this) return true;
/*  58 */     if (!(obj instanceof ArrayReplacement)) return false;
/*  59 */     return ((ArrayReplacement)obj).getName().equals(this.name);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  64 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  69 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getClassExpr()
/*     */   {
/*  74 */     if (this.classExpr == null) return null;
/*  75 */     return this.classExpr.getOriginal();
/*     */   }
/*     */ 
/*     */   public ASTStart getAst()
/*     */   {
/*  80 */     return this.ast;
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, CtClass clazz) throws Exception
/*     */   {
/*  85 */     if (this.classExpr != null) {
/*  86 */       return Util.matchesClassExpr(this.classExpr, clazz, advisor);
/*     */     }
/*     */ 
/*  89 */     TypeMatcher matcher = new TypeMatcher(advisor, clazz);
/*  90 */     return ((Boolean)this.ast.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, Class clazz)
/*     */   {
/*  96 */     if (this.classExpr != null) {
/*  97 */       return Util.matchesClassExpr(this.classExpr, clazz, advisor);
/*     */     }
/*     */ 
/* 100 */     TypeMatcher matcher = new TypeMatcher(advisor, clazz);
/* 101 */     return ((Boolean)this.ast.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.array.ArrayReplacement
 * JD-Core Version:    0.6.0
 */