/*     */ package org.jboss.aop.asintegration.jboss4;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.net.URL;
/*     */ import java.security.ProtectionDomain;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.scopedpool.ScopedClassPoolRepository;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ 
/*     */ public class JBossClassPool extends AOPClassPool
/*     */ {
/*  48 */   protected File tempdir = null;
/*  49 */   protected URL tempURL = null;
/*     */ 
/*  51 */   protected final Object tmplock = new Object();
/*     */ 
/*     */   protected JBossClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, File tmp, URL tmpURL)
/*     */   {
/*  55 */     super(cl, src, repository);
/*  56 */     this.tempdir = tmp;
/*  57 */     this.tempURL = tmpURL;
/*     */   }
/*     */ 
/*     */   protected JBossClassPool(ClassPool src, ScopedClassPoolRepository repository)
/*     */   {
/*  62 */     super(src, repository);
/*     */   }
/*     */ 
/*     */   public boolean isUnloadedClassLoader()
/*     */   {
/*  67 */     if ((getClassLoader() instanceof RepositoryClassLoader))
/*     */     {
/*  69 */       RepositoryClassLoader rcl = (RepositoryClassLoader)getClassLoader();
/*  70 */       return rcl.getLoaderRepository() == null;
/*     */     }
/*  72 */     return false;
/*     */   }
/*     */ 
/*     */   public Class toClass(CtClass cc, ClassLoader loader, ProtectionDomain domain)
/*     */     throws CannotCompileException
/*     */   {
/*  78 */     lockInCache(cc);
/*  79 */     if ((getClassLoader() == null) || (this.tempdir == null))
/*     */     {
/*  81 */       return super.toClass(cc, loader, domain);
/*     */     }
/*  83 */     Class dynClass = null;
/*     */     try
/*     */     {
/*  86 */       File classFile = null;
/*  87 */       String classFileName = getResourceName(cc.getName());
/*     */ 
/*  89 */       synchronized (this.tmplock)
/*     */       {
/*  91 */         classFile = new File(this.tempdir, classFileName);
/*  92 */         File pkgDirs = classFile.getParentFile();
/*  93 */         pkgDirs.mkdirs();
/*  94 */         FileOutputStream stream = new FileOutputStream(classFile);
/*  95 */         stream.write(cc.toBytecode());
/*  96 */         stream.flush();
/*  97 */         stream.close();
/*  98 */         classFile.deleteOnExit();
/*     */       }
/*     */ 
/* 104 */       RepositoryClassLoader rcl = (RepositoryClassLoader)getClassLoader();
/* 105 */       rcl.clearClassBlackList();
/* 106 */       rcl.clearResourceBlackList();
/*     */ 
/* 109 */       dynClass = getClassLoader().loadClass(cc.getName());
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 113 */       ClassFormatError cfe = new ClassFormatError("Failed to load dyn class: " + cc.getName());
/* 114 */       cfe.initCause(ex);
/* 115 */       throw cfe;
/*     */     }
/*     */ 
/* 118 */     return dynClass;
/*     */   }
/*     */ 
/*     */   protected boolean isLocalResource(String resourceName)
/*     */   {
/* 123 */     if (super.isLocalResource(resourceName))
/*     */     {
/* 125 */       return true;
/*     */     }
/*     */ 
/* 128 */     File file = new File(this.tempdir, resourceName);
/*     */ 
/* 131 */     return file.exists();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.asintegration.jboss4.JBossClassPool
 * JD-Core Version:    0.6.0
 */