/*     */ package org.jboss.aop.asintegration.jboss4;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.scopedpool.ScopedClassPoolRepository;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.classpool.AOPClassPoolRepository;
/*     */ import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
/*     */ import org.jboss.mx.loading.LoaderRepository;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ 
/*     */ public class ScopedJBossClassPool extends JBossClassPool
/*     */ {
/*  51 */   static final LoaderRepositoryUrlUtil LOADER_REPOSITORY_UTIL = new LoaderRepositoryUrlUtil();
/*     */ 
/*  53 */   WeakReference repository = null;
/*     */   LoaderRepositoryUrlUtil.UrlInfo urlInfo;
/*  55 */   ThreadLocal lastPool = new ThreadLocal();
/*     */ 
/*     */   public ScopedJBossClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, File tmp, URL tmpURL)
/*     */   {
/*  59 */     super(cl, src, repository, tmp, tmpURL);
/*     */ 
/*  61 */     boolean parentFirst = false;
/*  62 */     LoaderRepository loaderRepository = null;
/*  63 */     ClassLoader prnt = cl;
/*  64 */     while (prnt != null)
/*     */     {
/*  66 */       if ((prnt instanceof RepositoryClassLoader))
/*     */       {
/*  68 */         loaderRepository = ((RepositoryClassLoader)prnt).getLoaderRepository();
/*  69 */         if (!(loaderRepository instanceof HeirarchicalLoaderRepository3))
/*     */           break;
/*  71 */         parentFirst = ((HeirarchicalLoaderRepository3)loaderRepository).getUseParentFirst(); break;
/*     */       }
/*     */ 
/*  75 */       prnt = SecurityActions.getParent(cl);
/*     */     }
/*     */ 
/*  78 */     this.childFirstLookup = (!parentFirst);
/*     */   }
/*     */ 
/*     */   private HeirarchicalLoaderRepository3 getRepository()
/*     */   {
/*  84 */     ClassLoader cl = getClassLoader0();
/*  85 */     if (cl != null)
/*     */     {
/*  87 */       return (HeirarchicalLoaderRepository3)((RepositoryClassLoader)cl).getLoaderRepository();
/*     */     }
/*  89 */     return null;
/*     */   }
/*     */ 
/*     */   private URL getResourceUrlForClass(String resourcename)
/*     */   {
/*  94 */     HeirarchicalLoaderRepository3 repo = getRepository();
/*  95 */     return repo.getResource(resourcename, super.getClassLoader());
/*     */   }
/*     */ 
/*     */   private boolean isMine(URL url)
/*     */   {
/* 100 */     HeirarchicalLoaderRepository3 repo = getRepository();
/* 101 */     if (repo != null)
/*     */     {
/* 104 */       if (url != null)
/*     */       {
/* 106 */         this.urlInfo = LOADER_REPOSITORY_UTIL.getURLInfo(getRepository(), this.urlInfo);
/*     */ 
/* 108 */         URL[] myUrls = this.urlInfo.getLocalUrls();
/* 109 */         String resource = url.toString();
/* 110 */         for (int i = 0; i < myUrls.length; i++)
/*     */         {
/* 112 */           if (resource.indexOf(myUrls[i].toString()) >= 0)
/*     */           {
/* 114 */             return true;
/*     */           }
/*     */         }
/* 117 */         return false;
/*     */       }
/*     */     }
/* 120 */     return true;
/*     */   }
/*     */ 
/*     */   public CtClass getCached(String classname)
/*     */   {
/* 125 */     if (classname == null)
/*     */     {
/* 127 */       return null;
/*     */     }
/* 129 */     if (isUnloadedClassLoader())
/*     */     {
/* 131 */       return null;
/*     */     }
/*     */ 
/* 134 */     if (this.generatedClasses.get(classname) != null)
/*     */     {
/* 137 */       return super.getCached(classname);
/*     */     }
/*     */ 
/* 141 */     String resourcename = getResourceName(classname);
/* 142 */     URL url = getResourceUrlForClass(resourcename);
/* 143 */     boolean isMine = isMine(url);
/*     */ 
/* 145 */     if (isMine)
/*     */     {
/* 147 */       if (this.childFirstLookup)
/*     */       {
/* 150 */         CtClass clazz = super.getCachedLocally(classname);
/* 151 */         if (clazz == null)
/*     */         {
/* 153 */           clazz = createCtClass(classname, false);
/* 154 */           if (clazz != null)
/*     */           {
/* 156 */             lockInCache(clazz);
/*     */           }
/*     */         }
/* 159 */         if (clazz != null)
/*     */         {
/* 161 */           return clazz;
/*     */         }
/*     */       }
/* 164 */       return super.getCached(classname);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 170 */       ClassPool pool = getCorrectPoolForResource(classname, url);
/* 171 */       if (pool != this.lastPool.get())
/*     */       {
/* 173 */         this.lastPool.set(pool);
/* 174 */         CtClass localCtClass1 = pool.get(classname);
/*     */         return localCtClass1;
/*     */       }
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*     */     }
/*     */     catch (StackOverflowError e)
/*     */     {
/* 182 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 186 */       this.lastPool.set(null);
/*     */     }
/*     */ 
/* 189 */     return null;
/*     */   }
/*     */ 
/*     */   protected boolean includeInGlobalSearch()
/*     */   {
/* 195 */     return false;
/*     */   }
/*     */ 
/*     */   private ClassPool getCorrectPoolForResource(String classname, URL url)
/*     */   {
/*     */     Iterator it;
/* 200 */     synchronized (AspectManager.getRegisteredCLs())
/*     */     {
/* 204 */       ArrayList noAnnotationURLClassLoaderPools = null;
/* 205 */       String resource = url.toString();
/* 206 */       for (Iterator it = AspectManager.getRegisteredCLs().values().iterator(); it.hasNext(); )
/*     */       {
/* 208 */         AOPClassPool candidate = (AOPClassPool)it.next();
/* 209 */         if (candidate.isUnloadedClassLoader())
/*     */         {
/* 211 */           AspectManager.instance().unregisterClassLoader(candidate.getClassLoader());
/* 212 */           continue;
/*     */         }
/*     */ 
/* 215 */         if ((candidate.getClassLoader() instanceof RepositoryClassLoader))
/*     */         {
/* 218 */           RepositoryClassLoader rcl = (RepositoryClassLoader)candidate.getClassLoader();
/* 219 */           URL[] urls = rcl.getClasspath();
/*     */ 
/* 221 */           for (int i = 0; i < urls.length; i++)
/*     */           {
/* 223 */             if (resource.indexOf(urls[i].getFile()) >= 0)
/*     */             {
/* 225 */               return candidate;
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/* 230 */         else if (isInstanceOfNoAnnotationURLClassLoader(candidate.getClassLoader()))
/*     */         {
/* 232 */           if (noAnnotationURLClassLoaderPools == null)
/*     */           {
/* 234 */             noAnnotationURLClassLoaderPools = new ArrayList();
/*     */           }
/* 236 */           noAnnotationURLClassLoaderPools.add(candidate);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 241 */       if (noAnnotationURLClassLoaderPools != null)
/*     */       {
/* 243 */         for (it = noAnnotationURLClassLoaderPools.iterator(); it.hasNext(); )
/*     */         {
/* 245 */           ClassPool pool = (ClassPool)it.next();
/*     */           try
/*     */           {
/* 249 */             pool.get(classname);
/* 250 */             return pool;
/*     */           }
/*     */           catch (NotFoundException ignoreTryNext)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 259 */     return AOPClassPool.createAOPClassPool(ClassPool.getDefault(), AOPClassPoolRepository.getInstance());
/*     */   }
/*     */ 
/*     */   private boolean isInstanceOfNoAnnotationURLClassLoader(ClassLoader loader)
/*     */   {
/* 267 */     Class parent = loader.getClass();
/* 268 */     while (parent != null)
/*     */     {
/* 270 */       if ("NoAnnotationURLClassLoader".equals(parent.getSimpleName()))
/*     */       {
/* 272 */         return true;
/*     */       }
/* 274 */       parent = parent.getSuperclass();
/*     */     }
/* 276 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.asintegration.jboss4.ScopedJBossClassPool
 * JD-Core Version:    0.6.0
 */