/*     */ package org.jboss.aop.deployment;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import javassist.scopedpool.ScopedClassPoolFactory;
/*     */ import javax.management.Notification;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.AspectNotificationHandler;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.aop.ClassLoaderValidation;
/*     */ import org.jboss.aop.ClassicWeavingStrategy;
/*     */ import org.jboss.aop.SuperClassesFirstWeavingStrategy;
/*     */ import org.jboss.aop.asintegration.JBossIntegration;
/*     */ import org.jboss.aop.asintegration.jboss4.JBoss4Integration;
/*     */ import org.jboss.aop.hook.JDK14Transformer;
/*     */ import org.jboss.aop.instrument.InstrumentorFactory;
/*     */ import org.jboss.aop.instrument.TransformerCommon;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class AspectManagerService extends ServiceMBeanSupport
/*     */   implements AspectManagerServiceMBean, AspectNotificationHandler
/*     */ {
/*  67 */   Logger log = Logger.getLogger(AspectManagerService.class);
/*     */   public static final ObjectName DEFAULT_LOADER_REPOSITORY;
/*  84 */   boolean created = false;
/*     */   protected File tmpClassesDir;
/*  86 */   protected boolean enableTransformer = false;
/*  87 */   protected boolean enableLoadtimeWeaving = false;
/*  88 */   protected boolean suppressTransformationErrors = true;
/*  89 */   protected boolean suppressReferenceErrors = true;
/*     */   protected String exclude;
/*     */   protected String include;
/*     */   protected String ignore;
/*  93 */   private String baseXml = "base-aop.xml";
/*     */   boolean registerHappensAfterStart;
/*     */   boolean hasBeenStarted;
/*     */   private JBossIntegration integration;
/*     */ 
/*     */   public AspectManagerService()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AspectManagerService(String baseXml)
/*     */   {
/* 115 */     this.baseXml = baseXml;
/* 116 */     this.registerHappensAfterStart = true;
/*     */   }
/*     */ 
/*     */   public JBossIntegration getJBossIntegration()
/*     */   {
/* 128 */     return this.integration;
/*     */   }
/*     */ 
/*     */   public void setJBossIntegration(JBossIntegration integration)
/*     */   {
/* 138 */     this.integration = integration;
/*     */   }
/*     */ 
/*     */   protected ScopedClassPoolFactory createFactory() throws Exception
/*     */   {
/* 143 */     return initIntegration().createScopedClassPoolFactory(this.tmpClassesDir);
/*     */   }
/*     */ 
/*     */   protected ClassLoaderValidation createClassLoaderValidation()
/*     */   {
/* 148 */     return initIntegration();
/*     */   }
/*     */ 
/*     */   protected JBossIntegration initIntegration()
/*     */   {
/* 159 */     if (this.integration == null)
/* 160 */       this.integration = new JBoss4Integration();
/* 161 */     return this.integration;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 167 */     initIntegration();
/* 168 */     if (this.hasBeenStarted)
/*     */     {
/* 170 */       return;
/*     */     }
/*     */ 
/* 173 */     if (this.tmpClassesDir == null)
/*     */     {
/* 175 */       String jbossTmpDir = System.getProperty("jboss.server.temp.dir");
/* 176 */       if (jbossTmpDir == null)
/* 177 */         jbossTmpDir = System.getProperty("java.io.tmpdir");
/* 178 */       this.tmpClassesDir = new File(jbossTmpDir, "aopdynclasses");
/*     */     }
/*     */ 
/* 181 */     if ((!this.tmpClassesDir.exists()) && (!this.tmpClassesDir.mkdirs()))
/* 182 */       throw new FileNotFoundException("Failed to create tmpClassesDir: " + this.tmpClassesDir.getAbsolutePath());
/* 183 */     AspectManager.setClassPoolFactory(createFactory());
/*     */ 
/* 185 */     AspectManager.classLoaderValidator = createClassLoaderValidation();
/*     */ 
/* 188 */     org.jboss.aop.Deployment.searchClasspath = false;
/* 189 */     AspectManager.suppressTransformationErrors = this.suppressTransformationErrors;
/* 190 */     if ((this.enableTransformer) && (this.enableLoadtimeWeaving)) throw new RuntimeException("Cannot set both EnableTransformer and EnableLoadtimeWeaving");
/* 191 */     if (this.enableTransformer)
/*     */     {
/* 193 */       attachDeprecatedTranslator();
/*     */     }
/* 195 */     if (this.enableLoadtimeWeaving)
/*     */     {
/* 197 */       attachTranslator();
/*     */     }
/* 199 */     this.created = true;
/* 200 */     AspectManager.notificationHandler = this;
/*     */ 
/* 202 */     AspectManager.setClassLoaderScopingPolicy(this.integration.createAOPClassLoaderScopingPolicy());
/*     */ 
/* 204 */     baseAop();
/*     */   }
/*     */ 
/*     */   protected void baseAop()
/*     */   {
/* 209 */     if (this.baseXml == null)
/*     */     {
/* 211 */       return;
/*     */     }
/* 213 */     baseAop(this.baseXml);
/*     */   }
/*     */ 
/*     */   public void baseAop(String xml)
/*     */   {
/* 218 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 219 */     URL base = cl.getResource(xml);
/*     */     try
/*     */     {
/* 222 */       if (base != null)
/*     */       {
/* 224 */         AspectXmlLoader.deployXML(base);
/*     */       }
/*     */       else
/*     */       {
/* 228 */         this.log.warn("Could not find " + xml + " file in the resources of " + cl);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 233 */       System.out.println("Error loading " + xml + " file" + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void attachDeprecatedTranslator()
/*     */   {
/* 239 */     this.log.warn("EnableTransformer has been deprecated, please use EnableLoadtimeWeaving.  See docs for more details");
/* 240 */     initIntegration().attachDeprecatedTranslator();
/*     */   }
/*     */ 
/*     */   protected void detachDeprecatedTranslator()
/*     */   {
/* 245 */     initIntegration().detachDeprecatedTranslator();
/*     */   }
/*     */ 
/*     */   protected void attachTranslator()
/*     */   {
/* 250 */     org.jboss.aop.hook.JDK14TransformerManager.transformer = new JDK14Transformer()
/*     */     {
/*     */       public byte[] transform(ClassLoader loader, String classname, byte[] classBytes)
/*     */       {
/*     */         try
/*     */         {
/* 257 */           return AspectManager.instance(loader).translate(classname, loader, classBytes);
/*     */         }
/*     */         catch (Exception e) {
/*     */         }
/* 261 */         throw new RuntimeException("Error converting " + classname + " on " + loader, e);
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   protected void detachTranslator()
/*     */   {
/* 269 */     org.jboss.aop.hook.JDK14TransformerManager.transformer = null;
/*     */   }
/*     */ 
/*     */   public void attachClass(String classname)
/*     */   {
/* 274 */     Notification msg = new Notification("AOP class attached", this, getNextNotificationSequenceNumber());
/* 275 */     msg.setUserData(classname);
/* 276 */     sendNotification(msg);
/*     */   }
/*     */ 
/*     */   public boolean getPrune()
/*     */   {
/* 281 */     return AspectManager.getPrune();
/*     */   }
/*     */ 
/*     */   public void setPrune(boolean prune)
/*     */   {
/* 286 */     AspectManager.setPrune(prune);
/*     */   }
/*     */ 
/*     */   public String getExclude()
/*     */   {
/* 291 */     return this.exclude;
/*     */   }
/*     */ 
/*     */   public void setExclude(String exclude)
/*     */   {
/* 296 */     this.exclude = exclude;
/* 297 */     ArrayList list = new ArrayList();
/* 298 */     if (exclude != null)
/*     */     {
/* 300 */       StringTokenizer tokenizer = new StringTokenizer(exclude, ",");
/* 301 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 303 */         list.add(tokenizer.nextToken().trim());
/*     */       }
/*     */     }
/* 306 */     AspectManager.instance().setExclude(list);
/*     */   }
/*     */ 
/*     */   public String getInclude()
/*     */   {
/* 311 */     return this.include;
/*     */   }
/*     */ 
/*     */   public void setInclude(String include)
/*     */   {
/* 316 */     this.include = include;
/* 317 */     ArrayList list = new ArrayList();
/* 318 */     if (include != null)
/*     */     {
/* 320 */       StringTokenizer tokenizer = new StringTokenizer(include, ",");
/* 321 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 323 */         list.add(tokenizer.nextToken().trim());
/*     */       }
/*     */     }
/* 326 */     AspectManager.instance().setInclude(list);
/*     */   }
/*     */ 
/*     */   public String getIgnore()
/*     */   {
/* 331 */     return this.ignore;
/*     */   }
/*     */ 
/*     */   public void setIgnore(String ignore)
/*     */   {
/* 336 */     this.ignore = ignore;
/* 337 */     ArrayList list = new ArrayList();
/* 338 */     if (ignore != null)
/*     */     {
/* 340 */       StringTokenizer tokenizer = new StringTokenizer(ignore, ",");
/* 341 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 343 */         list.add(tokenizer.nextToken().trim());
/*     */       }
/*     */     }
/* 346 */     AspectManager.instance().setIgnore(list);
/*     */   }
/*     */ 
/*     */   public File getTmpClassesDir()
/*     */   {
/* 355 */     return this.tmpClassesDir;
/*     */   }
/*     */ 
/*     */   public void setTmpClassesDir(File tmpClassesDir)
/*     */   {
/* 363 */     this.tmpClassesDir = tmpClassesDir;
/*     */   }
/*     */ 
/*     */   public boolean getVerbose()
/*     */   {
/* 371 */     return AspectManager.verbose;
/*     */   }
/*     */ 
/*     */   public void setVerbose(boolean verbose)
/*     */   {
/* 379 */     AspectManager.verbose = verbose;
/*     */   }
/*     */ 
/*     */   public boolean getOptimized()
/*     */   {
/* 387 */     return AspectManager.optimize;
/*     */   }
/*     */ 
/*     */   public void setOptimized(boolean verbose)
/*     */   {
/* 395 */     AspectManager.optimize = verbose;
/*     */   }
/*     */ 
/*     */   public boolean getSuppressTransformationErrors()
/*     */   {
/* 400 */     return this.suppressTransformationErrors;
/*     */   }
/*     */ 
/*     */   public void setSuppressTransformationErrors(boolean suppressTransformationErrors)
/*     */   {
/* 405 */     this.suppressTransformationErrors = suppressTransformationErrors;
/* 406 */     AspectManager.suppressTransformationErrors = suppressTransformationErrors;
/*     */   }
/*     */ 
/*     */   public boolean getSuppressReferenceErrors()
/*     */   {
/* 411 */     return this.suppressReferenceErrors;
/*     */   }
/*     */ 
/*     */   public void setSuppressReferenceErrors(boolean suppressReferenceErrors)
/*     */   {
/* 416 */     this.suppressReferenceErrors = suppressReferenceErrors;
/* 417 */     AspectManager.suppressReferenceErrors = suppressReferenceErrors;
/*     */   }
/*     */ 
/*     */   public boolean getEnableTransformer()
/*     */   {
/* 425 */     return this.enableTransformer;
/*     */   }
/*     */ 
/*     */   public String interceptorFactories()
/*     */   {
/* 433 */     Map factories = AspectManager.instance().getInterceptorFactories();
/* 434 */     Iterator it = factories.keySet().iterator();
/* 435 */     StringBuffer buffer = new StringBuffer("");
/* 436 */     while (it.hasNext())
/*     */     {
/* 438 */       buffer.append(it.next() + "<br>");
/*     */     }
/* 440 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public String aspectDefinitions()
/*     */   {
/* 448 */     Map factories = AspectManager.instance().getAspectDefinitions();
/* 449 */     Iterator it = factories.keySet().iterator();
/* 450 */     StringBuffer buffer = new StringBuffer("");
/* 451 */     while (it.hasNext())
/*     */     {
/* 453 */       buffer.append(it.next() + "<br>");
/*     */     }
/* 455 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public String introductions()
/*     */   {
/* 460 */     Map factories = AspectManager.instance().getInterfaceIntroductions();
/* 461 */     Iterator it = factories.keySet().iterator();
/* 462 */     StringBuffer buffer = new StringBuffer("");
/* 463 */     while (it.hasNext())
/*     */     {
/* 465 */       buffer.append(it.next() + "<br>");
/*     */     }
/* 467 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public String stacks()
/*     */   {
/* 472 */     Map factories = AspectManager.instance().getInterceptorStacks();
/* 473 */     Iterator it = factories.keySet().iterator();
/* 474 */     StringBuffer buffer = new StringBuffer("");
/* 475 */     while (it.hasNext())
/*     */     {
/* 477 */       buffer.append(it.next() + "<br>");
/*     */     }
/* 479 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public String bindings()
/*     */   {
/* 484 */     Map factories = AspectManager.instance().getBindings();
/* 485 */     Iterator it = factories.keySet().iterator();
/* 486 */     StringBuffer buffer = new StringBuffer("");
/* 487 */     while (it.hasNext())
/*     */     {
/* 489 */       buffer.append(it.next() + "<br>");
/*     */     }
/* 491 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public String registeredClassLoaders()
/*     */   {
/* 496 */     AspectManager.instance(); Map factories = AspectManager.getRegisteredCLs();
/* 497 */     Iterator it = factories.keySet().iterator();
/* 498 */     StringBuffer buffer = new StringBuffer("");
/* 499 */     while (it.hasNext())
/*     */     {
/* 501 */       buffer.append(it.next() + "<br>");
/*     */     }
/* 503 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public void setEnableTransformer(boolean enableTransformer)
/*     */   {
/* 510 */     if (this.enableLoadtimeWeaving)
/*     */     {
/* 512 */       this.log.warn("enabledLoadtimeWeaving alread set");
/* 513 */       return;
/*     */     }
/* 515 */     if (this.enableTransformer == enableTransformer) return;
/* 516 */     if (getState() == 3)
/*     */     {
/* 518 */       if (enableTransformer)
/*     */       {
/* 520 */         attachDeprecatedTranslator();
/*     */       }
/*     */       else
/*     */       {
/* 524 */         detachDeprecatedTranslator();
/*     */       }
/*     */     }
/* 527 */     this.enableTransformer = enableTransformer;
/*     */   }
/*     */ 
/*     */   public boolean getEnableLoadtimeWeaving()
/*     */   {
/* 532 */     return this.enableLoadtimeWeaving;
/*     */   }
/*     */ 
/*     */   public void setEnableLoadtimeWeaving(boolean enableTransformer)
/*     */   {
/* 537 */     if (this.enableLoadtimeWeaving == enableTransformer) return;
/* 538 */     if (getState() == 3)
/*     */     {
/* 540 */       if (enableTransformer)
/*     */       {
/* 542 */         attachTranslator();
/*     */       }
/*     */       else
/*     */       {
/* 546 */         detachTranslator();
/*     */       }
/*     */     }
/* 549 */     this.enableLoadtimeWeaving = enableTransformer;
/*     */   }
/*     */ 
/*     */   public String getInstrumentor()
/*     */   {
/* 554 */     return InstrumentorFactory.getInstrumentorName();
/*     */   }
/*     */ 
/*     */   public void setInstrumentor(String instrumentor)
/*     */   {
/* 559 */     InstrumentorFactory.initialise(instrumentor);
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean done)
/*     */   {
/* 565 */     super.postRegister(done);
/* 566 */     if (this.registerHappensAfterStart)
/*     */     {
/*     */       try
/*     */       {
/* 570 */         super.start();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 574 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  74 */     Class clazz = TransformerCommon.class;
/*  75 */     clazz = SuperClassesFirstWeavingStrategy.class;
/*  76 */     clazz = ClassicWeavingStrategy.class;
/*  77 */     clazz = HeirarchicalLoaderRepository3.class;
/*     */ 
/*  80 */     DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create("JMImplementation:service=LoaderRepository,name=Default");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.deployment.AspectManagerService
 * JD-Core Version:    0.6.0
 */