/*     */ package org.jboss.aop.domain;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.Domain;
/*     */ import org.jboss.aop.InterceptionMarkers;
/*     */ import org.jboss.aop.advice.AspectDefinition;
/*     */ 
/*     */ public abstract class ScopedClassLoaderDomain extends Domain
/*     */ {
/*     */   private WeakReference<ClassLoader> loader;
/*     */   protected boolean parentDelegation;
/*  45 */   protected ConcurrentHashMap<String, Object> myPerVMAspects = new ConcurrentHashMap();
/*  46 */   protected ConcurrentHashMap<String, Boolean> notMyPerVMAspects = new ConcurrentHashMap();
/*  47 */   protected InterceptionMarkers interceptionMarkers = new InterceptionMarkers();
/*     */   protected String classLoaderString;
/*     */ 
/*     */   public ScopedClassLoaderDomain(ClassLoader loader, String name, boolean parentDelegation, AspectManager manager, boolean parentFirst)
/*     */   {
/*  52 */     super(manager, name, parentFirst);
/*  53 */     if (loader == null)
/*  54 */       throw new IllegalArgumentException("Null classloader");
/*  55 */     this.loader = new WeakReference(loader);
/*  56 */     this.parentDelegation = parentDelegation;
/*  57 */     this.classLoaderString = loader.toString();
/*  58 */     this.inheritsBindings = true;
/*  59 */     this.inheritsDeclarations = true;
/*     */   }
/*     */ 
/*     */   protected ClassLoader getClassLoader()
/*     */   {
/*  64 */     ClassLoader cl = (ClassLoader)this.loader.get();
/*  65 */     if (cl != null)
/*     */     {
/*  67 */       return cl;
/*     */     }
/*  69 */     return null;
/*     */   }
/*     */ 
/*     */   public abstract boolean isValid();
/*     */ 
/*     */   public void removeAspectDefinition(String name)
/*     */   {
/*  79 */     AspectDefinition def = super.internalRemoveAspectDefintion(name);
/*  80 */     if (def != null)
/*     */     {
/*  82 */       this.myPerVMAspects.remove(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getPerVMAspect(AspectDefinition def)
/*     */   {
/*  89 */     return getPerVMAspect(def.getName());
/*     */   }
/*     */ 
/*     */   public InterceptionMarkers getInterceptionMarkers()
/*     */   {
/*  95 */     return this.interceptionMarkers;
/*     */   }
/*     */ 
/*     */   public Object getPerVMAspect(String def)
/*     */   {
/* 101 */     if (this.parentDelegation == true)
/*     */     {
/* 104 */       Object aspect = super.getPerVMAspect(def);
/* 105 */       return aspect;
/*     */     }
/*     */ 
/* 109 */     return getPerVmAspectWithNoParentDelegation(def);
/*     */   }
/*     */ 
/*     */   protected Object getSuperPerVmAspect(String def)
/*     */   {
/* 115 */     return super.getPerVMAspect(def);
/*     */   }
/*     */ 
/*     */   protected abstract Object getPerVmAspectWithNoParentDelegation(String paramString);
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.domain.ScopedClassLoaderDomain
 * JD-Core Version:    0.6.0
 */