/*     */ package org.jboss.aop.hook;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.LoaderClassPath;
/*     */ import javassist.NotFoundException;
/*     */ 
/*     */ public class GenerateInstrumentedClassLoader
/*     */ {
/*     */   private static void declare5(CtClass clazz, CtMethod method)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  47 */     method.setName("wrappedDefineClass");
/*  48 */     CtMethod wrapper = CtNewMethod.make(4, method.getReturnType(), "defineClass", method.getParameterTypes(), method.getExceptionTypes(), null, clazz);
/*     */ 
/*  50 */     String code = "{  byte[] newBytes = org.jboss.aop.AspectManager.instance().translate($1, $0, $2) ;  if (newBytes != (byte[])null) {    return wrappedDefineClass($1, newBytes, 0, newBytes.length, $5);   } else {    return wrappedDefineClass($1, $2, $3, $4, $5);   }}";
/*     */ 
/*  58 */     wrapper.setBody(code);
/*  59 */     clazz.addMethod(wrapper);
/*     */   }
/*     */ 
/*     */   public static byte[] getInstrumentedClassLoader()
/*     */     throws NotFoundException, IOException, CannotCompileException
/*     */   {
/*  75 */     ClassPool classpool = ClassPool.getDefault();
/*  76 */     classpool = ClassPool.getDefault();
/*  77 */     ClassLoader cl = SecurityActions.getContextClassLoader();
/*  78 */     classpool.insertClassPath(new LoaderClassPath(cl));
/*     */ 
/*  80 */     CtClass clazz = classpool.get(ClassLoader.class.getName());
/*  81 */     CtMethod[] methods = clazz.getDeclaredMethods();
/*  82 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  84 */       if (!methods[i].getName().equals("defineClass"))
/*     */         continue;
/*  86 */       if ((methods[i].getParameterTypes().length != 5) || (!methods[i].getParameterTypes()[1].isArray())) {
/*     */         continue;
/*     */       }
/*  89 */       declare5(clazz, methods[i]);
/*     */     }
/*     */ 
/*  93 */     return clazz.toBytecode();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 103 */     if (args.length != 1)
/*     */     {
/* 105 */       System.err.println("Usage: java " + GeneratePluggableInstrumentedClassLoader.class.getName() + " <output directory>");
/* 106 */       System.exit(1);
/*     */     }
/* 108 */     String filename = args[0] + File.separatorChar + "java" + File.separatorChar + "lang" + File.separatorChar + "ClassLoader.class";
/*     */ 
/* 112 */     File file = new File(filename);
/* 113 */     if (file.exists())
/*     */     {
/* 115 */       if (!file.canWrite())
/*     */       {
/* 117 */         System.err.println("Cannot write to existing file: " + file.getAbsolutePath());
/* 118 */         System.exit(2);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 123 */       File dir = file.getParentFile();
/* 124 */       if (!dir.exists())
/*     */       {
/* 126 */         dir.mkdirs();
/*     */       }
/* 128 */       if (!dir.canWrite())
/*     */       {
/* 130 */         System.err.println("Cannot write to parent directory: " + dir.getAbsolutePath());
/*     */       }
/*     */     }
/*     */     byte[] bytes;
/*     */     try
/*     */     {
/* 137 */       bytes = getInstrumentedClassLoader();
/*     */     }
/*     */     catch (Throwable th)
/*     */     {
/* 141 */       System.err.println("Unexpected exception caught during instrumentation: " + th.getMessage());
/* 142 */       th.printStackTrace(System.err);
/* 143 */       System.exit(5);
/* 144 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 149 */       FileOutputStream fos = new FileOutputStream(file);
/* 150 */       fos.write(bytes);
/* 151 */       fos.close();
/*     */     }
/*     */     catch (IOException ioe)
/*     */     {
/* 155 */       System.err.println("Unexpected exception caught while writing class file: " + ioe.getMessage());
/* 156 */       ioe.printStackTrace(System.err);
/* 157 */       System.exit(6);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.hook.GenerateInstrumentedClassLoader
 * JD-Core Version:    0.6.0
 */