/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.Iterator;
/*     */ import javassist.CtBehavior;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.MethodCall;
/*     */ import javassist.expr.NewExpr;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.pointcut.DeclareDef;
/*     */ 
/*     */ public class DeclareChecker
/*     */ {
/*     */   public static void checkDeclares(AspectManager manager, CtClass clazz, ClassAdvisor advisor)
/*     */   {
/*  47 */     for (Iterator it = manager.getDeclares(); it.hasNext(); )
/*     */     {
/*  49 */       DeclareDef declare = (DeclareDef)it.next();
/*  50 */       if (declare.matches(advisor, clazz))
/*     */       {
/*  52 */         StringBuffer sb = new StringBuffer(" condition\n\t'" + declare.getExpr() + "'\nwas broken for class " + clazz.getName() + "\n\t" + declare.getMsg() + "\n");
/*     */ 
/*  55 */         if (declare.getWarning())
/*     */         {
/*  57 */           sb.insert(0, "WARNING: declare-warning");
/*     */ 
/*  59 */           System.out.println(sb.toString());
/*     */         }
/*     */         else
/*     */         {
/*  63 */           sb.insert(0, "ERROR: declare-error");
/*  64 */           throw new RuntimeException(sb.toString());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void checkDeclares(AspectManager manager, NewExpr call, ClassAdvisor advisor) throws NotFoundException
/*     */   {
/*  72 */     checkDeclares(manager, call, null, advisor);
/*     */   }
/*     */ 
/*     */   public static void checkDeclares(AspectManager manager, MethodCall call, ClassAdvisor advisor) throws NotFoundException
/*     */   {
/*  77 */     checkDeclares(manager, null, call, advisor);
/*     */   }
/*     */ 
/*     */   private static void checkDeclares(AspectManager manager, NewExpr newcall, MethodCall mcall, ClassAdvisor advisor) throws NotFoundException
/*     */   {
/*  82 */     for (Iterator it = manager.getDeclares(); it.hasNext(); )
/*     */     {
/*  84 */       DeclareDef declare = (DeclareDef)it.next();
/*     */ 
/*  86 */       StringBuffer sb = new StringBuffer(" condition\n\t'" + declare.getExpr() + "'\nwas broken for ");
/*     */ 
/*  88 */       if (((newcall != null) && (declare.matchesCall(advisor, newcall))) || ((mcall != null) && (declare.matchesCall(advisor, mcall))))
/*     */       {
/*  90 */         if (mcall != null)
/*     */         {
/*  92 */           sb.append("method call:");
/*  93 */           CtBehavior caller = mcall.where();
/*  94 */           if ((caller instanceof CtConstructor))
/*     */           {
/*  96 */             CtConstructor con = (CtConstructor)caller;
/*  97 */             addConstructor(sb, con);
/*  98 */             sb.append(" calls ");
/*  99 */             addMethod(sb, mcall.getMethod());
/*     */           }
/* 101 */           else if ((caller instanceof CtMethod))
/*     */           {
/* 103 */             CtMethod met = (CtMethod)caller;
/* 104 */             addMethod(sb, met);
/* 105 */             sb.append(" calls ");
/* 106 */             addMethod(sb, mcall.getMethod());
/*     */           }
/*     */         }
/* 109 */         else if (newcall != null)
/*     */         {
/* 111 */           sb.append("constructor call: ");
/* 112 */           CtBehavior caller = newcall.where();
/* 113 */           if ((caller instanceof CtConstructor))
/*     */           {
/* 115 */             CtConstructor con = (CtConstructor)caller;
/* 116 */             addConstructor(sb, con);
/* 117 */             sb.append(" calls ");
/* 118 */             addConstructor(sb, newcall.getConstructor());
/*     */           }
/* 120 */           else if ((caller instanceof CtMethod))
/*     */           {
/* 122 */             CtMethod met = (CtMethod)caller;
/* 123 */             addMethod(sb, met);
/* 124 */             sb.append(" calls ");
/* 125 */             addConstructor(sb, newcall.getConstructor());
/*     */           }
/*     */         }
/*     */ 
/* 129 */         sb.append("\n\t" + declare.getMsg() + "\n");
/*     */ 
/* 131 */         if (declare.getWarning())
/*     */         {
/* 133 */           sb.insert(0, "WARNING: declare-warning");
/*     */ 
/* 135 */           System.out.println(sb.toString());
/*     */         }
/*     */         else
/*     */         {
/* 139 */           sb.insert(0, "ERROR: declare-error");
/* 140 */           throw new RuntimeException(sb.toString());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void addMethod(StringBuffer sb, CtMethod method)
/*     */   {
/* 148 */     sb.append(method.getDeclaringClass().getName() + "." + method.getName() + method.getSignature());
/*     */   }
/*     */ 
/*     */   private static void addConstructor(StringBuffer sb, CtConstructor con)
/*     */   {
/* 153 */     sb.append(con.getDeclaringClass().getName() + ".new" + con.getSignature());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.DeclareChecker
 * JD-Core Version:    0.6.0
 */