/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.MethodCall;
/*     */ import javassist.expr.NewExpr;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class GeneratedAdvisorCallerTransformer extends CallerTransformer
/*     */ {
/*  46 */   private static final Logger logger = AOPLogger.getLogger(GeneratedAdvisorCallerTransformer.class);
/*     */ 
/*     */   public GeneratedAdvisorCallerTransformer(Instrumentor instrumentor, AspectManager manager)
/*     */   {
/*  50 */     super(instrumentor, manager, true, new GeneratedAdvisorCallerInfoAdder(instrumentor));
/*     */   }
/*     */ 
/*     */   private GeneratedAdvisorInstrumentor getInstrumentor()
/*     */   {
/*  55 */     return (GeneratedAdvisorInstrumentor)this.instrumentor;
/*     */   }
/*     */ 
/*     */   private CtClass getGenadvisor()
/*     */   {
/*  60 */     return getInstrumentor().getGenadvisor();
/*     */   }
/*     */ 
/*     */   protected CallerTransformer.CallerExprEditor callerExprEditorFactory(ClassAdvisor advisor, CtClass clazz)
/*     */   {
/*  65 */     return new GeneratedAdvisorCallerExprEditor(advisor, clazz);
/*     */   }
/*     */ 
/*     */   private String getArguments(int length, int offset)
/*     */   {
/* 585 */     StringBuffer sb = new StringBuffer("");
/* 586 */     for (int i = 0; i < length - offset; i++)
/*     */     {
/* 588 */       if (i > 0)
/*     */       {
/* 590 */         sb.append(", ");
/*     */       }
/* 592 */       sb.append("$" + (i + 1 + offset));
/*     */     }
/* 594 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   class GeneratedAdvisorCallerExprEditor extends CallerTransformer.CallerExprEditor
/*     */   {
/*     */     public GeneratedAdvisorCallerExprEditor(ClassAdvisor advisor, CtClass callingClass)
/*     */     {
/*  72 */       super(advisor, callingClass);
/*     */     }
/*     */ 
/*     */     protected void setupConstructor(CallerTransformer.ConstructorDetail cd) throws NotFoundException, CannotCompileException
/*     */     {
/*  77 */       if (this.callerInfos.get(cd.callerInfoField) == null)
/*     */       {
/*  79 */         this.callerInfos.put(cd.callerInfoField, "whatever");
/*  80 */         GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addMethodByConInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
/*  81 */         addJoinpoint(cd);
/*  82 */         createGenAdvisorMethodByConMethod(cd);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addJoinpoint(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException
/*     */     {
/*  88 */       CtClass joinpoint = createJoinpointClass(cd);
/*  89 */       CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
/*  90 */       CtField field = new CtField(joinpoint, MethodByConJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingIndex, cd.classname, cd.calledHash), genadvisor);
/*     */ 
/*  94 */       field.setModifiers(4);
/*  95 */       genadvisor.addField(field);
/*     */     }
/*     */ 
/*     */     private CtClass createJoinpointClass(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException
/*     */     {
/* 100 */       return MethodByConJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), cd.callingIndex, this.callingClass, cd.calledMethod, cd.classname, cd.calledHash, cd.callerInfoField);
/*     */     }
/*     */ 
/*     */     private void createGenAdvisorMethodByConMethod(CallerTransformer.ConstructorDetail cd)
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 112 */       boolean hasTargetObject = !Modifier.isStatic(cd.calledMethod.getModifiers());
/* 113 */       int originalLength = cd.calledMethod.getParameterTypes().length;
/* 114 */       CtClass[] params = null;
/*     */ 
/* 116 */       if (hasTargetObject)
/*     */       {
/* 118 */         params = new CtClass[originalLength + 2];
/* 119 */         params[0] = GeneratedAdvisorCallerTransformer.this.instrumentor.forName(cd.classname);
/* 120 */         params[1] = this.callingClass;
/* 121 */         System.arraycopy(cd.calledMethod.getParameterTypes(), 0, params, 2, originalLength);
/*     */       }
/*     */       else
/*     */       {
/* 125 */         params = new CtClass[originalLength + 1];
/* 126 */         params[0] = this.callingClass;
/* 127 */         System.arraycopy(cd.calledMethod.getParameterTypes(), 0, params, 1, originalLength);
/*     */       }
/*     */ 
/* 130 */       String proceed = null;
/*     */ 
/* 132 */       if (hasTargetObject)
/*     */       {
/* 134 */         proceed = MethodExecutionTransformer.getAopReturnStr(cd.calledMethod) + "$1." + cd.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, 2) + ");";
/*     */       }
/*     */       else
/*     */       {
/* 138 */         proceed = MethodExecutionTransformer.getAopReturnStr(cd.calledMethod) + cd.classname + "." + cd.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, 1) + ");";
/*     */       }
/*     */ 
/* 141 */       String joinpointName = MethodByConJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingIndex, cd.classname, cd.calledHash);
/* 142 */       String infoName = cd.callerInfoField;
/* 143 */       String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "      " + proceed + "   }" + "   else" + "   {" + "      return " + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
/*     */       try
/*     */       {
/* 161 */         CtMethod method = CtNewMethod.make(cd.calledMethod.getReturnType(), cd.callerInfoField, params, cd.calledMethod.getExceptionTypes(), code, GeneratedAdvisorCallerTransformer.this.getGenadvisor());
/*     */ 
/* 168 */         GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 172 */         GeneratedAdvisorCallerTransformer.logger.error("Error for " + cd.callingIndex + " code:" + code);
/* 173 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void setupMethod(CallerTransformer.MethodDetail md)
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 180 */       if (this.callerInfos.get(md.callerInfoField) == null)
/*     */       {
/* 182 */         this.callerInfos.put(md.callerInfoField, "whatever");
/* 183 */         GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addMethodByMethodInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), md.callerInfoField, md.callingHash, md.classname, md.calledHash);
/* 184 */         addJoinpoint(md);
/* 185 */         createGenAdvisorMethodByMethodMethod(md);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addJoinpoint(CallerTransformer.MethodDetail md) throws CannotCompileException, NotFoundException
/*     */     {
/* 191 */       CtClass joinpoint = createJoinpointClass(md);
/* 192 */       CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
/* 193 */       CtField field = new CtField(joinpoint, MethodByMethodJoinPointGenerator.getGeneratedJoinPointFieldName(md.callingHash, md.classname, md.calledHash), genadvisor);
/*     */ 
/* 197 */       field.setModifiers(4);
/* 198 */       genadvisor.addField(field);
/*     */     }
/*     */ 
/*     */     private CtClass createJoinpointClass(CallerTransformer.MethodDetail md) throws CannotCompileException, NotFoundException
/*     */     {
/* 203 */       return MethodByMethodJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), md.callingHash, !Modifier.isStatic(md.where.getModifiers()), this.callingClass, md.calledMethod, md.classname, md.calledHash, md.callerInfoField);
/*     */     }
/*     */ 
/*     */     private void createGenAdvisorMethodByMethodMethod(CallerTransformer.MethodDetail md)
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 217 */       boolean hasCallingObject = !Modifier.isStatic(md.where.getModifiers());
/* 218 */       boolean hasTargetObject = !Modifier.isStatic(md.calledMethod.getModifiers());
/* 219 */       int originalLength = md.calledMethod.getParameterTypes().length;
/*     */ 
/* 221 */       int offset = 0;
/* 222 */       if (hasTargetObject) offset++;
/* 223 */       if (hasCallingObject) offset++;
/*     */ 
/* 226 */       CtClass[] params = new CtClass[originalLength + offset];
/* 227 */       int index = 0;
/* 228 */       if (hasTargetObject) params[(index++)] = GeneratedAdvisorCallerTransformer.this.instrumentor.forName(md.classname);
/* 229 */       if (hasCallingObject) params[(index++)] = this.callingClass;
/*     */ 
/* 231 */       System.arraycopy(md.calledMethod.getParameterTypes(), 0, params, offset, originalLength);
/*     */ 
/* 233 */       String proceed = null;
/* 234 */       if (hasTargetObject)
/*     */       {
/* 236 */         proceed = MethodExecutionTransformer.getAopReturnStr(md.calledMethod) + "$1." + md.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, hasCallingObject ? 2 : 1) + ");";
/*     */       }
/*     */       else
/*     */       {
/* 240 */         proceed = MethodExecutionTransformer.getAopReturnStr(md.calledMethod) + md.classname + "." + md.calledMethod.getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, hasCallingObject ? 1 : 0) + ");";
/*     */       }
/*     */ 
/* 243 */       String joinpointName = MethodByMethodJoinPointGenerator.getGeneratedJoinPointFieldName(md.callingHash, md.classname, md.calledHash);
/* 244 */       String infoName = md.callerInfoField;
/* 245 */       String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "      " + proceed + "   }" + "   else" + "   {" + "      " + MethodExecutionTransformer.getReturnStr(md.calledMethod) + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
/*     */       try
/*     */       {
/* 264 */         CtMethod method = CtNewMethod.make(md.calledMethod.getReturnType(), md.callerInfoField, params, md.calledMethod.getExceptionTypes(), code, GeneratedAdvisorCallerTransformer.this.getGenadvisor());
/*     */ 
/* 271 */         GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 275 */         GeneratedAdvisorCallerTransformer.logger.error("Error for " + md.where + " code:" + code);
/* 276 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void setupMethod(CallerTransformer.ConByMethodDetail cd) throws NotFoundException, CannotCompileException
/*     */     {
/* 282 */       if (this.callerInfos.get(cd.callerInfoField) == null)
/*     */       {
/* 284 */         this.callerInfos.put(cd.callerInfoField, "whatever");
/* 285 */         GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addConByMethodInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), cd.callerInfoField, cd.callingHash, cd.classname, cd.calledHash);
/* 286 */         addJoinpoint(cd);
/* 287 */         createGenAdvisorConByMethodMethod(cd);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addJoinpoint(CallerTransformer.ConByMethodDetail cd) throws CannotCompileException, NotFoundException
/*     */     {
/* 293 */       CtClass joinpoint = createJoinpointClass(cd);
/* 294 */       CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
/* 295 */       CtField field = new CtField(joinpoint, ConByMethodJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingHash, cd.classname, cd.calledHash), genadvisor);
/*     */ 
/* 299 */       field.setModifiers(4);
/* 300 */       genadvisor.addField(field);
/*     */     }
/*     */ 
/*     */     private CtClass createJoinpointClass(CallerTransformer.ConByMethodDetail cd) throws CannotCompileException, NotFoundException
/*     */     {
/* 305 */       return ConByMethodJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), cd.callingHash, !Modifier.isStatic(cd.where.getModifiers()), this.callingClass, cd.calledConstructor, cd.classname, cd.calledHash, cd.callerInfoField);
/*     */     }
/*     */ 
/*     */     private void createGenAdvisorConByMethodMethod(CallerTransformer.ConByMethodDetail cd)
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 318 */       boolean hasCallingObject = !Modifier.isStatic(cd.where.getModifiers());
/* 319 */       String info = cd.callerInfoField;
/*     */ 
/* 321 */       int originalLength = cd.calledConstructor.getParameterTypes().length;
/* 322 */       CtClass[] params = null;
/*     */ 
/* 324 */       if (hasCallingObject)
/*     */       {
/* 326 */         params = new CtClass[originalLength + 1];
/* 327 */         params[0] = this.callingClass;
/* 328 */         System.arraycopy(cd.calledConstructor.getParameterTypes(), 0, params, 1, originalLength);
/*     */       }
/*     */       else
/*     */       {
/* 332 */         params = cd.calledConstructor.getParameterTypes();
/*     */       }
/*     */ 
/* 335 */       String joinpointName = ConByMethodJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingHash, cd.classname, cd.calledHash);
/* 336 */       String infoName = cd.callerInfoField;
/* 337 */       StringBuffer code = new StringBuffer();
/* 338 */       code.append("{");
/* 339 */       code.append("   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())");
/* 340 */       code.append("   {");
/* 341 */       code.append("      super.generateJoinPointClass(" + infoName + ");");
/* 342 */       code.append("   }");
/* 343 */       code.append("   if (" + joinpointName + " == null)");
/* 344 */       code.append("   { ");
/* 345 */       code.append("      return new " + cd.calledConstructor.getDeclaringClass().getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, hasCallingObject ? 1 : 0) + "); ");
/* 346 */       code.append("   }");
/* 347 */       code.append("   else");
/* 348 */       code.append("   {");
/* 349 */       code.append("      return " + joinpointName + "." + "invokeJoinpoint" + "($$);");
/* 350 */       code.append("   }");
/* 351 */       code.append("}");
/*     */       try
/*     */       {
/* 355 */         CtMethod method = CtNewMethod.make(cd.calledConstructor.getDeclaringClass(), info, params, cd.calledConstructor.getExceptionTypes(), code.toString(), GeneratedAdvisorCallerTransformer.this.getGenadvisor());
/*     */ 
/* 362 */         GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 366 */         GeneratedAdvisorCallerTransformer.logger.error("Error for " + cd.where + ": code:" + code);
/* 367 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void setupConstructor(CallerTransformer.ConByConDetail cd)
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 374 */       if (this.callerInfos.get(cd.callerInfoField) == null)
/*     */       {
/* 376 */         this.callerInfos.put(cd.callerInfoField, "whatever");
/* 377 */         GeneratedAdvisorCallerTransformer.this.callerInfoAdder.addConByConInfoField(GeneratedAdvisorCallerTransformer.this.getGenadvisor(), cd.callerInfoField, this.callingClass.getName(), cd.callingIndex, cd.classname, cd.calledHash);
/* 378 */         addJoinpoint(cd);
/* 379 */         createGenAdvisorConByConMethod(cd);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void addJoinpoint(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException
/*     */     {
/* 385 */       CtClass joinpoint = createJoinpointClass(cd);
/* 386 */       CtClass genadvisor = GeneratedAdvisorCallerTransformer.this.getInstrumentor().getGenadvisor();
/* 387 */       CtField field = new CtField(joinpoint, ConByConJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingIndex, cd.classname, cd.calledHash), genadvisor);
/*     */ 
/* 391 */       field.setModifiers(4);
/* 392 */       genadvisor.addField(field);
/*     */     }
/*     */ 
/*     */     private CtClass createJoinpointClass(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException
/*     */     {
/* 397 */       return ConByConJoinPointGenerator.createJoinpointBaseClass(GeneratedAdvisorCallerTransformer.this.getInstrumentor(), cd.callingIndex, this.callingClass, cd.calledConstructor, cd.classname, cd.calledHash, cd.callerInfoField);
/*     */     }
/*     */ 
/*     */     private void createGenAdvisorConByConMethod(CallerTransformer.ConByConDetail cd)
/*     */       throws CannotCompileException, NotFoundException
/*     */     {
/* 411 */       int originalLength = cd.calledConstructor.getParameterTypes().length;
/* 412 */       CtClass[] params = new CtClass[originalLength + 1];
/* 413 */       params[0] = this.callingClass;
/* 414 */       System.arraycopy(cd.calledConstructor.getParameterTypes(), 0, params, 1, originalLength);
/*     */ 
/* 416 */       String joinpointName = ConByConJoinPointGenerator.getGeneratedJoinPointFieldName(cd.callingIndex, cd.classname, cd.calledHash);
/* 417 */       String infoName = cd.callerInfoField;
/* 418 */       String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "      return new " + cd.calledConstructor.getDeclaringClass().getName() + "(" + GeneratedAdvisorCallerTransformer.this.getArguments(params.length, 1) + "); " + "   }" + "   else" + "   {" + "      return " + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
/*     */       try
/*     */       {
/* 436 */         CtMethod method = CtNewMethod.make(cd.calledConstructor.getDeclaringClass(), cd.callerInfoField, params, cd.calledConstructor.getExceptionTypes(), code, GeneratedAdvisorCallerTransformer.this.getGenadvisor());
/*     */ 
/* 443 */         GeneratedAdvisorCallerTransformer.this.getGenadvisor().addMethod(method);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 447 */         GeneratedAdvisorCallerTransformer.logger.error("Error for " + cd.callingIndex + " code:" + code);
/* 448 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void replaceMethodCallInCon(CallerTransformer.ConstructorDetail cd) throws CannotCompileException, NotFoundException
/*     */     {
/* 454 */       String advisor = " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")";
/*     */ 
/* 456 */       int paramsLength = cd.calledMethod.getParameterTypes().length;
/* 457 */       String args = null;
/* 458 */       if (Modifier.isStatic(cd.calledMethod.getModifiers()))
/*     */       {
/* 460 */         args = "this" + (paramsLength > 0 ? ", $$" : "");
/*     */       }
/*     */       else
/*     */       {
/* 464 */         args = "$0, this" + (paramsLength > 0 ? ", $$" : "");
/*     */       }
/*     */ 
/* 467 */       String ret = !cd.calledMethod.getReturnType().equals(CtClass.voidType) ? "$_ = " : "";
/*     */ 
/* 469 */       String replaced = ret + advisor + "." + cd.callerInfoField + "(" + args + ");";
/*     */       try
/*     */       {
/* 473 */         cd.call.replace(replaced);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 477 */         GeneratedAdvisorCallerTransformer.logger.error("Error for " + cd.con + " code:" + replaced);
/* 478 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void replaceMethodCallInMethod(CallerTransformer.MethodDetail md) throws NotFoundException, CannotCompileException
/*     */     {
/* 484 */       boolean hasCallingObject = !Modifier.isStatic(md.where.getModifiers());
/* 485 */       boolean hasTargetObject = !Modifier.isStatic(md.calledMethod.getModifiers());
/* 486 */       int paramsLength = md.calledMethod.getParameterTypes().length;
/* 487 */       String args = null;
/* 488 */       if ((hasCallingObject) && (hasTargetObject))
/*     */       {
/* 490 */         args = "$0, this" + (paramsLength > 0 ? ", $$" : "");
/*     */       }
/* 492 */       else if ((!hasCallingObject) && (hasTargetObject))
/*     */       {
/* 494 */         args = "$0" + (paramsLength > 0 ? ", $$" : "");
/*     */       }
/* 496 */       else if ((hasCallingObject) && (!hasTargetObject))
/*     */       {
/* 498 */         args = "this" + (paramsLength > 0 ? ", $$" : "");
/*     */       }
/*     */       else
/*     */       {
/* 502 */         args = "$$";
/*     */       }
/*     */       String advisor;
/*     */       String advisor;
/* 506 */       if (hasCallingObject)
/*     */       {
/* 508 */         advisor = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")";
/*     */       }
/*     */       else
/*     */       {
/* 513 */         advisor = " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "aop$classAdvisor$aop" + ")";
/*     */       }
/* 515 */       String ret = md.calledMethod.getReturnType().equals(CtClass.voidType) ? "" : "$_ = ";
/*     */ 
/* 517 */       String replaced = ret + advisor + "." + md.callerInfoField + "(" + args + ");";
/*     */       try
/*     */       {
/* 521 */         md.call.replace(replaced);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 525 */         GeneratedAdvisorCallerTransformer.logger.error("Error for " + md.where + " code:" + replaced);
/* 526 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void replaceConCallInMethod(CallerTransformer.ConByMethodDetail cd)
/*     */       throws NotFoundException, CannotCompileException
/*     */     {
/* 533 */       int paramsLength = cd.calledConstructor.getParameterTypes().length;
/* 534 */       String args = null;
/* 535 */       String advisor = null;
/* 536 */       if (!Modifier.isStatic(cd.where.getModifiers()))
/*     */       {
/* 538 */         args = "this" + (paramsLength > 0 ? ", $$" : "");
/* 539 */         advisor = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")";
/*     */       }
/*     */       else
/*     */       {
/* 544 */         args = paramsLength > 0 ? "$$" : "";
/* 545 */         advisor = " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "aop$classAdvisor$aop" + ")";
/*     */       }
/*     */ 
/* 548 */       String replaced = "$_ = " + advisor + "." + cd.callerInfoField + "(" + args + ");";
/*     */       try
/*     */       {
/* 552 */         cd.call.replace(replaced);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 556 */         GeneratedAdvisorCallerTransformer.logger.error("Error for " + cd.where + " code:" + replaced);
/* 557 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void replaceConCallInCon(CallerTransformer.ConByConDetail cd) throws CannotCompileException, NotFoundException
/*     */     {
/* 563 */       String advisor = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(this.callingClass) + ")" + "getCurrentAdvisor$aop()" + ")";
/*     */ 
/* 566 */       int paramsLength = cd.calledConstructor.getParameterTypes().length;
/* 567 */       String args = "this" + (paramsLength > 0 ? ", $$" : "");
/* 568 */       String replaced = "$_ = " + advisor + "." + cd.callerInfoField + "(" + args + ");";
/*     */       try
/*     */       {
/* 572 */         cd.call.replace(replaced);
/*     */       }
/*     */       catch (CannotCompileException e)
/*     */       {
/* 576 */         GeneratedAdvisorCallerTransformer.logger.error("Error for " + cd.callingIndex + " code:" + replaced);
/* 577 */         throw e;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.GeneratedAdvisorCallerTransformer
 * JD-Core Version:    0.6.0
 */