/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.util.JavassistMethodHashing;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class GeneratedAdvisorConstructorExecutionTransformer extends ConstructorExecutionTransformer
/*     */ {
/*  46 */   private static final Logger logger = AOPLogger.getLogger(GeneratedAdvisorConstructorExecutionTransformer.class);
/*     */ 
/*     */   public GeneratedAdvisorConstructorExecutionTransformer(Instrumentor instrumentor)
/*     */   {
/*  50 */     super(instrumentor);
/*     */   }
/*     */ 
/*     */   protected boolean addInfoAsWeakReference()
/*     */   {
/*  55 */     return false;
/*     */   }
/*     */ 
/*     */   protected void generateConstructorInfoField(CtClass clazz, CtConstructor constructor, int index) throws CannotCompileException, NotFoundException
/*     */   {
/*  60 */     String ciname = addConstructorInfoField(4, ((GeneratedAdvisorInstrumentor)getInstrumentor()).getGenadvisor(), getConstructorInfoFieldName(clazz.getSimpleName(), index));
/*     */ 
/*  65 */     addJoinpoint(clazz, constructor, ciname, index);
/*     */ 
/*  67 */     long wrapperHash = JavassistMethodHashing.methodHash(clazz.getDeclaredMethod(constructorFactory(clazz.getSimpleName()), constructor.getParameterTypes()));
/*     */ 
/*  71 */     long constructorHash = JavassistMethodHashing.constructorHash(constructor);
/*     */ 
/*  73 */     ((GeneratedAdvisorInstrumentor)getInstrumentor()).initialiseConstructorInfoField(ciname, index, constructorHash, wrapperHash);
/*     */   }
/*     */ 
/*     */   private void addJoinpoint(CtClass clazz, CtConstructor constructor, String ciname, int index) throws CannotCompileException, NotFoundException
/*     */   {
/*  78 */     CtClass joinpoint = createJoinpointClass(clazz, constructor, ciname, index);
/*  79 */     CtClass genadvisor = ((GeneratedAdvisorInstrumentor)getInstrumentor()).getGenadvisor();
/*  80 */     CtField field = new CtField(joinpoint, ConstructorJoinPointGenerator.getGeneratedJoinPointFieldName(clazz.getSimpleName(), index), genadvisor);
/*     */ 
/*  84 */     field.setModifiers(4);
/*  85 */     genadvisor.addField(field);
/*     */   }
/*     */ 
/*     */   private CtClass createJoinpointClass(CtClass clazz, CtConstructor constructor, String ciname, int index) throws CannotCompileException, NotFoundException
/*     */   {
/*  90 */     return ConstructorJoinPointGenerator.createJoinpointBaseClass((GeneratedAdvisorInstrumentor)getInstrumentor(), clazz, constructor, ciname, index);
/*     */   }
/*     */ 
/*     */   protected void initialiseWrapper(int mod, CtConstructor constructor, int index)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 100 */     GeneratedAdvisorInstrumentor instrumentor = (GeneratedAdvisorInstrumentor)getInstrumentor();
/* 101 */     CtClass genadvisor = getGenAdvisor();
/* 102 */     CtClass clazz = constructor.getDeclaringClass();
/*     */ 
/* 104 */     CtClass[] exceptions = constructor.getExceptionTypes();
/* 105 */     CtClass type = constructor.getDeclaringClass();
/*     */ 
/* 107 */     CtMethod innerWmethod = CtNewMethod.make(clazz, getInnerWrapperMethodName(constructor), constructor.getParameterTypes(), exceptions, null, genadvisor);
/*     */ 
/* 114 */     innerWmethod.setModifiers(Modifier.clear(mod, 8));
/* 115 */     setTemporaryWrapperCode(type, innerWmethod);
/* 116 */     genadvisor.addMethod(innerWmethod);
/*     */ 
/* 118 */     CtMethod wmethod = CtNewMethod.make(clazz, constructorFactory(clazz.getSimpleName()), constructor.getParameterTypes(), exceptions, null, clazz);
/*     */ 
/* 125 */     wmethod.setModifiers(mod);
/* 126 */     wmethod.setBody("{return ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")" + "aop$classAdvisor$aop" + ")." + getInnerWrapperMethodName(constructor) + "($$);}");
/*     */ 
/* 128 */     clazz.addMethod(wmethod);
/*     */ 
/* 131 */     getWrapper().prepareForWrapping(constructor, 0);
/*     */   }
/*     */ 
/*     */   protected void setEmptyWrapperCode(CtConstructor constructor) throws NotFoundException
/*     */   {
/* 136 */     CtClass clazz = constructor.getDeclaringClass();
/*     */ 
/* 139 */     String innerCode = "{     return new " + clazz.getName() + "($$); " + "}";
/*     */     try
/*     */     {
/* 145 */       CtMethod innerWrapperMethod = getInnerWrapperMethod(constructor);
/* 146 */       innerWrapperMethod.setBody(innerCode);
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 150 */       logger.error(innerCode);
/* 151 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 156 */       CtMethod outerWrappedMethod = getWrapperMethod(constructor);
/* 157 */       outerWrappedMethod.setBody(outerDelegatingBody(constructor));
/*     */     }
/*     */     catch (CannotCompileException e)
/*     */     {
/* 161 */       logger.error(outerDelegatingBody(constructor));
/* 162 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setEmptyWrapperCodeLater(CtConstructor constructor)
/*     */     throws NotFoundException
/*     */   {
/* 169 */     CtMethod outerWrapperMethod = getWrapperMethod(constructor);
/* 170 */     this.codifier.addPendingCode(outerWrapperMethod, outerDelegatingBody(constructor));
/*     */ 
/* 172 */     CtMethod innerWrapperMethod = getInnerWrapperMethod(constructor);
/* 173 */     String innerCode = "{     return new " + constructor.getDeclaringClass().getName() + "($$); " + "}";
/*     */ 
/* 177 */     this.codifier.addPendingCode(innerWrapperMethod, innerCode);
/*     */   }
/*     */ 
/*     */   private CtMethod getInnerWrapperMethod(CtConstructor constructor) throws NotFoundException
/*     */   {
/* 182 */     CtClass genadvisor = getGenAdvisor();
/* 183 */     return genadvisor.getDeclaredMethod(getInnerWrapperMethodName(constructor), constructor.getParameterTypes());
/*     */   }
/*     */ 
/*     */   private String getInnerWrapperMethodName(CtConstructor constructor)
/*     */   {
/* 191 */     ((GeneratedAdvisorInstrumentor)getInstrumentor()); return constructorFactory(GeneratedAdvisorInstrumentor.getAdvisorName(constructor.getDeclaringClass()));
/*     */   }
/*     */ 
/*     */   private String outerDelegatingBody(CtConstructor constructor)
/*     */   {
/* 196 */     ((GeneratedAdvisorInstrumentor)getInstrumentor()); return "{return ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(constructor.getDeclaringClass()) + ")" + "aop$classAdvisor$aop" + ")." + getInnerWrapperMethodName(constructor) + "($$);}";
/*     */   }
/*     */ 
/*     */   private CtClass getGenAdvisor()
/*     */   {
/* 203 */     return ((GeneratedAdvisorInstrumentor)getInstrumentor()).getGenadvisor();
/*     */   }
/*     */ 
/*     */   protected void createWrapper(ConstructorExecutionTransformer.ConstructorTransformation trans)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 209 */     CtMethod outerWrapper = getWrapperMethod(trans.getConstructor());
/* 210 */     outerWrapper.setBody(outerDelegatingBody(trans.getConstructor()));
/*     */ 
/* 212 */     CtMethod innerWrapper = getInnerWrapperMethod(trans.getConstructor());
/*     */ 
/* 214 */     String joinpointName = ConstructorJoinPointGenerator.getGeneratedJoinPointFieldName(trans.getConstructor().getDeclaringClass().getSimpleName(), trans.getIndex());
/*     */ 
/* 218 */     String infoName = getConstructorInfoFieldName(trans.getConstructor().getDeclaringClass().getSimpleName(), trans.getIndex());
/*     */ 
/* 222 */     String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "      super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "      return new " + trans.getClassName() + "($$); " + "   }" + "   else" + "   {" + "      return " + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
/*     */ 
/* 238 */     this.codifier.addPendingCode(innerWrapper, code);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.GeneratedAdvisorConstructorExecutionTransformer
 * JD-Core Version:    0.6.0
 */